/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.AssistActionHandler;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.android.tools.idea.assistant.datamodel.TutorialData;
import com.android.tools.idea.assistant.view.NavigationButton;
import com.android.tools.idea.assistant.view.StatefulButton;
import com.android.tools.idea.assistant.view.TutorialCard;
import com.android.tools.idea.assistant.view.TutorialChooser;
import com.android.tools.idea.assistant.view.UIUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class FeaturesPanel
extends JPanel
implements ItemListener,
ActionListener {
    private final List<String> myCardKeys;
    private JPanel myCards;
    private CardLayout myCardLayout;
    private AnalyticsProvider myAnalyticsProvider;
    private Project myProject;
    private TutorialMetadata myOpenTutorial;

    public FeaturesPanel(@NotNull TutorialBundleData bundle, @NotNull Project project, @NotNull AnalyticsProvider analyticsProvider) {
        if (bundle == null) {
            FeaturesPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FeaturesPanel.$$$reportNull$$$0(1);
        }
        if (analyticsProvider == null) {
            FeaturesPanel.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        this.myCardKeys = new ArrayList<String>();
        this.myAnalyticsProvider = analyticsProvider;
        this.myProject = project;
        this.setBackground(UIUtils.getBackgroundColor());
        this.myCardLayout = new CardLayout();
        this.myCards = new JPanel(this.myCardLayout);
        this.myCards.setOpaque(false);
        this.myCardLayout.setVgap(0);
        List<? extends FeatureData> featureList = bundle.getFeatures();
        boolean hideChooserAndNavigationalBar = false;
        if (featureList.size() == 1 && featureList.get(0).getTutorials().size() == 1) {
            hideChooserAndNavigationalBar = true;
            FeaturesPanel.getLog().debug("Tutorial chooser and head/bottom navigation bars are hidden because the assistant panel contains only one tutorial.");
        } else {
            this.addCard(new TutorialChooser(this, bundle, this.myAnalyticsProvider, this.myProject), "studio_tutorial_chooser");
        }
        for (FeatureData featureData : bundle.getFeatures()) {
            for (TutorialData tutorialData : featureData.getTutorials()) {
                this.addCard(new TutorialCard(this, tutorialData, featureData, bundle.getName(), this.myProject, hideChooserAndNavigationalBar), tutorialData.getKey());
            }
        }
        this.add(this.myCards);
    }

    private static Logger getLog() {
        return Logger.getInstance(FeaturesPanel.class);
    }

    private void addCard(Component c, String key) {
        this.myCards.add(c, key);
        this.myCardKeys.add(key);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        CardLayout cl = (CardLayout)this.myCards.getLayout();
        cl.show(this.myCards, (String)e.getItem());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof NavigationButton) {
            NavigationButton t = (NavigationButton)e.getSource();
            if (this.myOpenTutorial != null) {
                this.myAnalyticsProvider.trackTutorialClosed(this.myOpenTutorial.getKey(), this.myOpenTutorial.getReadDuration(), this.myProject);
                this.myOpenTutorial = null;
            }
            this.showCard(t.getKey());
        } else if (source instanceof StatefulButton.ActionButton) {
            StatefulButton.ActionButton a = (StatefulButton.ActionButton)e.getSource();
            String actionId = a.getKey();
            AssistActionHandler handler = null;
            for (AssistActionHandler actionHandler : (AssistActionHandler[])AssistActionHandler.EP_NAME.getExtensions()) {
                if (!actionHandler.getId().equals(actionId)) continue;
                handler = actionHandler;
                break;
            }
            if (handler == null) {
                throw new IllegalArgumentException("Unhandled action, no handler found for key \"" + actionId + "\".");
            }
            ActionData actionData = a.getActionData();
            handler.handleAction(actionData, a.getProject());
            a.updateState();
        } else {
            throw new RuntimeException("Unhandled action, \"" + e.getActionCommand() + "\".");
        }
    }

    private void showCard(@NotNull String key) {
        if (key == null) {
            FeaturesPanel.$$$reportNull$$$0(3);
        }
        if (!this.myCardKeys.contains(key)) {
            throw new IllegalArgumentException("No views exist with key: " + key);
        }
        FeaturesPanel.getLog().debug("Received request to navigate to view with key: " + key);
        if (!key.equals("studio_tutorial_chooser")) {
            this.myAnalyticsProvider.trackTutorialOpen(key, this.myProject);
            this.myOpenTutorial = new TutorialMetadata(key);
        }
        this.myCardLayout.show(this.myCards, key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyticsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/assistant/view/FeaturesPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showCard";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class TutorialMetadata {
        private final String myKey;
        private final long myTimeOpenedMs;

        TutorialMetadata(@NotNull String key) {
            if (key == null) {
                TutorialMetadata.$$$reportNull$$$0(0);
            }
            this.myKey = key;
            this.myTimeOpenedMs = System.currentTimeMillis();
        }

        long getReadDuration() {
            return System.currentTimeMillis() - this.myTimeOpenedMs;
        }

        @NotNull
        String getKey() {
            String string = this.myKey;
            if (string == null) {
                TutorialMetadata.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/assistant/view/FeaturesPanel$TutorialMetadata";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/assistant/view/FeaturesPanel$TutorialMetadata";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

