/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class StringResourceParser {
    public static StringResourceData parse(final @NotNull AndroidFacet facet, final @NotNull LocalResourceRepository repository) {
        if (facet == null) {
            StringResourceParser.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            StringResourceParser.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return StringResourceParser.parseUnderReadLock(facet, repository);
        }
        return (StringResourceData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<StringResourceData>(){

            public StringResourceData compute() {
                return StringResourceParser.parseUnderReadLock(facet, repository);
            }
        });
    }

    @NotNull
    private static StringResourceData parseUnderReadLock(AndroidFacet facet, LocalResourceRepository repository) {
        ArrayList keys = Lists.newArrayList((Iterable)repository.getItemsOfType(ResourceType.STRING));
        Collections.sort(keys);
        HashMap<String, StringResource> keyToResourceMap = new HashMap<String, StringResource>();
        Project project = facet.getModule().getProject();
        for (String key : keys) {
            List items = repository.getResourceItem(ResourceType.STRING, key);
            if (items == null) continue;
            StringResource stringResource = new StringResource(key);
            for (ResourceItem item : items) {
                LocaleQualifier qualifier;
                XmlTag tag = LocalResourceRepository.getItemTag(project, item);
                if (tag != null && "false".equals(tag.getAttributeValue("translatable"))) {
                    stringResource.setTranslatable(false);
                }
                String itemStringRepresentation = StringResourceParser.resourceToString(project, item);
                FolderConfiguration config = item.getConfiguration();
                LocaleQualifier localeQualifier = qualifier = config == null ? null : config.getLocaleQualifier();
                if (qualifier == null) {
                    stringResource.setDefaultValue(item, itemStringRepresentation);
                    continue;
                }
                Locale locale = Locale.create(qualifier);
                stringResource.putTranslation(locale, item, itemStringRepresentation);
            }
            keyToResourceMap.put(key, stringResource);
        }
        StringResourceData stringResourceData = new StringResourceData(facet, keyToResourceMap);
        if (stringResourceData == null) {
            StringResourceParser.$$$reportNull$$$0(2);
        }
        return stringResourceData;
    }

    @NotNull
    private static String resourceToString(@NotNull Project project, @NotNull ResourceItem item) {
        String string;
        XmlTag tag;
        if (project == null) {
            StringResourceParser.$$$reportNull$$$0(3);
        }
        if (item == null) {
            StringResourceParser.$$$reportNull$$$0(4);
        }
        if ((tag = LocalResourceRepository.getItemTag(project, item)) == null) {
            ResourceValue value = item.getResourceValue(false);
            if (value == null) {
                if ("" == null) {
                    StringResourceParser.$$$reportNull$$$0(5);
                }
                return "";
            }
            string = value.getRawXmlValue();
        } else {
            string = tag.getValue().getText();
        }
        String string2 = Strings.nullToEmpty((String)ValueXmlHelper.unescapeResourceString((String)string, (boolean)false, (boolean)false));
        if (string2 == null) {
            StringResourceParser.$$$reportNull$$$0(6);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringResourceParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseUnderReadLock";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resourceToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resourceToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

