/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.actions;

import com.android.tools.idea.experimental.actions.PermissionUsageQuickFixRunnable;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionUsageQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public PermissionUsageQuickFix(@Nullable PsiElement element) {
        super(element);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            PermissionUsageQuickFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PermissionUsageQuickFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            PermissionUsageQuickFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            PermissionUsageQuickFix.$$$reportNull$$$0(3);
        }
        PermissionUsageQuickFix.openFile(project, file);
        OpenFileDescriptor fileDesc = new OpenFileDescriptor(project, file.getVirtualFile(), startElement.getTextOffset());
        editor = FileEditorManager.getInstance((Project)project).openTextEditor(fileDesc, true);
        assert (editor != null);
        int startOffset = startElement.getTextOffset();
        int endOffset = endElement.getTextOffset() + endElement.getTextLength();
        editor.getSelectionModel().setSelection(startOffset, endOffset);
        PermissionUsageQuickFixRunnable job = new PermissionUsageQuickFixRunnable(project, editor);
        this.execRunnable(job, "Permission Fix");
    }

    private void execRunnable(@NotNull Runnable job, String title) {
        if (job == null) {
            PermissionUsageQuickFix.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().runWriteAction(job);
    }

    public static void openFile(Project project, PsiFile file) {
        String path = file.getVirtualFile().getCanonicalPath();
        assert (path != null);
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        VirtualFile virtFile = LocalFileSystem.getInstance().findFileByPath(path);
        assert (virtFile != null);
        manager.openFile(virtFile, true, true);
    }

    @NotNull
    public String getText() {
        if ("Insert guards for permission usage" == null) {
            PermissionUsageQuickFix.$$$reportNull$$$0(5);
        }
        return "Insert guards for permission usage";
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Insert permission usage getFamilyName()" == null) {
            PermissionUsageQuickFix.$$$reportNull$$$0(6);
        }
        return "Insert permission usage getFamilyName()";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/experimental/actions/PermissionUsageQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/experimental/actions/PermissionUsageQuickFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execRunnable";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

