/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTreeDependencyModel
extends DependencyModel {
    private static final Logger LOG = Logger.getInstance(FileTreeDependencyModel.class);
    @NonNls
    private static final String FILE_TREE = "fileTree";
    @NonNls
    private static final String DIR = "dir";
    @NonNls
    private static final String INCLUDE = "include";
    @NonNls
    private static final String EXCLUDE = "exclude";
    @NotNull
    private String myConfigurationName;
    @NotNull
    private final GradleDslMethodCall myDslElement;
    @NotNull
    private final GradleDslExpression myDir;
    @Nullable
    private final GradleDslElement myIncludeElement;
    @Nullable
    private final GradleDslElement myExcludeElement;

    static Collection<? extends FileTreeDependencyModel> create(@NotNull String configurationName, @NotNull GradleDslMethodCall methodCall) {
        if (configurationName == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(0);
        }
        if (methodCall == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(1);
        }
        ArrayList result = Lists.newArrayList();
        if (FILE_TREE.equals(methodCall.getName())) {
            List<GradleDslElement> arguments = methodCall.getArguments();
            for (GradleDslElement argument : arguments) {
                if (argument instanceof GradleDslExpression) {
                    result.add(new FileTreeDependencyModel(configurationName, methodCall, (GradleDslExpression)argument, null, null));
                    continue;
                }
                if (!(argument instanceof GradleDslExpressionMap)) continue;
                GradleDslExpressionMap dslMap = (GradleDslExpressionMap)argument;
                GradleDslExpression dirElement = dslMap.getPropertyElement(DIR, GradleDslExpression.class);
                if (dirElement == null) {
                    assert (methodCall.getPsiElement() != null);
                    String msg = String.format("'%1$s' is not a valid file tree dependency", methodCall.getPsiElement().getText());
                    LOG.warn(msg);
                    continue;
                }
                GradleDslElement includeElement = dslMap.getPropertyElement(INCLUDE);
                GradleDslElement excludeElement = dslMap.getPropertyElement(EXCLUDE);
                result.add(new FileTreeDependencyModel(configurationName, methodCall, dirElement, includeElement, excludeElement));
            }
        }
        return result;
    }

    static void createAndAddToList(@NotNull GradleDslElementList list, @NotNull String configurationName, @NotNull String dir, @Nullable List<String> includes, @Nullable List<String> excludes) {
        if (list == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(2);
        }
        if (configurationName == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(3);
        }
        if (dir == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(4);
        }
        String methodName = FILE_TREE;
        GradleDslMethodCall methodCall = new GradleDslMethodCall((GradleDslElement)list, methodName, configurationName);
        if ((includes == null || includes.isEmpty()) && (excludes == null || excludes.isEmpty())) {
            GradleDslLiteral directory = new GradleDslLiteral(methodCall, methodName);
            directory.setValue(dir);
            methodCall.addNewArgument(directory);
        } else {
            GradleDslExpressionMap mapArguments = new GradleDslExpressionMap(methodCall, methodName);
            mapArguments.setNewLiteral(DIR, dir);
            if (includes != null && !includes.isEmpty()) {
                if (includes.size() == 1) {
                    mapArguments.setNewLiteral(INCLUDE, includes.get(0));
                } else {
                    for (String include : includes) {
                        mapArguments.addToNewLiteralList(INCLUDE, include);
                    }
                }
            }
            if (excludes != null && !excludes.isEmpty()) {
                if (excludes.size() == 1) {
                    mapArguments.setNewLiteral(EXCLUDE, excludes.get(0));
                } else {
                    for (String exclude : excludes) {
                        mapArguments.addToNewLiteralList(EXCLUDE, exclude);
                    }
                }
            }
            methodCall.addNewArgument(mapArguments);
        }
        list.addNewElement(methodCall);
    }

    private FileTreeDependencyModel(@NotNull String configurationName, @NotNull GradleDslMethodCall dslElement, @NotNull GradleDslExpression dir, @Nullable GradleDslElement includeElement, @Nullable GradleDslElement excludeElement) {
        if (configurationName == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(5);
        }
        if (dslElement == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(6);
        }
        if (dir == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(7);
        }
        this.myConfigurationName = configurationName;
        this.myDslElement = dslElement;
        this.myDir = dir;
        this.myIncludeElement = includeElement;
        this.myExcludeElement = excludeElement;
    }

    @Override
    @NotNull
    protected GradleDslElement getDslElement() {
        GradleDslMethodCall gradleDslMethodCall = this.myDslElement;
        if (gradleDslMethodCall == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(8);
        }
        return gradleDslMethodCall;
    }

    @Override
    @NotNull
    public String configurationName() {
        String string = this.myConfigurationName;
        if (string == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public GradleNotNullValue<String> dir() {
        String dir = this.myDir.getValue(String.class);
        assert (dir != null);
        GradleNotNullValue<String> gradleNotNullValue = new GradleNotNullValue<String>(this.myDir, dir);
        if (gradleNotNullValue == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(10);
        }
        return gradleNotNullValue;
    }

    public void setDir(@NotNull String dir) {
        if (dir == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(11);
        }
        this.myDir.setValue(dir);
    }

    @NotNull
    public List<GradleNotNullValue<String>> includes() {
        List<GradleNotNullValue<String>> list = FileTreeDependencyModel.getStringValues(this.myIncludeElement);
        if (list == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public List<GradleNotNullValue<String>> excludes() {
        List<GradleNotNullValue<String>> list = FileTreeDependencyModel.getStringValues(this.myExcludeElement);
        if (list == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private static List<GradleNotNullValue<String>> getStringValues(@Nullable GradleDslElement expressionOrList) {
        String value;
        if (expressionOrList instanceof GradleDslExpressionList) {
            List<GradleNotNullValue<String>> list = ((GradleDslExpressionList)expressionOrList).getValues(String.class);
            if (list == null) {
                FileTreeDependencyModel.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (expressionOrList instanceof GradleDslExpression && (value = ((GradleDslExpression)expressionOrList).getValue(String.class)) != null) {
            List<GradleNotNullValue<String>> list = Collections.singletonList(new GradleNotNullValue<String>(expressionOrList, value));
            if (list == null) {
                FileTreeDependencyModel.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<GradleNotNullValue<String>> list = Collections.emptyList();
        if (list == null) {
            FileTreeDependencyModel.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = DIR;
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/dependencies/FileTreeDependencyModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/dependencies/FileTreeDependencyModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDslElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "configurationName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = DIR;
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "includes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "excludes";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddToList";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

