/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.treeview;

import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsNode;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ui.SimpleTextAttributes;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPsModelNode<T extends PsModel>
extends AbstractPsNode {
    @NotNull
    private final List<T> myModels;

    @SafeVarargs
    protected AbstractPsModelNode(@NotNull AbstractPsNode parent, T ... models) {
        if (parent == null) {
            AbstractPsModelNode.$$$reportNull$$$0(0);
        }
        if (models == null) {
            AbstractPsModelNode.$$$reportNull$$$0(1);
        }
        super(parent);
        this.myModels = Lists.newArrayList((Object[])models);
        this.updateNameAndIcon();
    }

    @SafeVarargs
    protected AbstractPsModelNode(T ... models) {
        if (models == null) {
            AbstractPsModelNode.$$$reportNull$$$0(2);
        }
        this.myModels = Lists.newArrayList((Object[])models);
        this.updateNameAndIcon();
    }

    protected AbstractPsModelNode(@NotNull AbstractPsNode parent, @NotNull List<T> models) {
        if (parent == null) {
            AbstractPsModelNode.$$$reportNull$$$0(3);
        }
        if (models == null) {
            AbstractPsModelNode.$$$reportNull$$$0(4);
        }
        super(parent);
        this.myModels = models;
        this.updateNameAndIcon();
    }

    protected AbstractPsModelNode(@NotNull List<T> models) {
        if (models == null) {
            AbstractPsModelNode.$$$reportNull$$$0(5);
        }
        this.myModels = models;
        this.updateNameAndIcon();
    }

    protected void updateNameAndIcon() {
        int modelCount = this.myModels.size();
        if (modelCount != 0) {
            PsModel first = (PsModel)this.myModels.get(0);
            if (modelCount == 1) {
                this.myName = this.nameOf(first);
            } else {
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < modelCount; ++i) {
                    PsModel model = (PsModel)this.myModels.get(i);
                    buffer.append(this.nameOf(model));
                    if (i >= modelCount - 1) continue;
                    buffer.append(", ");
                }
                this.myName = buffer.toString();
            }
            this.setIcon(first.getIcon());
        }
    }

    @NotNull
    protected String nameOf(T model) {
        String string = ((PsModel)model).getName();
        if (string == null) {
            AbstractPsModelNode.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public List<T> getModels() {
        List<T> list = this.myModels;
        if (list == null) {
            AbstractPsModelNode.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public T getFirstModel() {
        assert (!this.myModels.isEmpty());
        PsModel psModel = (PsModel)this.myModels.get(0);
        if (psModel == null) {
            AbstractPsModelNode.$$$reportNull$$$0(8);
        }
        return (T)psModel;
    }

    public boolean matches(@NotNull PsModel model) {
        if (model == null) {
            AbstractPsModelNode.$$$reportNull$$$0(9);
        }
        for (PsModel m : this.myModels) {
            if (!m.equals(model)) continue;
            return true;
        }
        return false;
    }

    protected void doUpdate() {
        PresentationData presentation = this.getTemplatePresentation();
        presentation.clearText();
        presentation.addText(this.myName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/ui/treeview/AbstractPsModelNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/treeview/AbstractPsModelNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "nameOf";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModels";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

