/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.GridLayoutDetector;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidLintGridLayoutInspection
extends AndroidLintInspectionBase {
    public AndroidLintGridLayoutInspection() {
        super(AndroidBundle.message("android.lint.inspections.grid.layout", new Object[0]), GridLayoutDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(final @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            AndroidLintGridLayoutInspection.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            AndroidLintGridLayoutInspection.$$$reportNull$$$0(1);
        }
        if (message == null) {
            AndroidLintGridLayoutInspection.$$$reportNull$$$0(2);
        }
        String obsolete = GridLayoutDetector.getOldValue((String)message, (TextFormat)TextFormat.RAW);
        String available = GridLayoutDetector.getNewValue((String)message, (TextFormat)TextFormat.RAW);
        if (obsolete != null && available != null) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Update to " + available, obsolete, available){

                @Override
                protected void editBefore(@NotNull Document document) {
                    if (document == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Project project = startElement.getProject();
                    XmlFile file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlFile.class);
                    if (file != null) {
                        AndroidResourceUtil.ensureNamespaceImported(file, "http://schemas.android.com/apk/res-auto", null);
                        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/android/tools/idea/lint/AndroidLintGridLayoutInspection$1", "editBefore"));
                }
            }};
            if (androidLintQuickFixArray == null) {
                AndroidLintGridLayoutInspection.$$$reportNull$$$0(3);
            }
            return androidLintQuickFixArray;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            AndroidLintGridLayoutInspection.$$$reportNull$$$0(4);
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/AndroidLintGridLayoutInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/AndroidLintGridLayoutInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

