/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidManifestFileNode
extends PsiFileNode
implements DirectoryGroupNode {
    @NotNull
    private final AndroidFacet myFacet;

    public AndroidManifestFileNode(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull ViewSettings settings, @NotNull AndroidFacet facet) {
        if (project == null) {
            AndroidManifestFileNode.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            AndroidManifestFileNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            AndroidManifestFileNode.$$$reportNull$$$0(2);
        }
        if (facet == null) {
            AndroidManifestFileNode.$$$reportNull$$$0(3);
        }
        super(project, psiFile, settings);
        this.myFacet = facet;
    }

    public void update(PresentationData data) {
        super.update(data);
        PsiFile file = (PsiFile)this.getValue();
        if (file == null) {
            return;
        }
        IdeaSourceProvider sourceProvider = AndroidManifestFileNode.getSourceProvider(this.myFacet, file);
        if (sourceProvider != null && !"main".equals(sourceProvider.getName())) {
            data.addText(file.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            data.addText(" (" + sourceProvider.getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            data.setPresentableText(file.getName());
        }
    }

    @Nullable
    public static IdeaSourceProvider getSourceProvider(@NotNull AndroidFacet facet, @NotNull PsiFile file) {
        if (facet == null) {
            AndroidManifestFileNode.$$$reportNull$$$0(4);
        }
        if (file == null) {
            AndroidManifestFileNode.$$$reportNull$$$0(5);
        }
        for (IdeaSourceProvider provider : AndroidProjectViewPane.getSourceProviders(facet)) {
            if (!file.getVirtualFile().equals(provider.getManifestFile())) continue;
            return provider;
        }
        return null;
    }

    @Nullable
    public Comparable getSortKey() {
        PsiFile file = (PsiFile)this.getValue();
        if (file == null) {
            return "";
        }
        IdeaSourceProvider sourceProvider = AndroidManifestFileNode.getSourceProvider(this.myFacet, file);
        if (sourceProvider == null || "main".equals(sourceProvider.getName())) {
            return "";
        }
        return sourceProvider.getName();
    }

    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        if (PsiDirectory.EMPTY_ARRAY == null) {
            AndroidManifestFileNode.$$$reportNull$$$0(6);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiFile file = (PsiFile)this.getValue();
        if (file == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(file.getName());
        sb.append(" (");
        sb.append(AndroidManifestFileNode.getSourceProvider(this.myFacet, (PsiFile)this.getValue()).getName());
        sb.append(")");
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/AndroidManifestFileNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/AndroidManifestFileNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSourceProvider";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

