/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.actions.NewAndroidComponentAction;
import com.android.tools.idea.npw.AddAndroidActivityPath;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.TemplateEntry;
import com.android.tools.idea.npw.TemplateListProvider;
import com.android.tools.idea.npw.ThemeHelper;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.ui.ASGallery;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithDescription;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Function;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivityGalleryStep
extends DynamicWizardStepWithDescription {
    private static final ScopedStateStore.Key<TemplateEntry[]> KEY_TEMPLATES = ScopedStateStore.createKey("template.list", ScopedStateStore.Scope.STEP, TemplateEntry[].class);
    @NotNull
    private final FormFactor myFormFactor;
    private final ScopedStateStore.Key<TemplateEntry> myCurrentSelectionKey;
    private final boolean myShowSkipEntry;
    private final Module myModule;
    private boolean myAppThemeExists;
    private ASGallery<Optional<TemplateEntry>> myGallery;

    public ActivityGalleryStep(@NotNull FormFactor formFactor, boolean showSkipEntry, @NotNull ScopedStateStore.Key<TemplateEntry> currentSelectionKey, @Nullable Module module, @NotNull Disposable disposable) {
        if (formFactor == null) {
            ActivityGalleryStep.$$$reportNull$$$0(0);
        }
        if (currentSelectionKey == null) {
            ActivityGalleryStep.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            ActivityGalleryStep.$$$reportNull$$$0(2);
        }
        super(disposable);
        this.myFormFactor = formFactor;
        this.myCurrentSelectionKey = currentSelectionKey;
        this.myShowSkipEntry = showSkipEntry;
        this.myModule = module;
        this.setBodyComponent(this.createGallery());
    }

    private JComponent createGallery() {
        this.myGallery = new ASGallery();
        Dimension thumbnailSize = WizardConstants.DEFAULT_GALLERY_THUMBNAIL_SIZE;
        this.myGallery.setThumbnailSize(thumbnailSize);
        this.myGallery.setMinimumSize(new Dimension(thumbnailSize.width * 2 + 1, thumbnailSize.height));
        this.myGallery.setLabelProvider(new Function<Optional<TemplateEntry>, String>(){

            public String apply(Optional<TemplateEntry> template) {
                if (template.isPresent()) {
                    return template.get().getTitle();
                }
                return "Add No Activity";
            }
        });
        this.myGallery.setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicWizard wizard = ActivityGalleryStep.this.getWizard();
                assert (wizard != null);
                wizard.doNextAction();
            }
        });
        this.myGallery.setImageProvider(new Function<Optional<TemplateEntry>, Image>(){

            public Image apply(Optional<TemplateEntry> input) {
                return input.isPresent() ? input.get().getImage() : null;
            }
        });
        this.myGallery.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ActivityGalleryStep.this.saveState((JComponent)((Object)ActivityGalleryStep.this.myGallery));
            }
        });
        this.myGallery.setName("Templates Gallery");
        AccessibleContext accessibleContext = this.myGallery.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleDescription(this.getStepTitle());
        }
        JPanel panel = new JPanel((LayoutManager)new JBCardLayout());
        panel.add("only card", (Component)new JBScrollPane(this.myGallery));
        return panel;
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        UiNotifyConnector.doWhenFirstShown(this.myGallery, (Runnable)new Runnable(){

            @Override
            public void run() {
                ActivityGalleryStep.this.myGallery.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
        this.myAppThemeExists = this.myState.getNotNull(WizardConstants.IS_NEW_PROJECT_KEY, false);
        if (this.myModule != null) {
            ThemeHelper themeHelper = new ThemeHelper(this.myModule);
            this.myAppThemeExists = themeHelper.getAppThemeName() != null;
        }
    }

    @Override
    public boolean isStepVisible() {
        return this.myState.getNotNull(WizardConstants.IS_LIBRARY_KEY, false) == false && super.isStepVisible();
    }

    @Override
    public boolean validate() {
        TemplateEntry template = this.myState.get(this.myCurrentSelectionKey);
        PageStatus status = template == null ? (this.myShowSkipEntry ? PageStatus.OK : PageStatus.NOTHING_SELECTED) : (this.isIncompatibleMinSdk(template) ? PageStatus.INCOMPATIBLE_MAIN_SDK : (this.isIncompatibleBuildApi(template) ? PageStatus.INCOMPATIBLE_BUILD_API : (this.isMissingAppTheme(template) ? PageStatus.MISSING_THEME : PageStatus.OK)));
        this.setErrorHtml(status.formatMessage(template));
        return status.isPageValid();
    }

    private boolean isIncompatibleBuildApi(@NotNull TemplateEntry template) {
        Integer buildSdkLevel;
        if (template == null) {
            ActivityGalleryStep.$$$reportNull$$$0(3);
        }
        return (buildSdkLevel = this.myState.get(FormFactorUtils.getBuildApiLevelKey(this.myFormFactor))) != null && buildSdkLevel < template.getMinBuildApi();
    }

    private boolean isIncompatibleMinSdk(@NotNull TemplateEntry template) {
        Integer minSdkLevel;
        if (template == null) {
            ActivityGalleryStep.$$$reportNull$$$0(4);
        }
        return (minSdkLevel = this.myState.get(FormFactorUtils.getMinApiLevelKey(this.myFormFactor))) != null && minSdkLevel < template.getMinSdk();
    }

    private boolean isMissingAppTheme(@NotNull TemplateEntry template) {
        if (template == null) {
            ActivityGalleryStep.$$$reportNull$$$0(5);
        }
        return !this.myAppThemeExists && template.getMetadata().isAppThemeRequired();
    }

    @Override
    public void init() {
        super.init();
        TemplateListProvider templateListProvider = new TemplateListProvider(this.myFormFactor, NewAndroidComponentAction.NEW_WIZARD_CATEGORIES, TemplateManager.EXCLUDED_TEMPLATES);
        TemplateEntry[] list = templateListProvider.deriveValue(this.myState, AddAndroidActivityPath.KEY_IS_LAUNCHER, null);
        this.myGallery.setModel(JBList.createDefaultListModel((Object[])this.wrapInOptionals(list)));
        this.myState.put(KEY_TEMPLATES, list);
        if (list.length != 0) {
            int i = ActivityGalleryStep.indexOfTemplateWithTitle(list, "Empty Activity");
            this.myState.put(this.myCurrentSelectionKey, list[i == -1 ? 0 : i]);
        }
        this.register(this.myCurrentSelectionKey, this.myGallery, new ScopedDataBinder.ComponentBinding<TemplateEntry, ASGallery<Optional<TemplateEntry>>>(){

            @Override
            public void setValue(TemplateEntry newValue, @NotNull ASGallery<Optional<TemplateEntry>> component) {
                if (component == null) {
                    6.$$$reportNull$$$0(0);
                }
                component.setSelectedElement(Optional.ofNullable(newValue));
            }

            @Override
            @Nullable
            public TemplateEntry getValue(@NotNull ASGallery<Optional<TemplateEntry>> component) {
                Optional<TemplateEntry> selection;
                if (component == null) {
                    6.$$$reportNull$$$0(1);
                }
                if ((selection = component.getSelectedElement()) != null && selection.isPresent()) {
                    return selection.get();
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "component";
                objectArray2[1] = "com/android/tools/idea/npw/ActivityGalleryStep$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getValue";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.register(KEY_TEMPLATES, this.myGallery, new ScopedDataBinder.ComponentBinding<TemplateEntry[], ASGallery<Optional<TemplateEntry>>>(){

            @Override
            public void setValue(@Nullable TemplateEntry[] newValue, @NotNull ASGallery<Optional<TemplateEntry>> component) {
                if (component == null) {
                    7.$$$reportNull$$$0(0);
                }
                component.setModel(JBList.createDefaultListModel((Object[])ActivityGalleryStep.this.wrapInOptionals(newValue)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/ActivityGalleryStep$7", "setValue"));
            }
        });
        this.registerValueDeriver(KEY_TEMPLATES, templateListProvider);
    }

    private Optional[] wrapInOptionals(@Nullable TemplateEntry[] newValue) {
        int i;
        Optional[] model;
        if (newValue == null) {
            return new Optional[0];
        }
        if (this.myShowSkipEntry) {
            model = new Optional[newValue.length + 1];
            model[0] = Optional.empty();
            i = 1;
        } else {
            model = new Optional[newValue.length];
            i = 0;
        }
        for (TemplateEntry entry : newValue) {
            model[i++] = Optional.of(entry);
        }
        return model;
    }

    private static int indexOfTemplateWithTitle(@NotNull TemplateEntry[] entries, @NotNull String title) {
        if (entries == null) {
            ActivityGalleryStep.$$$reportNull$$$0(6);
        }
        if (title == null) {
            ActivityGalleryStep.$$$reportNull$$$0(7);
        }
        for (int i = 0; i < entries.length; ++i) {
            if (!title.equals(entries[i].getMetadata().getTitle())) continue;
            return i;
        }
        return -1;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGallery;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Activity Gallery" == null) {
            ActivityGalleryStep.$$$reportNull$$$0(8);
        }
        return "Activity Gallery";
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        String string = "Add an Activity to " + this.myFormFactor.id;
        if (string == null) {
            ActivityGalleryStep.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return null;
    }

    @Override
    @Nullable
    protected Icon getStepIcon() {
        return this.myFormFactor.getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSelectionKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/ActivityGalleryStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/ActivityGalleryStep";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatibleBuildApi";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatibleMinSdk";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMissingAppTheme";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "indexOfTemplateWithTitle";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum PageStatus {
        OK,
        INCOMPATIBLE_BUILD_API,
        INCOMPATIBLE_MAIN_SDK,
        MISSING_THEME,
        NOTHING_SELECTED;


        public boolean isPageValid() {
            return this == OK;
        }

        @Nullable
        public String formatMessage(TemplateEntry template) {
            switch (this) {
                case OK: {
                    return null;
                }
                case INCOMPATIBLE_BUILD_API: {
                    return String.format("Selected activity template has a minimum build API level of %d.", template.getMinBuildApi());
                }
                case INCOMPATIBLE_MAIN_SDK: {
                    return String.format("Selected activity template has a minimum SDK level of %d.", template.getMinSdk());
                }
                case MISSING_THEME: {
                    return "Selected activity template requires an existing Application Theme";
                }
                case NOTHING_SELECTED: {
                    return "No activity template was selected.";
                }
            }
            throw new IllegalArgumentException(this.name());
        }
    }
}

