/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.ide.common.repository.GradleVersion;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.ActivityGalleryStep;
import com.android.tools.idea.npw.module.ConfigureAndroidModuleStep;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.npw.template.ConfigureTemplateParametersStep;
import com.android.tools.idea.npw.template.RenderTemplateModel;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.templates.SupportLibrary;
import com.android.tools.idea.ui.ASGallery;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.android.tools.swing.util.FormScalingUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseActivityTypeStep
extends SkippableWizardStep<NewModuleModel> {
    private static final String WH_SDK_ENV_VAR = "WH_SDK";
    private final RenderTemplateModel myRenderModel;
    @NotNull
    private TemplateHandle[] myTemplateList;
    @NotNull
    private List<AndroidSourceSet> mySourceSets;
    @NotNull
    private ASGallery<TemplateHandle> myActivityGallery;
    @NotNull
    private JComponent myRootPanel;
    @Nullable
    private AndroidFacet myFacet;

    public ChooseActivityTypeStep(@NotNull NewModuleModel moduleModel, @NotNull RenderTemplateModel renderModel, @NotNull List<TemplateHandle> templateList, @NotNull List<AndroidSourceSet> sourceSets) {
        if (moduleModel == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(0);
        }
        if (renderModel == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(1);
        }
        if (templateList == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(2);
        }
        if (sourceSets == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(3);
        }
        this(moduleModel, renderModel);
        this.init(templateList, sourceSets, null);
    }

    public ChooseActivityTypeStep(@NotNull NewModuleModel moduleModel, @NotNull RenderTemplateModel renderModel, @NotNull AndroidFacet facet, @NotNull List<TemplateHandle> templateList, @NotNull VirtualFile targetDirectory) {
        if (moduleModel == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(4);
        }
        if (renderModel == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(5);
        }
        if (facet == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(6);
        }
        if (templateList == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(7);
        }
        if (targetDirectory == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(8);
        }
        this(moduleModel, renderModel);
        List<AndroidSourceSet> sourceSets = AndroidSourceSet.getSourceSets(facet, targetDirectory);
        this.init(templateList, sourceSets, facet);
    }

    private ChooseActivityTypeStep(@NotNull NewModuleModel moduleModel, @NotNull RenderTemplateModel renderModel) {
        if (moduleModel == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(9);
        }
        if (renderModel == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(10);
        }
        super(moduleModel, "Add an Activity to " + renderModel.getTemplateHandle().getMetadata().getFormFactor());
        this.myRenderModel = renderModel;
    }

    private void init(@NotNull List<TemplateHandle> templateList, @NotNull List<AndroidSourceSet> sourceSets, @Nullable AndroidFacet facet) {
        if (templateList == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(11);
        }
        if (sourceSets == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(12);
        }
        this.myTemplateList = templateList.toArray(new TemplateHandle[templateList.size()]);
        this.mySourceSets = sourceSets;
        this.myActivityGallery = ChooseActivityTypeStep.createGallery(this.getTitle());
        this.myRootPanel = new JBScrollPane(this.myActivityGallery);
        FormScalingUtil.scaleComponentTree(this.getClass(), this.myRootPanel);
        this.myFacet = facet;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JComponent jComponent = this.myRootPanel;
        if (jComponent == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(13);
        }
        return jComponent;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myActivityGallery;
    }

    @Override
    @NotNull
    public Collection<? extends ModelWizardStep> createDependentSteps() {
        String title = AndroidBundle.message("android.wizard.config.activity.title", new Object[0]);
        ArrayList arrayList = Lists.newArrayList((Object[])new ConfigureTemplateParametersStep[]{new ConfigureTemplateParametersStep(this.myRenderModel, title, this.mySourceSets, this.myFacet)});
        if (arrayList == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static ASGallery<TemplateHandle> createGallery(String title) {
        ASGallery<TemplateHandle> gallery = new ASGallery<TemplateHandle>((ListModel)JBList.createDefaultListModel((Object[])new Object[0]), ChooseActivityTypeStep::getImage, ChooseActivityTypeStep::getTemplateTitle, WizardConstants.DEFAULT_GALLERY_THUMBNAIL_SIZE, null){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension cellSize = this.computeCellSize();
                int heightInsets = this.getInsets().top + this.getInsets().bottom;
                int widthInsets = this.getInsets().left + this.getInsets().right;
                return new Dimension(cellSize.width * 5 + widthInsets, (int)((double)cellSize.height * 2.2) + heightInsets);
            }
        };
        gallery.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        gallery.getAccessibleContext().setAccessibleDescription(title);
        return gallery;
    }

    @Override
    protected void onWizardStarting(final @NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(15);
        }
        this.myActivityGallery.setModel(JBList.createDefaultListModel((Object[])this.myTemplateList));
        this.myActivityGallery.setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                wizard.goForward();
            }
        });
        this.myActivityGallery.addListSelectionListener(listSelectionEvent -> {
            TemplateHandle selectedTemplate = this.myActivityGallery.getSelectedElement();
            if (selectedTemplate != null) {
                this.myRenderModel.setTemplateHandle(selectedTemplate);
            }
        });
        int defaultSelection = ChooseActivityTypeStep.getDefaultSelectedTemplateIndex(this.myTemplateList);
        this.myActivityGallery.setSelectedIndex(defaultSelection);
    }

    @Override
    protected void onProceeding() {
        ((NewModuleModel)this.getModel()).getRenderTemplateValues().setValue(this.myRenderModel.getTemplateValues());
        Map<String, Object> moduleTemplateValue = ((NewModuleModel)this.getModel()).getTemplateValues();
        ChooseActivityTypeStep.initTemplateValues(moduleTemplateValue, ((NewModuleModel)this.getModel()).getProject().getValueOrNull());
        moduleTemplateValue.put("appTitle", ((NewModuleModel)this.getModel()).applicationName().get());
    }

    private static void initTemplateValues(@NotNull Map<String, Object> templateValues, @Nullable Project project) {
        File sdkLocation;
        AndroidSdkHandler sdkHandler;
        BuildToolInfo buildTool;
        String mavenUrl;
        if (templateValues == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(16);
        }
        templateValues.put("gradlePluginVersion", ChooseActivityTypeStep.determineGradlePluginVersion(project));
        templateValues.put("gradleVersion", "3.3");
        templateValues.put("isGradle", true);
        templateValues.put("target.files", new HashSet());
        templateValues.put("files.to.open", new ArrayList());
        String whSdkLocation = System.getenv(WH_SDK_ENV_VAR);
        templateValues.put("whSdkPath", whSdkLocation + "/tools/resources/shared-libs");
        templateValues.put("whSdkEnabled", StringUtil.isNotEmpty((String)whSdkLocation));
        templateValues.put("alsoCreateIapk", false);
        templateValues.put("isInstantApp", false);
        templateValues.put("createActivity", false);
        templateValues.put("perModuleRepositories", false);
        if (project != null) {
            templateValues.put("topOut", project.getBasePath());
        }
        if ((mavenUrl = System.getProperty("android.mavenRepoUrl")) != null) {
            templateValues.put("mavenUrl", mavenUrl);
        }
        if ((buildTool = (sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler()).getLatestBuildTool((ProgressIndicator)new StudioLoggerProgressIndicator(ConfigureAndroidModuleStep.class), false)) != null) {
            templateValues.put("buildToolsVersion", buildTool.getRevision().toString());
        }
        if ((sdkLocation = sdkHandler.getLocation()) != null) {
            templateValues.put("sdkDir", FileUtil.toSystemIndependentName((String)sdkLocation.getPath()));
            String espressoVersion = RepositoryUrlManager.get().getLibraryRevision(SupportLibrary.ESPRESSO_CORE.getGroupId(), SupportLibrary.ESPRESSO_CORE.getArtifactId(), null, false, sdkLocation, FileOpUtils.create());
            if (espressoVersion != null) {
                templateValues.put("espressoVersion", espressoVersion);
            }
        }
    }

    @NotNull
    private static String determineGradlePluginVersion(@Nullable Project project) {
        String defaultGradleVersion = AndroidPluginGeneration.ORIGINAL.getLatestKnownVersion();
        if (project == null) {
            String string = defaultGradleVersion;
            if (string == null) {
                ChooseActivityTypeStep.$$$reportNull$$$0(17);
            }
            return string;
        }
        GradleVersion versionInUse = GradleUtil.getAndroidGradleModelVersionInUse(project);
        if (versionInUse != null) {
            String string = versionInUse.toString();
            if (string == null) {
                ChooseActivityTypeStep.$$$reportNull$$$0(18);
            }
            return string;
        }
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.searchInBuildFilesOnly(project);
        GradleVersion pluginVersion = androidPluginInfo == null ? null : androidPluginInfo.getPluginVersion();
        String string = pluginVersion == null ? defaultGradleVersion : pluginVersion.toString();
        if (string == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Nullable
    private static Image getImage(TemplateHandle template) {
        String thumb = template.getMetadata().getThumbnailPath();
        if (thumb != null && !thumb.isEmpty()) {
            try {
                File file = new File(template.getRootPath(), thumb.replace('/', File.separatorChar));
                return file.isFile() ? ImageIO.read(file) : null;
            }
            catch (IOException e) {
                Logger.getInstance(ActivityGalleryStep.class).warn((Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    private static String getTemplateTitle(TemplateHandle templateHandle) {
        String string = templateHandle == null ? "<none>" : templateHandle.getMetadata().getTitle();
        if (string == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static int getDefaultSelectedTemplateIndex(@NotNull TemplateHandle[] templateList) {
        if (templateList == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(21);
        }
        for (int i = 0; i < templateList.length; ++i) {
            if (!ChooseActivityTypeStep.getTemplateTitle(templateList[i]).equals("Empty Activity")) continue;
            return i;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderModel";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateList";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSets";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/template/ChooseActivityTypeStep";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/template/ChooseActivityTypeStep";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "determineGradlePluginVersion";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "initTemplateValues";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSelectedTemplateIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

