/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.templates.Parameter;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateMetadata {
    public static final String ATTR_PARENT_ACTIVITY_CLASS = "parentActivityClass";
    public static final String ATTR_ACTIVITY_TITLE = "activityTitle";
    public static final String ATTR_IS_LAUNCHER = "isLauncher";
    public static final String ATTR_IS_LIBRARY_MODULE = "isLibraryProject";
    public static final String ATTR_CREATE_ICONS = "createIcons";
    public static final String ATTR_COPY_ICONS = "copyIcons";
    public static final String ATTR_TARGET_API = "targetApi";
    public static final String ATTR_TARGET_API_STRING = "targetApiString";
    public static final String ATTR_MIN_API = "minApi";
    public static final String ATTR_MIN_BUILD_API = "minBuildApi";
    public static final String ATTR_BUILD_API = "buildApi";
    public static final String ATTR_BUILD_API_STRING = "buildApiString";
    public static final String ATTR_APPTHEME_REQUIRED = "requireAppTheme";
    public static final String ATTR_REVISION = "revision";
    public static final String ATTR_MIN_API_LEVEL = "minApiLevel";
    public static final String ATTR_PACKAGE_NAME = "packageName";
    public static final String ATTR_PACKAGE_ROOT = "packageRoot";
    public static final String ATTR_RELATIVE_PACKAGE = "relativePackage";
    public static final String ATTR_APP_TITLE = "appTitle";
    public static final String ATTR_BASE_THEME = "baseTheme";
    public static final String ATTR_IS_NEW_PROJECT = "isNewProject";
    public static final String ATTR_IS_GRADLE = "isGradle";
    public static final String ATTR_TOP_OUT = "topOut";
    public static final String ATTR_PROJECT_OUT = "projectOut";
    public static final String ATTR_SRC_OUT = "srcOut";
    public static final String ATTR_RES_OUT = "resOut";
    public static final String ATTR_MANIFEST_OUT = "manifestOut";
    public static final String ATTR_TEST_OUT = "testOut";
    public static final String ATTR_MAVEN_URL = "mavenUrl";
    public static final String ATTR_SRC_DIR = "srcDir";
    public static final String ATTR_RES_DIR = "resDir";
    public static final String ATTR_MANIFEST_DIR = "manifestDir";
    public static final String ATTR_TEST_DIR = "testDir";
    public static final String ATTR_AIDL_DIR = "aidlDir";
    public static final String ATTR_AIDL_OUT = "aidlOut";
    public static final String ATTR_DEBUG_KEYSTORE_SHA1 = "debugKeystoreSha1";
    public static final String ATTR_BUILD_TOOLS_VERSION = "buildToolsVersion";
    public static final String ATTR_GRADLE_PLUGIN_VERSION = "gradlePluginVersion";
    public static final String ATTR_GRADLE_VERSION = "gradleVersion";
    public static final String ATTR_JAVA_VERSION = "javaVersion";
    public static final String ATTR_SDK_DIR = "sdkDir";
    public static final String ATTR_PER_MODULE_REPOS = "perModuleRepositories";
    public static final String ATTR_ICON_NAME = "iconName";
    public static final String ATTR_APPLICATION_PACKAGE = "applicationPackage";
    public static final String ATTR_SOURCE_PROVIDER_NAME = "sourceProviderName";
    public static final String ATTR_MODULE_NAME = "projectName";
    public static final String ATTR_CREATE_ACTIVITY = "createActivity";
    public static final String ATTR_INCLUDE_FORM_FACTOR = "included";
    public static final String ATTR_IS_LOW_MEMORY = "isLowMemory";
    public static final String ATTR_CPP_FLAGS = "cppFlags";
    public static final String ATTR_CPP_SUPPORT = "includeCppSupport";
    public static final String ATTR_DEPENDENCIES_MULTIMAP = "dependenciesMultimap";
    public static final String ATTR_FRAGMENTS_EXTRA = "usesFragments";
    public static final String ATTR_ACTION_BAR_EXTRA = "usesActionBar";
    public static final String ATTR_GRID_LAYOUT_EXTRA = "usesGridLayout";
    public static final String ATTR_NAVIGATION_DRAWER_EXTRA = "usesNavigationDrawer";
    public static final String ATTR_WH_SDK = "whSdkPath";
    public static final String ATTR_APP_DOMAIN = "supportedDomain";
    public static final String ATTR_ATOM_NAME = "atomName";
    public static final String ATTR_ATOM_ROUTE = "atomRoute";
    public static final String ATTR_IS_INSTANT_APP = "isInstantApp";
    public static final String ATTR_IS_BASE_ATOM = "isBaseAtom";
    public static final String ATTR_SPLIT_NAME = "splitName";
    public static final String TAG_CATEGORY = "category";
    public static final String TAG_FORMFACTOR = "formfactor";
    private final Document myDocument;
    private final Map<String, Parameter> myParameterMap;
    private final AndroidIconType myIconType;
    private final String myIconName;
    private String myFormFactor;
    private String myCategory;
    private final Multimap<Parameter, Parameter> myRelatedParameters;

    public TemplateMetadata(@NotNull Document document) {
        Element element;
        NodeList formFactors;
        Element element2;
        if (document == null) {
            TemplateMetadata.$$$reportNull$$$0(0);
        }
        this.myDocument = document;
        NodeList parameters = this.myDocument.getElementsByTagName("parameter");
        this.myParameterMap = new LinkedHashMap<String, Parameter>(parameters.getLength());
        int max = parameters.getLength();
        for (int index = 0; index < max; ++index) {
            element2 = (Element)parameters.item(index);
            Parameter parameter = new Parameter(this, element2);
            if (parameter.id == null) continue;
            this.myParameterMap.put(parameter.id, parameter);
        }
        NodeList icons = this.myDocument.getElementsByTagName("icons");
        if (icons.getLength() > 0) {
            Element element3 = (Element)icons.item(0);
            if (element3.hasAttribute("type")) {
                String iconTypeName = element3.getAttribute("type").toUpperCase(Locale.US);
                this.myIconType = AndroidIconType.valueOf(iconTypeName);
            } else {
                this.myIconType = null;
            }
            this.myIconName = element3.getAttribute("name");
        } else {
            this.myIconType = null;
            this.myIconName = null;
        }
        NodeList categories = this.myDocument.getElementsByTagName(TAG_CATEGORY);
        if (categories.getLength() > 0 && (element2 = (Element)categories.item(0)).hasAttribute("value")) {
            this.myCategory = element2.getAttribute("value");
        }
        if ((formFactors = this.myDocument.getElementsByTagName(TAG_FORMFACTOR)).getLength() > 0 && (element = (Element)formFactors.item(0)).hasAttribute("value")) {
            this.myFormFactor = element.getAttribute("value");
        }
        this.myRelatedParameters = this.computeRelatedParameters();
    }

    private Multimap<Parameter, Parameter> computeRelatedParameters() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Parameter p : this.myParameterMap.values()) {
            for (Parameter p2 : this.myParameterMap.values()) {
                if (p == p2 || !p.isRelated(p2)) continue;
                builder.put((Object)p, (Object)p2);
            }
        }
        return builder.build();
    }

    @Nullable
    public String getTitle() {
        return this.getAttrNonEmpty("name");
    }

    @Nullable
    public String getDescription() {
        return this.getAttrNonEmpty("description");
    }

    public int getMinSdk() {
        return this.getInteger(ATTR_MIN_API, 1);
    }

    public int getMinBuildApi() {
        return this.getInteger(ATTR_MIN_BUILD_API, 1);
    }

    public int getRevision() {
        return this.getInteger(ATTR_REVISION, 1);
    }

    public boolean isAppThemeRequired() {
        return this.getBoolean(ATTR_APPTHEME_REQUIRED, false);
    }

    @Nullable
    public String getCategory() {
        return this.myCategory;
    }

    @Nullable
    public String getFormFactor() {
        return this.myFormFactor;
    }

    @Nullable
    public AndroidIconType getIconType() {
        return this.myIconType;
    }

    @Nullable
    public String getIconName() {
        return this.myIconName;
    }

    @Nullable
    public String getThumbnailPath() {
        return this.getThumbnailPath(null);
    }

    @Nullable
    public String getThumbnailPath(Function<String, Object> produceParameterValue) {
        NodeList thumbs = this.myDocument.getElementsByTagName("thumb");
        if (thumbs.getLength() == 0) {
            return null;
        }
        int bestMatchCount = 0;
        Node bestMatch = null;
        int n = thumbs.getLength();
        for (int i = 0; i < n; ++i) {
            Element thumb = (Element)thumbs.item(i);
            NamedNodeMap attributes = thumb.getAttributes();
            if (bestMatch == null && attributes.getLength() == 0) {
                bestMatch = thumb;
                continue;
            }
            if (attributes.getLength() <= bestMatchCount) continue;
            boolean match = true;
            int max = attributes.getLength();
            for (int j = 0; j < max; ++j) {
                Attr attribute = (Attr)attributes.item(j);
                String variableName = attribute.getName();
                String thumbNailValue = attribute.getValue();
                if (produceParameterValue != null && thumbNailValue.equals(produceParameterValue.apply((Object)variableName))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            bestMatch = thumb;
            bestMatchCount = attributes.getLength();
        }
        if (bestMatch != null) {
            NodeList children = bestMatch.getChildNodes();
            int n2 = children.getLength();
            for (int i = 0; i < n2; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3) continue;
                return child.getNodeValue().trim();
            }
        }
        return null;
    }

    public boolean isSupported() {
        String versionString = this.myDocument.getDocumentElement().getAttribute("format");
        if (versionString != null && !versionString.isEmpty()) {
            try {
                int version = Integer.parseInt(versionString);
                return version <= 5;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    public boolean useImplicitRootFolder() {
        String format = this.myDocument.getDocumentElement().getAttribute("format");
        if (format == null || format.isEmpty()) {
            return true;
        }
        try {
            int version = Integer.parseInt(format);
            return version < 5;
        }
        catch (NumberFormatException ignore) {
            return true;
        }
    }

    @NotNull
    public Collection<Parameter> getParameters() {
        Collection<Parameter> collection = this.myParameterMap.values();
        if (collection == null) {
            TemplateMetadata.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    public Parameter getParameter(@NotNull String id) {
        if (id == null) {
            TemplateMetadata.$$$reportNull$$$0(2);
        }
        return this.myParameterMap.get(id);
    }

    @Nullable
    private String getAttrNonEmpty(@NotNull String attrName) {
        String attr;
        if (attrName == null) {
            TemplateMetadata.$$$reportNull$$$0(3);
        }
        return (attr = this.myDocument.getDocumentElement().getAttribute(attrName)) == null || attr.isEmpty() ? null : attr;
    }

    private int getInteger(@NotNull String attrName, int defaultValue) {
        if (attrName == null) {
            TemplateMetadata.$$$reportNull$$$0(4);
        }
        try {
            return Integer.parseInt(this.myDocument.getDocumentElement().getAttribute(attrName));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    private boolean getBoolean(@NotNull String attrName, boolean defaultValue) {
        String value;
        if (attrName == null) {
            TemplateMetadata.$$$reportNull$$$0(5);
        }
        return (value = this.myDocument.getDocumentElement().getAttribute(attrName)) == null ? defaultValue : "true".equals(value);
    }

    @NotNull
    public static String getBuildApiString(@NotNull AndroidVersion version) {
        if (version == null) {
            TemplateMetadata.$$$reportNull$$$0(6);
        }
        String string = version.isPreview() ? AndroidTargetHash.getPlatformHashString((AndroidVersion)version) : version.getApiString();
        if (string == null) {
            TemplateMetadata.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public Collection<Parameter> getRelatedParams(Parameter param) {
        Collection collection = this.myRelatedParameters.get((Object)param);
        if (collection == null) {
            TemplateMetadata.$$$reportNull$$$0(8);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/TemplateMetadata";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/TemplateMetadata";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildApiString";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttrNonEmpty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInteger";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBuildApiString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

