/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.android.tools.idea.rendering.ImageUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ASGallery<E>
extends JBList {
    private static final Insets DEFAULT_CELL_MARGIN = new Insets(1, 1, 1, 1);
    @NotNull
    private Insets myCellMargin;
    @NotNull
    private JBDimension myThumbnailSize;
    @NotNull
    private Function<? super E, String> myLabelProvider;
    @Nullable
    private LoadingCache<E, Optional<Image>> myImagesCache;
    @NotNull
    private Map<E, CellRenderer> myCellRenderers;
    @Nullable
    private Action myDefaultAction;

    public ASGallery() {
        this(new DefaultListModel(), Functions.constant(null), Functions.toStringFunction(), new Dimension(0, 0), null);
    }

    public ASGallery(@NotNull ListModel model, @NotNull Function<? super E, Image> imageProvider, @NotNull Function<? super E, String> labelProvider, @NotNull Dimension thumbnailSize, @Nullable Action defaultAction) {
        if (model == null) {
            ASGallery.$$$reportNull$$$0(0);
        }
        if (imageProvider == null) {
            ASGallery.$$$reportNull$$$0(1);
        }
        if (labelProvider == null) {
            ASGallery.$$$reportNull$$$0(2);
        }
        if (thumbnailSize == null) {
            ASGallery.$$$reportNull$$$0(3);
        }
        this.myCellMargin = DEFAULT_CELL_MARGIN;
        this.myCellRenderers = Maps.newHashMap();
        this.myThumbnailSize = JBDimension.create((Dimension)thumbnailSize);
        this.myLabelProvider = labelProvider;
        this.myDefaultAction = defaultAction;
        Font listFont = UIUtil.getListFont();
        if (listFont != null) {
            this.setFont(listFont);
        }
        this.setImageProvider(imageProvider);
        this.setLabelProvider(labelProvider);
        this.setModel(model);
        this.setThumbnailSize(thumbnailSize);
        this.setSelectionMode(0);
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(-1);
        this.setOpaque(true);
        this.setFocusable(true);
        this.setCellRenderer(new GalleryCellRenderer());
        this.setBackground(UIUtil.getListBackground());
        this.installListeners();
        this.installKeyboardActions();
        TreeUIHelper.getInstance().installListSpeedSearch((JList)((Object)this), (Convertor)new Convertor<Object, String>(){

            public String convert(Object o) {
                return (String)ASGallery.this.myLabelProvider.apply(o);
            }
        });
    }

    private void installListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension cellSize = ASGallery.this.computeCellSize();
                ASGallery.this.setFixedCellWidth(cellSize.width);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = ASGallery.this.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                ASGallery.this.ensureIndexIsVisible(index);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1 && ASGallery.this.myDefaultAction != null) {
                    int index = ASGallery.this.getSelectedIndex();
                    if (index < 0) {
                        return;
                    }
                    Rectangle bounds = ASGallery.this.getCellBounds(index, index);
                    if (bounds.contains(e.getPoint())) {
                        ASGallery.this.myDefaultAction.actionPerformed(new ActionEvent(e.getSource(), 0, null));
                    }
                }
            }
        });
    }

    private void installKeyboardActions() {
        String previousListElementKey;
        String nextListElementKey;
        this.getActionMap().put("nextListElement", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ASGallery.this.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                if (++index >= ASGallery.this.getModel().getSize()) {
                    return;
                }
                ASGallery.this.setSelectedIndex(index);
                ASGallery.this.ensureIndexIsVisible(index);
            }
        });
        this.getActionMap().put("previousListElement", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ASGallery.this.getSelectedIndex();
                if (index <= 0) {
                    return;
                }
                ASGallery.this.setSelectedIndex(--index);
                ASGallery.this.ensureIndexIsVisible(index);
            }
        });
        if (this.getComponentOrientation().isLeftToRight()) {
            nextListElementKey = "RIGHT";
            previousListElementKey = "LEFT";
        } else {
            nextListElementKey = "LEFT";
            previousListElementKey = "RIGHT";
        }
        this.getInputMap(0).put(KeyStroke.getKeyStroke(nextListElementKey), "nextListElement");
        this.getInputMap(0).put(KeyStroke.getKeyStroke("KP_" + nextListElementKey), "nextListElement");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(previousListElementKey), "previousListElement");
        this.getInputMap(0).put(KeyStroke.getKeyStroke("KP_" + previousListElementKey), "previousListElement");
    }

    public void setModel(ListModel model) {
        int oldSelectIndex = this.getSelectedIndex();
        super.setModel(model);
        if (this.myImagesCache != null) {
            this.myImagesCache.invalidateAll();
        }
        this.myCellRenderers.clear();
        if (oldSelectIndex >= 0) {
            this.setSelectedIndex(oldSelectIndex);
            this.ensureIndexIsVisible(oldSelectIndex);
        }
    }

    public void setThumbnailSize(Dimension thumbnailSize) {
        this.myThumbnailSize = JBDimension.create((Dimension)thumbnailSize);
        this.recomputeCellSize();
    }

    public void setDefaultAction(@NotNull Action action) {
        if (action == null) {
            ASGallery.$$$reportNull$$$0(4);
        }
        this.myDefaultAction = action;
    }

    private void recomputeCellSize() {
        Dimension cellSize = this.computeCellSize();
        this.setFixedCellWidth(cellSize.width);
        this.setFixedCellHeight(cellSize.height);
        this.invalidate();
        this.repaint();
    }

    protected Dimension computeCellSize() {
        int listWidth = this.getSize().width - this.getInsets().left - this.getInsets().right;
        int preferredWidth = this.myThumbnailSize.width + this.myCellMargin.left + this.myCellMargin.right;
        int columnCount = listWidth / preferredWidth;
        int width = columnCount == 0 ? preferredWidth : listWidth / columnCount - 1;
        int textHeight = this.getFont().getSize();
        int height = this.myThumbnailSize.height + this.myCellMargin.top + this.myCellMargin.bottom + 2 * textHeight;
        return new Dimension(width, height);
    }

    public void setCellMargin(@Nullable Insets cellMargin) {
        Insets insets = cellMargin = cellMargin == null ? DEFAULT_CELL_MARGIN : cellMargin;
        if (!Objects.equal((Object)cellMargin, (Object)this.myCellMargin)) {
            Insets oldCellMargin = this.myCellMargin;
            this.myCellMargin = cellMargin;
            this.recomputeCellSize();
            this.firePropertyChange("cellMargin", oldCellMargin, cellMargin);
        }
    }

    public void setImageProvider(final @NotNull Function<? super E, Image> imageProvider) {
        if (imageProvider == null) {
            ASGallery.$$$reportNull$$$0(5);
        }
        Function scaledImageProvider = new Function<E, Image>(){

            @Nullable
            public Image apply(@Nullable E input) {
                Image img = (Image)imageProvider.apply(input);
                if (img == null) {
                    return null;
                }
                BufferedImage image = ImageUtil.toBufferedImage((Image)img);
                if (image.getHeight() <= 0 || image.getWidth() <= 0) {
                    return null;
                }
                double xScale = (double)((ASGallery)ASGallery.this).myThumbnailSize.width / (double)image.getWidth();
                double yScale = (double)((ASGallery)ASGallery.this).myThumbnailSize.height / (double)image.getHeight();
                return ImageUtils.scale(image, xScale, yScale);
            }
        };
        CacheLoader cacheLoader = CacheLoader.from(ToOptionalFunction.wrap(scaledImageProvider));
        this.myImagesCache = CacheBuilder.newBuilder().weakKeys().build(cacheLoader);
        this.repaint(this.getVisibleRect());
    }

    public void setLabelProvider(@NotNull Function<? super E, String> labelProvider) {
        if (labelProvider == null) {
            ASGallery.$$$reportNull$$$0(6);
        }
        this.myLabelProvider = labelProvider;
    }

    public void setSelectedElement(E selectedElement) {
        this.setSelectedValue(selectedElement, true);
    }

    @Nullable
    public E getSelectedElement() {
        return (E)this.getSelectedValue();
    }

    @Nullable
    private Image getCellImage(E element) {
        try {
            Optional image = (Optional)this.myImagesCache.get(element);
            return image.orElse(null);
        }
        catch (ExecutionException e) {
            Logger.getInstance(((Object)((Object)this)).getClass()).error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private String getCellLabel(E element) {
        return (String)this.myLabelProvider.apply(element);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return JBUI.scale((int)10);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.computeCellSize().height;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageProvider";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thumbnailSize";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/ui/ASGallery";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setDefaultAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setImageProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setLabelProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TextAndImageCellRenderer
    extends AbstractCellRenderer {
        private JPanel myPanel;
        private JLabel myLabel;

        public TextAndImageCellRenderer(Font font, String label, Image image) {
            ImageIcon icon = new ImageIcon(image, label);
            JLabel imageLabel = new JLabel(icon);
            JLabel textLabel = new JLabel(label, 0);
            textLabel.setHorizontalTextPosition(0);
            int hPadding = font.getSize() / 3;
            Border padding = BorderFactory.createEmptyBorder(hPadding, 0, hPadding, 0);
            textLabel.setBorder(padding);
            JPanel panel = new JPanel();
            panel.setFocusable(true);
            panel.setOpaque(false);
            panel.setLayout(new BorderLayout());
            panel.add(imageLabel);
            panel.add((Component)textLabel, "Last");
            panel.getAccessibleContext().setAccessibleName(textLabel.getAccessibleContext().getAccessibleName());
            panel.getAccessibleContext().setAccessibleDescription(textLabel.getAccessibleContext().getAccessibleDescription());
            this.myPanel = panel;
            this.myLabel = textLabel;
        }

        @Override
        public void updateAppearance() {
            this.setSelectionBorder(this.myPanel);
            this.setLabelBackground(this.myLabel);
            this.setLabelForeground(this.myLabel);
        }

        @Override
        public Component getComponent() {
            return this.myPanel;
        }

        public void setLabelBackground(JLabel label) {
            if (this.myIsSelected) {
                label.setBackground(UIUtil.getTreeSelectionBackground((boolean)this.myCellHasFocus));
                label.setOpaque(true);
            } else {
                label.setBackground(null);
                label.setOpaque(false);
            }
        }

        public void setLabelForeground(JLabel label) {
            Color labelForeground = this.myIsSelected && this.myCellHasFocus ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeForeground();
            label.setForeground(labelForeground);
        }
    }

    private static class TextOnlyCellRenderer
    extends AbstractCellRenderer {
        private JLabel myLabel;

        public TextOnlyCellRenderer(String label) {
            JLabel jlabel = new JLabel(label);
            jlabel.setHorizontalAlignment(0);
            jlabel.setForeground(UIUtil.getTreeForeground());
            jlabel.setFocusable(true);
            this.myLabel = jlabel;
        }

        @Override
        public void updateAppearance() {
            this.setSelectionBorder(this.myLabel);
        }

        @Override
        public Component getComponent() {
            return this.myLabel;
        }
    }

    private static abstract class AbstractCellRenderer
    implements CellRenderer {
        private boolean myIsInitialized;
        protected boolean myIsSelected;
        protected boolean myCellHasFocus;

        private AbstractCellRenderer() {
        }

        @Override
        public abstract Component getComponent();

        @Override
        public void setAppearance(boolean isSelected, boolean cellHasFocus) {
            if (this.myIsInitialized && isSelected == this.myIsSelected && cellHasFocus == this.myCellHasFocus) {
                return;
            }
            this.myIsInitialized = true;
            this.myIsSelected = isSelected;
            this.myCellHasFocus = cellHasFocus;
            this.updateAppearance();
        }

        protected abstract void updateAppearance();

        protected void setSelectionBorder(JComponent component) {
            if (this.myIsSelected) {
                component.setBorder(new LineBorder(UIUtil.getTreeSelectionBackground((boolean)this.myCellHasFocus)));
            } else {
                component.setBorder(null);
            }
        }
    }

    private static interface CellRenderer {
        public void setAppearance(boolean var1, boolean var2);

        public Component getComponent();
    }

    class GalleryCellRenderer
    implements ListCellRenderer {
        GalleryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jlist, Object value, int cellIndex, boolean isSelected, boolean cellHasFocus) {
            Object element = value;
            CellRenderer renderer = (CellRenderer)ASGallery.this.myCellRenderers.get(element);
            if (renderer == null) {
                renderer = this.createCellRendererComponent(element);
                ASGallery.this.myCellRenderers.put(element, renderer);
            }
            renderer.setAppearance(isSelected, cellHasFocus);
            return renderer.getComponent();
        }

        public CellRenderer createCellRendererComponent(E element) {
            Image image = ASGallery.this.getCellImage(element);
            String label = ASGallery.this.getCellLabel(element);
            if (image == null) {
                return new TextOnlyCellRenderer(label);
            }
            return new TextAndImageCellRenderer(ASGallery.this.getFont(), label, image);
        }
    }

    private static final class ToOptionalFunction<P, R>
    implements Function<P, Optional<R>> {
        private final Function<P, R> myFunction;

        public ToOptionalFunction(Function<P, R> function) {
            this.myFunction = function;
        }

        public static <P, R> Function<P, Optional<R>> wrap(Function<P, R> function) {
            return new ToOptionalFunction<P, R>(function);
        }

        public Optional<R> apply(P input) {
            Object result = this.myFunction.apply(input);
            return Optional.ofNullable(result);
        }
    }
}

