/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.ptable;

import com.android.tools.idea.uibuilder.property.ptable.PTableCellEditor;
import com.android.tools.idea.uibuilder.property.ptable.PTableCellEditorProvider;
import com.android.tools.idea.uibuilder.property.ptable.PTableGroupItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableModel;
import com.android.tools.idea.uibuilder.property.ptable.StarState;
import com.android.tools.idea.uibuilder.property.ptable.renderers.PNameRenderer;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PTable
extends JBTable
implements DataProvider,
DeleteProvider,
CutProvider,
CopyProvider,
PasteProvider {
    private final PNameRenderer myNameRenderer;
    private final TableSpeedSearch mySpeedSearch;
    private PTableModel myModel;
    private CopyPasteManager myCopyPasteManager;
    private PTableCellEditorProvider myEditorProvider;
    private int myMouseHoverRow;
    private int myMouseHoverCol;
    private Point myMouseHoverPoint;

    public PTable(@NotNull PTableModel model) {
        if (model == null) {
            PTable.$$$reportNull$$$0(0);
        }
        this(model, CopyPasteManager.getInstance());
    }

    PTable(@NotNull PTableModel model, @NotNull CopyPasteManager copyPasteManager) {
        if (model == null) {
            PTable.$$$reportNull$$$0(1);
        }
        if (copyPasteManager == null) {
            PTable.$$$reportNull$$$0(2);
        }
        super((TableModel)model);
        this.myNameRenderer = new PNameRenderer();
        this.myModel = model;
        this.myCopyPasteManager = copyPasteManager;
        this.myMouseHoverPoint = new Point(-1, -1);
        this.setMaxItemsForSizeCalculation(5);
        this.setExpandableItemsEnabled(false);
        this.setShowColumns(false);
        this.setAutoResizeMode(3);
        this.setSelectionMode(0);
        this.setShowVerticalLines(true);
        this.setIntercellSpacing(new Dimension(0, 1));
        this.setGridColor(UIUtil.getSlightlyDarkerColor((Color)this.getBackground()));
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.addMouseListener(new MouseTableListener());
        HoverListener hoverListener = new HoverListener();
        this.addMouseMotionListener(hoverListener);
        this.addMouseListener(hoverListener);
        this.mySpeedSearch = new TableSpeedSearch((JTable)((Object)this), (object, cell) -> {
            if (cell.column != 0) {
                return null;
            }
            return object instanceof PTableItem ? ((PTableItem)object).getName() : null;
        });
    }

    public void setModel(@NotNull TableModel model) {
        if (model == null) {
            PTable.$$$reportNull$$$0(3);
        }
        this.myModel = (PTableModel)model;
        super.setModel(model);
    }

    public void setEditorProvider(PTableCellEditorProvider editorProvider) {
        this.myEditorProvider = editorProvider;
    }

    public boolean surrendersFocusOnKeyStroke() {
        return false;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 0) {
            return this.myNameRenderer;
        }
        PTableItem value = (PTableItem)this.getValueAt(row, column);
        return value.getCellRenderer();
    }

    public PTableCellEditor getCellEditor(int row, int column) {
        PTableItem value = (PTableItem)this.getValueAt(row, column);
        if (value != null && this.myEditorProvider != null) {
            return this.myEditorProvider.getCellEditor(value);
        }
        return null;
    }

    public TableSpeedSearch getSpeedSearch() {
        return this.mySpeedSearch;
    }

    public boolean isHover(int row, int col) {
        return row == this.myMouseHoverRow && col == this.myMouseHoverCol;
    }

    @NotNull
    public Point getHoverPosition() {
        Point point = this.myMouseHoverPoint;
        if (point == null) {
            PTable.$$$reportNull$$$0(4);
        }
        return point;
    }

    public void setUI(TableUI ui) {
        super.setUI(ui);
        this.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
        this.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
        ActionMap actionMap = this.getActionMap();
        InputMap focusedInputMap = this.getInputMap(0);
        InputMap ancestorInputMap = this.getInputMap(1);
        focusedInputMap.put(KeyStroke.getKeyStroke(10, 0), "smartEnter");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(10, 0));
        actionMap.put("smartEnter", new MyEnterAction(false));
        focusedInputMap.put(KeyStroke.getKeyStroke(32, 0), "toggleEditor");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(10, 0));
        actionMap.put("toggleEditor", new MyEnterAction(true));
        ancestorInputMap.remove(KeyStroke.getKeyStroke(39, 0));
        ancestorInputMap.remove(KeyStroke.getKeyStroke(227, 0));
        focusedInputMap.put(KeyStroke.getKeyStroke(39, 0), "expandCurrentRight");
        focusedInputMap.put(KeyStroke.getKeyStroke(227, 0), "expandCurrentRight");
        actionMap.put("expandCurrentRight", new MyExpandCurrentAction(true));
        ancestorInputMap.remove(KeyStroke.getKeyStroke(37, 0));
        ancestorInputMap.remove(KeyStroke.getKeyStroke(226, 0));
        focusedInputMap.put(KeyStroke.getKeyStroke(37, 0), "collapseCurrentLeft");
        focusedInputMap.put(KeyStroke.getKeyStroke(226, 0), "collapseCurrentLeft");
        actionMap.put("collapseCurrentLeft", new MyExpandCurrentAction(false));
    }

    private void toggleTreeNode(int row) {
        PTableItem item = (PTableItem)this.getValueAt(row, 0);
        int index = this.convertRowIndexToModel(row);
        if (item.isExpanded()) {
            this.myModel.collapse(index);
        } else {
            this.myModel.expand(index);
        }
    }

    private void toggleStar(int row) {
        PTableItem item = (PTableItem)this.getValueAt(row, 0);
        StarState state = item.getStarState();
        if (state != StarState.NOT_STAR_ABLE) {
            item.setStarState(state.opposite());
        }
    }

    private void selectRow(int row) {
        this.getSelectionModel().setSelectionInterval(row, row);
        TableUtil.scrollSelectionToVisible((JTable)((Object)this));
    }

    private void quickEdit(int row) {
        PTableCellEditor editor = this.getCellEditor(row, 0);
        if (editor == null) {
            return;
        }
        if (editor.isBooleanEditor()) {
            this.startEditing(row);
        }
    }

    private void startEditing(int row) {
        PTableCellEditor editor = this.getCellEditor(row, 0);
        if (editor == null) {
            return;
        }
        this.editCellAt(row, 1);
        JComponent preferredComponent = this.getComponentToFocus(editor);
        if (preferredComponent == null) {
            return;
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
            preferredComponent.requestFocusInWindow();
            editor.activate();
        });
    }

    @Nullable
    private JComponent getComponentToFocus(PTableCellEditor editor) {
        JComponent preferredComponent = editor.getPreferredFocusComponent();
        if (preferredComponent == null) {
            preferredComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)((JComponent)this.editorComp));
        }
        if (preferredComponent == null) {
            return null;
        }
        return preferredComponent;
    }

    public void restoreSelection(int previousSelectedRow, @Nullable PTableItem previousSelectedItem) {
        int selectedRow = 0;
        if (previousSelectedItem != null) {
            PTableItem item;
            PTableItem pTableItem = item = previousSelectedRow >= 0 && previousSelectedRow < this.getRowCount() ? (PTableItem)this.getValueAt(previousSelectedRow, 0) : null;
            if (Objects.equals(item, previousSelectedItem)) {
                selectedRow = previousSelectedRow;
            } else {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    item = (PTableItem)this.getValueAt(row, 0);
                    if (!item.equals(previousSelectedItem)) continue;
                    selectedRow = row;
                    break;
                }
            }
        }
        if (selectedRow < this.getRowCount()) {
            this.addRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    @Nullable
    public PTableItem getSelectedItem() {
        int selectedRow = this.getSelectedRow();
        if (this.isEditing() || selectedRow == -1) {
            return null;
        }
        return (PTableItem)this.getValueAt(selectedRow, 0);
    }

    @Nullable
    private PTableItem getSelectedNonGroupItem() {
        PTableItem item = this.getSelectedItem();
        return item instanceof PTableGroupItem ? null : item;
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(5);
        }
        return this.getSelectedNonGroupItem() != null;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(6);
        }
        return true;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        PTableItem item;
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(7);
        }
        if ((item = this.getSelectedNonGroupItem()) == null) {
            return;
        }
        this.myCopyPasteManager.setContents((Transferable)new StringSelection(item.getValue()));
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(8);
        }
        return this.getSelectedNonGroupItem() != null;
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(9);
        }
        return true;
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(10);
        }
        if (this.getSelectedNonGroupItem() == null) {
            return;
        }
        this.performCopy(dataContext);
        this.deleteElement(dataContext);
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(11);
        }
        return this.getSelectedItem() != null;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        PTableItem item;
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(12);
        }
        if ((item = this.getSelectedItem()) == null) {
            return;
        }
        if (item instanceof PTableGroupItem) {
            PTable.deleteGroupValues(dataContext, (PTableGroupItem)item);
        } else {
            item.setValue(null);
        }
    }

    private static void deleteGroupValues(@NotNull DataContext dataContext, final @NotNull PTableGroupItem group) {
        Project project;
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(13);
        }
        if (group == null) {
            PTable.$$$reportNull$$$0(14);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file == null) {
            return;
        }
        PsiFile containingFile = PsiManager.getInstance((Project)project).findFile(file);
        if (containingFile == null) {
            return;
        }
        new WriteCommandAction.Simple(project, "Delete " + group.getName(), new PsiFile[]{containingFile}){

            protected void run() throws Throwable {
                group.getChildren().forEach(item -> item.setValue(null));
            }
        }.execute();
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(15);
        }
        if (this.getSelectedNonGroupItem() == null) {
            return false;
        }
        Transferable transferable = this.myCopyPasteManager.getContents();
        return transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(16);
        }
        return true;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        PTableItem item;
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(17);
        }
        if ((item = this.getSelectedNonGroupItem()) == null) {
            return;
        }
        Transferable transferable = this.myCopyPasteManager.getContents();
        if (transferable == null || !transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        try {
            item.setValue(transferable.getTransferData(DataFlavor.stringFlavor));
        }
        catch (UnsupportedFlavorException | IOException exception) {
            Logger.getInstance(PTable.class).warn((Throwable)exception);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyPasteManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/ptable/PTable";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/ptable/PTable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHoverPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCutEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCutVisible";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performCut";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deleteGroupValues";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class HoverListener
    extends MouseAdapter {
        private int myPreviousHoverRow = -1;
        private int myPreviousHoverCol = -1;

        private HoverListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            PTable.this.myMouseHoverPoint = e.getPoint();
            PTable.this.myMouseHoverRow = PTable.this.rowAtPoint(e.getPoint());
            if (PTable.this.myMouseHoverRow >= 0) {
                PTable.this.myMouseHoverCol = PTable.this.columnAtPoint(e.getPoint());
            }
            if (this.myPreviousHoverRow != -1 && (this.myPreviousHoverRow != PTable.this.myMouseHoverRow || this.myPreviousHoverCol != PTable.this.myMouseHoverCol)) {
                PTable.this.repaint(PTable.this.getCellRect(this.myPreviousHoverRow, this.myPreviousHoverCol, true));
                this.myPreviousHoverRow = -1;
            }
            if (PTable.this.myMouseHoverCol < 0) {
                return;
            }
            PTable.this.repaint(PTable.this.getCellRect(PTable.this.myMouseHoverRow, PTable.this.myMouseHoverCol, true));
            this.myPreviousHoverRow = PTable.this.myMouseHoverRow;
            this.myPreviousHoverCol = PTable.this.myMouseHoverCol;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (PTable.this.myMouseHoverRow != -1 && PTable.this.myMouseHoverCol != -1) {
                Rectangle cellRect = PTable.this.getCellRect(PTable.this.myMouseHoverRow, 1, true);
                PTable.this.myMouseHoverRow = (PTable.this.myMouseHoverCol = -1);
                PTable.this.repaint(cellRect);
            }
        }
    }

    private class MouseTableListener
    extends MouseAdapter {
        private MouseTableListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Rectangle rectRightColumn;
            int row = PTable.this.rowAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            PTableItem item = (PTableItem)PTable.this.getValueAt(row, 0);
            Rectangle rectLeftColumn = PTable.this.getCellRect(row, PTable.this.convertColumnIndexToView(0), false);
            if (rectLeftColumn.contains(e.getX(), e.getY())) {
                if (PNameRenderer.hitTestTreeNodeIcon(item, e.getX() - rectLeftColumn.x) && item.hasChildren()) {
                    PTable.this.toggleTreeNode(row);
                    return;
                }
                if (PNameRenderer.hitTestStarIcon(e.getX() - rectLeftColumn.x)) {
                    PTable.this.toggleStar(row);
                    return;
                }
            }
            if ((rectRightColumn = PTable.this.getCellRect(row, PTable.this.convertColumnIndexToView(1), false)).contains(e.getX(), e.getY())) {
                item.mousePressed(e, rectRightColumn);
            }
        }
    }

    private class MyExpandCurrentAction
    extends AbstractAction {
        private final boolean myExpand;

        public MyExpandCurrentAction(boolean expand) {
            this.myExpand = expand;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PTable.this.getSelectedRow();
            if (PTable.this.isEditing() || selectedRow == -1) {
                return;
            }
            PTableItem item = (PTableItem)PTable.this.getValueAt(selectedRow, 0);
            int index = PTable.this.convertRowIndexToModel(selectedRow);
            if (this.myExpand) {
                if (item.hasChildren() && !item.isExpanded()) {
                    PTable.this.myModel.expand(index);
                    PTable.this.selectRow(selectedRow);
                }
            } else if (item.isExpanded()) {
                PTable.this.myModel.collapse(index);
                PTable.this.selectRow(selectedRow);
            } else if (item.getParent() != null) {
                PTable.this.selectRow(PTable.this.myModel.getParent(index));
            }
        }
    }

    private class MyEnterAction
    extends AbstractAction {
        private final boolean myToggleOnly;

        public MyEnterAction(boolean toggleOnly) {
            this.myToggleOnly = toggleOnly;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PTable.this.getSelectedRow();
            if (PTable.this.isEditing() || selectedRow == -1) {
                return;
            }
            PTableItem item = (PTableItem)PTable.this.getValueAt(selectedRow, 0);
            if (item.hasChildren()) {
                PTable.this.toggleTreeNode(selectedRow);
                PTable.this.selectRow(selectedRow);
            } else if (this.myToggleOnly) {
                PTable.this.quickEdit(selectedRow);
            } else {
                PTable.this.startEditing(selectedRow);
            }
        }
    }
}

