/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.utils.Pair;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import java.awt.Rectangle;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDropListener
extends DropTargetAdapter {
    public static final HashSet<String> ourCopyableAttributes = new HashSet(Arrays.asList("layout_width", "layout_height", "id", "background"));
    private final List<NlComponent> myDragged;
    private final NlComponentTree myTree;
    private DnDTransferItem myTransferItem;
    protected NlComponent myDragReceiver;
    protected NlComponent myNextDragSibling;

    public NlDropListener(@NotNull NlComponentTree tree) {
        if (tree == null) {
            NlDropListener.$$$reportNull$$$0(0);
        }
        this.myDragged = new ArrayList<NlComponent>();
        this.myTree = tree;
    }

    @Override
    public void dragEnter(@NotNull DropTargetDragEvent dragEvent) {
        if (dragEvent == null) {
            NlDropListener.$$$reportNull$$$0(1);
        }
        NlDropEvent event = new NlDropEvent(dragEvent);
        this.captureDraggedComponents(event, true);
        this.updateInsertionPoint(event);
    }

    @Override
    public void dragOver(@NotNull DropTargetDragEvent dragEvent) {
        if (dragEvent == null) {
            NlDropListener.$$$reportNull$$$0(2);
        }
        NlDropEvent event = new NlDropEvent(dragEvent);
        this.updateInsertionPoint(event);
    }

    @Override
    public void dragExit(@NotNull DropTargetEvent event) {
        if (event == null) {
            NlDropListener.$$$reportNull$$$0(3);
        }
        this.clearInsertionPoint();
        this.clearDraggedComponents();
    }

    @Override
    public void drop(@NotNull DropTargetDropEvent dropEvent) {
        if (dropEvent == null) {
            NlDropListener.$$$reportNull$$$0(4);
        }
        NlDropEvent event = new NlDropEvent(dropEvent);
        InsertType insertType = this.captureDraggedComponents(event, false);
        if (this.findInsertionPoint(event) != null) {
            this.performDrop(dropEvent, insertType);
        }
        this.clearInsertionPoint();
        this.clearDraggedComponents();
    }

    @Nullable
    private InsertType captureDraggedComponents(@NotNull NlDropEvent event, boolean isPreview) {
        if (event == null) {
            NlDropListener.$$$reportNull$$$0(5);
        }
        this.clearDraggedComponents();
        ScreenView screenView = this.myTree.getScreenView();
        if (screenView == null) {
            return null;
        }
        NlModel model = screenView.getModel();
        if (event.isDataFlavorSupported(ItemTransferable.DESIGNER_FLAVOR)) {
            try {
                this.myTransferItem = (DnDTransferItem)event.getTransferable().getTransferData(ItemTransferable.DESIGNER_FLAVOR);
                InsertType insertType = this.determineInsertType(event, isPreview);
                if (insertType.isMove()) {
                    this.myDragged.addAll(NlDropListener.keepOnlyAncestors(model.getSelectionModel().getSelection()));
                } else {
                    Collection captured = (Collection)ApplicationManager.getApplication().runWriteAction(() -> model.createComponents(screenView, this.myTransferItem, insertType));
                    if (captured != null) {
                        this.myDragged.addAll(NlDropListener.keepOnlyAncestors(captured));
                    }
                }
                return insertType;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                Logger.getInstance(NlDropListener.class).warn((Throwable)exception);
            }
        }
        return null;
    }

    @NotNull
    private InsertType determineInsertType(@NotNull NlDropEvent event, boolean isPreview) {
        NlModel model;
        if (event == null) {
            NlDropListener.$$$reportNull$$$0(6);
        }
        if ((model = this.myTree.getDesignerModel()) == null || this.myTransferItem == null) {
            InsertType insertType = InsertType.MOVE_INTO;
            if (insertType == null) {
                NlDropListener.$$$reportNull$$$0(7);
            }
            return insertType;
        }
        DragType dragType = event.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
        InsertType insertType = model.determineInsertType(dragType, this.myTransferItem, isPreview);
        if (insertType == null) {
            NlDropListener.$$$reportNull$$$0(8);
        }
        return insertType;
    }

    private void clearDraggedComponents() {
        this.myDragged.clear();
    }

    private void updateInsertionPoint(@NotNull NlDropEvent event) {
        Pair<TreePath, NlComponentTree.InsertionPoint> point;
        if (event == null) {
            NlDropListener.$$$reportNull$$$0(9);
        }
        if ((point = this.findInsertionPoint(event)) == null) {
            this.clearInsertionPoint();
            event.reject();
        } else {
            this.myTree.markInsertionPoint((TreePath)point.getFirst(), (NlComponentTree.InsertionPoint)((Object)point.getSecond()));
            event.accept(this.determineInsertType(event, true) == InsertType.COPY ? event.getDropAction() : 1);
        }
    }

    protected boolean shouldInsert(@NotNull NlComponent receiver, @Nullable NlComponentTree.InsertionPoint insertionPoint) {
        if (receiver == null) {
            NlDropListener.$$$reportNull$$$0(10);
        }
        ViewHandler handler = receiver.getViewHandler();
        return insertionPoint == NlComponentTree.InsertionPoint.INSERT_INTO && (handler instanceof ViewGroupHandler || NlDropListener.isMorphableToViewGroup(receiver) && !NlDropListener.isReceiverChild(receiver, this.myDragged));
    }

    protected boolean canAddComponent(@NotNull NlModel model, @NotNull NlComponent receiver) {
        if (model == null) {
            NlDropListener.$$$reportNull$$$0(11);
        }
        if (receiver == null) {
            NlDropListener.$$$reportNull$$$0(12);
        }
        return model.canAddComponents(this.myDragged, receiver, receiver.getChild(0)) || NlDropListener.isMorphableToViewGroup(receiver) && !NlDropListener.isReceiverChild(receiver, this.myDragged);
    }

    private static boolean isMorphableToViewGroup(@NotNull NlComponent receiver) {
        if (receiver == null) {
            NlDropListener.$$$reportNull$$$0(13);
        }
        return "View".equals(receiver.getTagName()) && receiver.getAttribute("http://schemas.android.com/tools", "mockup") != null;
    }

    @Nullable
    private Pair<TreePath, NlComponentTree.InsertionPoint> findInsertionPoint(@NotNull NlDropEvent event) {
        if (event == null) {
            NlDropListener.$$$reportNull$$$0(14);
        }
        this.myDragReceiver = null;
        this.myNextDragSibling = null;
        TreePath path = this.myTree.getClosestPathForLocation(event.getLocation().x, event.getLocation().y);
        if (path == null) {
            return null;
        }
        ScreenView screenView = this.myTree.getScreenView();
        if (screenView == null) {
            return null;
        }
        NlModel model = screenView.getModel();
        NlComponent component = (NlComponent)path.getLastPathComponent();
        if (component == null) {
            return null;
        }
        Rectangle bounds = this.myTree.getPathBounds(path);
        if (bounds == null) {
            return null;
        }
        NlComponentTree.InsertionPoint insertionPoint = NlDropListener.findTreeStateInsertionPoint(event.getLocation().y, bounds);
        if (this.shouldInsert(component, insertionPoint)) {
            if (!this.canAddComponent(model, component)) {
                return null;
            }
            this.myDragReceiver = component;
            this.myNextDragSibling = component.getChild(0);
        } else {
            NlComponent parent = component.getParent();
            if (parent == null) {
                return null;
            }
            if (parent.getViewHandler() == null || !model.canAddComponents(this.myDragged, parent, component)) {
                return null;
            }
            insertionPoint = (double)event.getLocation().y > bounds.getCenterY() ? NlComponentTree.InsertionPoint.INSERT_AFTER : NlComponentTree.InsertionPoint.INSERT_BEFORE;
            this.myDragReceiver = parent;
            this.myNextDragSibling = insertionPoint == NlComponentTree.InsertionPoint.INSERT_BEFORE ? component : component.getNextSibling();
        }
        return Pair.of((Object)path, (Object)((Object)insertionPoint));
    }

    @NotNull
    protected static NlComponentTree.InsertionPoint findTreeStateInsertionPoint(int y, @NotNull Rectangle bounds) {
        int delta;
        if (bounds == null) {
            NlDropListener.$$$reportNull$$$0(15);
        }
        if (bounds.y + (delta = bounds.height / 9) > y) {
            NlComponentTree.InsertionPoint insertionPoint = NlComponentTree.InsertionPoint.INSERT_BEFORE;
            if (insertionPoint == null) {
                NlDropListener.$$$reportNull$$$0(16);
            }
            return insertionPoint;
        }
        if (bounds.y + bounds.height - delta < y) {
            NlComponentTree.InsertionPoint insertionPoint = NlComponentTree.InsertionPoint.INSERT_AFTER;
            if (insertionPoint == null) {
                NlDropListener.$$$reportNull$$$0(17);
            }
            return insertionPoint;
        }
        NlComponentTree.InsertionPoint insertionPoint = NlComponentTree.InsertionPoint.INSERT_INTO;
        if (insertionPoint == null) {
            NlDropListener.$$$reportNull$$$0(18);
        }
        return insertionPoint;
    }

    private void clearInsertionPoint() {
        this.myTree.markInsertionPoint(null, NlComponentTree.InsertionPoint.INSERT_BEFORE);
    }

    protected void performDrop(@NotNull DropTargetDropEvent event, InsertType insertType) {
        if (event == null) {
            NlDropListener.$$$reportNull$$$0(19);
        }
        this.myTree.skipNextUpdateDelay();
        NlModel model = this.myTree.getDesignerModel();
        assert (model != null);
        if (this.myDragReceiver.isOrHasSuperclass("android.view.ViewGroup") && model.canAddComponents(this.myDragged, this.myDragReceiver, this.myDragReceiver.getChild(0))) {
            this.performNormalDrop(event, insertType, model);
        } else if (!this.myDragReceiver.isRoot() && !NlDropListener.isReceiverChild(this.myDragReceiver, this.myDragged) && NlDropListener.isMorphableToViewGroup(this.myDragReceiver)) {
            this.morphReceiverIntoViewGroup(model);
            this.performNormalDrop(event, insertType, model);
        }
    }

    private void performNormalDrop(@NotNull DropTargetDropEvent event, @NotNull InsertType insertType, @NotNull NlModel model) {
        if (event == null) {
            NlDropListener.$$$reportNull$$$0(20);
        }
        if (insertType == null) {
            NlDropListener.$$$reportNull$$$0(21);
        }
        if (model == null) {
            NlDropListener.$$$reportNull$$$0(22);
        }
        try {
            model.addComponents(this.myDragged, this.myDragReceiver, this.myNextDragSibling, insertType);
            event.acceptDrop(insertType == InsertType.COPY ? event.getDropAction() : 1);
            event.dropComplete(true);
            model.notifyModified(NlModel.ChangeType.DROP);
        }
        catch (Exception exception) {
            Logger.getInstance(NlDropListener.class).warn((Throwable)exception);
            event.rejectDrop();
        }
    }

    private void morphReceiverIntoViewGroup(@NotNull NlModel model) {
        if (model == null) {
            NlDropListener.$$$reportNull$$$0(23);
        }
        final AttributesTransaction transaction = this.myDragReceiver.startAttributeTransaction();
        for (AttributeSnapshot attribute : this.myDragReceiver.getAttributes()) {
            if ("tools".equals(attribute.prefix) || ourCopyableAttributes.contains((Object)attribute.name) || attribute.namespace == null) continue;
            transaction.removeAttribute(attribute.namespace, attribute.name);
        }
        new WriteCommandAction(model.getProject(), new PsiFile[]{model.getFile()}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                XmlTag tag = NlDropListener.this.myDragReceiver.getTag();
                tag.setName("android.support.constraint.ConstraintLayout");
                NlDropListener.this.myDragReceiver.setTag(tag);
                transaction.commit();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/structure/NlDropListener$1", "run"));
            }
        }.execute();
    }

    private static Collection<NlComponent> keepOnlyAncestors(@NotNull Collection<NlComponent> dragged) {
        if (dragged == null) {
            NlDropListener.$$$reportNull$$$0(24);
        }
        Set selection = Sets.newIdentityHashSet();
        selection.addAll(dragged);
        Stack<NlComponent> toTraverse = new Stack<NlComponent>();
        for (NlComponent selectedElement : dragged) {
            List<NlComponent> children = selectedElement.getChildren();
            toTraverse.addAll(children);
            while (!toTraverse.isEmpty()) {
                NlComponent child = (NlComponent)toTraverse.pop();
                toTraverse.addAll(child.getChildren());
                if (!selection.contains(child)) continue;
                selection.remove(child);
            }
        }
        return selection;
    }

    private static boolean isReceiverChild(@NotNull NlComponent receiver, @NotNull List<NlComponent> toAdd) {
        if (receiver == null) {
            NlDropListener.$$$reportNull$$$0(25);
        }
        if (toAdd == null) {
            NlDropListener.$$$reportNull$$$0(26);
        }
        NlComponent same = receiver;
        for (NlComponent component : toAdd) {
            while (same != null) {
                if (same == component) {
                    return true;
                }
                same = same.getParent();
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragEvent";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 14: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dropEvent";
                break;
            }
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/structure/NlDropListener";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 11: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragged";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/structure/NlDropListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "determineInsertType";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findTreeStateInsertionPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dragEnter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dragOver";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dragExit";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "captureDraggedComponents";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "determineInsertType";
                break;
            }
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateInsertionPoint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsert";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canAddComponent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isMorphableToViewGroup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findInsertionPoint";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findTreeStateInsertionPoint";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "performDrop";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "performNormalDrop";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "morphReceiverIntoViewGroup";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "keepOnlyAncestors";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isReceiverChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

