/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.Uninstaller;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.installer.BasicInstallerFactory;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ComponentInstaller {
    private final AndroidSdkHandler mySdkHandler;

    public ComponentInstaller(@NotNull AndroidSdkHandler sdkHandler) {
        if (sdkHandler == null) {
            ComponentInstaller.$$$reportNull$$$0(0);
        }
        this.mySdkHandler = sdkHandler;
    }

    public List<RemotePackage> getPackagesToInstall(@NotNull Iterable<? extends InstallableComponent> components) throws SdkQuickfixUtils.PackageResolutionException {
        if (components == null) {
            ComponentInstaller.$$$reportNull$$$0(1);
        }
        HashSet requests = Sets.newHashSet();
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = this.mySdkHandler.getSdkManager((ProgressIndicator)progress);
        for (InstallableComponent installableComponent : components) {
            requests.addAll(installableComponent.getPackagesToInstall());
        }
        ArrayList resolved = Lists.newArrayList();
        resolved.addAll(SdkQuickfixUtils.resolve(requests, sdkManager.getPackages()));
        ArrayList arrayList = Lists.newArrayList();
        for (UpdatablePackage p : resolved) {
            arrayList.add(p.getRemote());
        }
        return arrayList;
    }

    public void installPackages(@NotNull List<RemotePackage> packages, ProgressIndicator progress) throws WizardException {
        if (packages == null) {
            ComponentInstaller.$$$reportNull$$$0(2);
        }
        RepoManager sdkManager = this.mySdkHandler.getSdkManager(progress);
        Iterator<RemotePackage> iterator = packages.iterator();
        while (iterator.hasNext()) {
            BasicInstallerFactory factory = new BasicInstallerFactory();
            RemotePackage request = iterator.next();
            Installer installer = factory.createInstaller(request, sdkManager, (Downloader)new StudioDownloader(), this.mySdkHandler.getFileOp());
            if (!installer.prepare(progress)) continue;
            installer.complete(progress);
        }
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, progress, null, null);
    }

    public void ensureSdkPackagesUninstalled(@NotNull Collection<String> packageNames, ProgressIndicator progress) throws WizardException {
        if (packageNames == null) {
            ComponentInstaller.$$$reportNull$$$0(3);
        }
        RepoManager sdkManager = this.mySdkHandler.getSdkManager(progress);
        RepositoryPackages packages = sdkManager.getPackages();
        Map localPackages = packages.getLocalPackages();
        ArrayList<LocalPackage> packagesToUninstall = new ArrayList<LocalPackage>();
        for (String packageName : packageNames) {
            LocalPackage p = (LocalPackage)localPackages.get(packageName);
            if (p != null) {
                packagesToUninstall.add(p);
                continue;
            }
            progress.logInfo(String.format("Package '%1$s' does not appear to be installed - ignoring", packageName));
        }
        Iterator<String> iterator = packagesToUninstall.iterator();
        while (iterator.hasNext()) {
            BasicInstallerFactory factory = new BasicInstallerFactory();
            LocalPackage request = (LocalPackage)iterator.next();
            Uninstaller uninstaller = factory.createUninstaller(request, sdkManager, this.mySdkHandler.getFileOp());
            if (!uninstaller.prepare(progress)) continue;
            uninstaller.complete(progress);
        }
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, progress, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/welcome/install/ComponentInstaller";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackagesToInstall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installPackages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureSdkPackagesUninstalled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

