/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetadataValueConverter
extends ResolvingConverter<Object>
implements CustomReferenceConverter<Object> {
    private ResourceReferenceConverter myResourceReferenceConverter = new ResourceReferenceConverter();
    private PackageClassConverter myPsiClassConverter = new PackageClassConverter();

    public MetadataValueConverter() {
        this.myResourceReferenceConverter.setExpandedCompletionSuggestion(false);
    }

    private static boolean isClassContext(ConvertContext context) {
        XmlTag xmlTag = context.getTag();
        return xmlTag != null && "android.support.PARENT_ACTIVITY".equals(xmlTag.getAttributeValue("android:name"));
    }

    @Nullable
    public String toString(@Nullable Object object, ConvertContext context) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    @NotNull
    public Collection<Object> getVariants(ConvertContext context) {
        if (MetadataValueConverter.isClassContext(context)) {
            List<Object> list = Collections.emptyList();
            if (list == null) {
                MetadataValueConverter.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<Object> results = new ArrayList<Object>();
        results.addAll(this.myResourceReferenceConverter.getVariants(context));
        ArrayList<Object> arrayList = results;
        if (arrayList == null) {
            MetadataValueConverter.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    public Object fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (MetadataValueConverter.isClassContext(context)) {
            return this.myPsiClassConverter.fromString(s, context);
        }
        return this.myResourceReferenceConverter.fromString(s, context);
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue value, PsiElement element, ConvertContext context) {
        if (MetadataValueConverter.isClassContext(context)) {
            PsiReference[] psiReferenceArray = this.myPsiClassConverter.createReferences((GenericDomValue<PsiClass>)value, element, context);
            if (psiReferenceArray == null) {
                MetadataValueConverter.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = this.myResourceReferenceConverter.createReferences((GenericDomValue<ResourceValue>)value, element, context);
        if (psiReferenceArray == null) {
            MetadataValueConverter.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/android/dom/converters/MetadataValueConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

