/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.config.AbstractProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class BeforeSuiteEvent
extends AbstractTestEvent {
    public BeforeSuiteEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        if (eventXml == null) {
            BeforeSuiteEvent.$$$reportNull$$$0(0);
        }
        String testId = eventXml.getTestId();
        String parentTestId = eventXml.getTestParentId();
        String name = eventXml.getTestName();
        String fqClassName = eventXml.getTestClassName();
        if (StringUtil.isEmpty((String)parentTestId)) {
            this.registerTestProxy(testId, (SMTestProxy)this.getResultsViewer().getTestsRootNode());
        } else {
            SMTestProxy parentTest = this.findTestProxy(parentTestId);
            if (this.isHiddenTestNode(name, parentTest)) {
                this.registerTestProxy(testId, parentTest);
            } else {
                String locationUrl = this.findLocationUrl(null, fqClassName);
                GradleSMTestProxy testProxy = new GradleSMTestProxy(name, true, locationUrl, null);
                testProxy.setLocator(this.getExecutionConsole().getUrlProvider());
                testProxy.setParentId(parentTestId);
                testProxy.setStarted();
                this.registerTestProxy(testId, testProxy);
            }
        }
    }

    @Override
    @NotNull
    protected String findLocationUrl(@Nullable String name, @NotNull String fqClassName) {
        if (fqClassName == null) {
            BeforeSuiteEvent.$$$reportNull$$$0(1);
        }
        String string = name == null ? "java:suite://" + fqClassName : "java:suite://" + StringUtil.getQualifiedName((String)fqClassName, (String)name);
        if (string == null) {
            BeforeSuiteEvent.$$$reportNull$$$0(2);
        }
        return string;
    }

    private boolean isHiddenTestNode(String name, SMTestProxy parentTest) {
        return parentTest != null && !GradleConsoleProperties.SHOW_INTERNAL_TEST_NODES.value((AbstractProperty.AbstractPropertyContainer)this.getProperties()) && StringUtil.startsWith((CharSequence)name, (CharSequence)"Gradle Test Executor");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventXml";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqClassName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/test/runner/events/BeforeSuiteEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/events/BeforeSuiteEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findLocationUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findLocationUrl";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

