/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.analysis;

import com.mxgraph.analysis.StructuralException;
import com.mxgraph.analysis.mxAnalysisGraph;
import com.mxgraph.analysis.mxGraphProperties;
import com.mxgraph.analysis.mxGraphStructure;
import com.mxgraph.costfunction.mxCostFunction;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class mxTraversal {
    public static void dfs(mxAnalysisGraph mxAnalysisGraph2, Object object, mxGraph.mxICellVisitor mxICellVisitor2) {
        mxTraversal.dfsRec(mxAnalysisGraph2, object, null, new HashSet<Object>(), mxICellVisitor2);
    }

    private static void dfsRec(mxAnalysisGraph mxAnalysisGraph2, Object object, Object object2, Set<Object> set, mxGraph.mxICellVisitor mxICellVisitor2) {
        if (object != null && !set.contains(object)) {
            mxICellVisitor2.visit(object, object2);
            set.add(object);
            Object[] objectArray = mxAnalysisGraph2.getEdges(object, null, false, true);
            Object[] objectArray2 = mxAnalysisGraph2.getOpposites(objectArray, object);
            for (int i = 0; i < objectArray2.length; ++i) {
                mxTraversal.dfsRec(mxAnalysisGraph2, objectArray2[i], objectArray[i], set, mxICellVisitor2);
            }
        }
    }

    public static void bfs(mxAnalysisGraph mxAnalysisGraph2, Object object, mxGraph.mxICellVisitor mxICellVisitor2) {
        if (mxAnalysisGraph2 != null && object != null && mxICellVisitor2 != null) {
            HashSet<Object> hashSet = new HashSet<Object>();
            LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
            Object[] objectArray = new Object[]{object, null};
            linkedList.addLast(objectArray);
            hashSet.add(object);
            mxTraversal.bfsRec(mxAnalysisGraph2, hashSet, linkedList, mxICellVisitor2);
        }
    }

    private static void bfsRec(mxAnalysisGraph mxAnalysisGraph2, Set<Object> set, LinkedList<Object[]> linkedList, mxGraph.mxICellVisitor mxICellVisitor2) {
        if (linkedList.size() > 0) {
            Object[] objectArray = linkedList.removeFirst();
            Object object = objectArray[0];
            Object object2 = objectArray[1];
            mxICellVisitor2.visit(object, object2);
            Object[] objectArray2 = mxAnalysisGraph2.getEdges(object, null, false, false);
            for (int i = 0; i < objectArray2.length; ++i) {
                Object[] objectArray3 = new Object[]{objectArray2[i]};
                Object object3 = mxAnalysisGraph2.getOpposites(objectArray3, object)[0];
                if (set.contains(object3)) continue;
                Object[] objectArray4 = new Object[]{object3, objectArray2[i]};
                linkedList.addLast(objectArray4);
                set.add(object3);
            }
            mxTraversal.bfsRec(mxAnalysisGraph2, set, linkedList, mxICellVisitor2);
        }
    }

    public static void dijkstra(mxAnalysisGraph mxAnalysisGraph2, Object object, Object object2, mxGraph.mxICellVisitor mxICellVisitor2) throws StructuralException {
        if (!mxGraphStructure.isConnected(mxAnalysisGraph2)) {
            throw new StructuralException("The current Dijkstra algorithm only works for connected graphs and this graph isn't connected");
        }
        Object object3 = mxAnalysisGraph2.getGraph().getDefaultParent();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(object3);
        int n = objectArray.length;
        double[] dArray = new double[n];
        Object[][] objectArray2 = new Object[n][2];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            dArray[i] = 2.147483647E9;
            arrayList.add(objectArray[i]);
            arrayList2.add(objectArray[i]);
        }
        dArray[arrayList2.indexOf((Object)object)] = 0.0;
        mxCostFunction mxCostFunction2 = mxAnalysisGraph2.getGenerator().getCostFunction();
        mxGraphView mxGraphView2 = mxAnalysisGraph2.getGraph().getView();
        while (arrayList.size() > 0) {
            double d;
            Object e = arrayList.get(0);
            int n2 = arrayList2.indexOf(e);
            double d2 = d = dArray[n2];
            Object e2 = e;
            if (arrayList.size() > 1) {
                for (int i = 1; i < arrayList.size(); ++i) {
                    e = arrayList.get(i);
                    n2 = arrayList2.indexOf(e);
                    d = dArray[n2];
                    if (!(d < d2)) continue;
                    d2 = d;
                    e2 = e;
                }
            }
            arrayList.remove(e2);
            Object object4 = new Object();
            Object[] objectArray3 = mxAnalysisGraph2.getOpposites(mxAnalysisGraph2.getEdges(e2, null, true, true, false, true), e2, true, true);
            for (int i = 0; i < objectArray3.length; ++i) {
                int n3;
                Object object5 = objectArray3[i];
                if (!arrayList.contains(object5)) continue;
                Object[] objectArray4 = mxAnalysisGraph2.getEdges(object5, null, true, true, false, true);
                Object object6 = null;
                for (n3 = 0; n3 < objectArray4.length; ++n3) {
                    object4 = objectArray4[n3];
                    if (!mxAnalysisGraph2.getTerminal(object4, true).equals(e2) && !mxAnalysisGraph2.getTerminal(object4, false).equals(e2)) continue;
                    object6 = object4;
                }
                n3 = arrayList2.indexOf(object5);
                double d3 = dArray[n3];
                double d4 = mxCostFunction2.getCost(new mxCellState(mxGraphView2, object6, null));
                double d5 = d2 + d4;
                if (!(d5 < d3)) continue;
                dArray[n3] = d5;
                objectArray2[n3][0] = e2;
                objectArray2[n3][1] = object6;
            }
        }
        ArrayList<Object[]> arrayList3 = new ArrayList<Object[]>();
        Object object7 = object2;
        while (object7 != object) {
            int n4 = arrayList2.indexOf(object7);
            object7 = objectArray2[n4][0];
            arrayList3.add(0, objectArray2[n4]);
        }
        arrayList3.add(arrayList3.size(), new Object[]{object2, null});
        for (int i = 0; i < arrayList3.size(); ++i) {
            mxICellVisitor2.visit(((Object[])arrayList3.get(i))[0], ((Object[])arrayList3.get(i))[1]);
        }
    }

    public static List<Map<Object, Object>> bellmanFord(mxAnalysisGraph mxAnalysisGraph2, Object object) throws StructuralException {
        Object object2;
        Object object3;
        int n;
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(mxGraph2.getDefaultParent());
        Object[] objectArray2 = mxAnalysisGraph2.getChildEdges(mxGraph2.getDefaultParent());
        int n2 = objectArray.length;
        int n3 = objectArray2.length;
        HashMap<Object, Double> hashMap = new HashMap<Object, Double>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        mxCostFunction mxCostFunction2 = mxAnalysisGraph2.getGenerator().getCostFunction();
        mxGraphView mxGraphView2 = mxGraph2.getView();
        for (n = 0; n < n2; ++n) {
            Object object4 = objectArray[n];
            hashMap.put(object4, (Double)Double.MAX_VALUE);
        }
        hashMap.put(object, 0.0);
        hashMap2.put(object, object);
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                object3 = objectArray2[i];
                object2 = mxAnalysisGraph2.getTerminal(object3, true);
                Object object5 = mxAnalysisGraph2.getTerminal(object3, false);
                double d = (Double)hashMap.get(object2) + mxCostFunction2.getCost(new mxCellState(mxGraphView2, object3, null));
                if (d < (Double)hashMap.get(object5)) {
                    hashMap.put(object5, d);
                    hashMap2.put(object5, object2);
                }
                if (mxGraphProperties.isDirected(mxAnalysisGraph2.getProperties(), mxGraphProperties.DEFAULT_DIRECTED) || !((d = (Double)hashMap.get(object5) + mxCostFunction2.getCost(new mxCellState(mxGraphView2, object3, null))) < (Double)hashMap.get(object2))) continue;
                hashMap.put(object2, d);
                hashMap2.put(object2, object5);
            }
        }
        for (n = 0; n < n3; ++n) {
            Object object6 = objectArray2[n];
            object3 = mxAnalysisGraph2.getTerminal(object6, true);
            object2 = mxAnalysisGraph2.getTerminal(object6, false);
            double d = (Double)hashMap.get(object3) + mxCostFunction2.getCost(new mxCellState(mxGraphView2, object6, null));
            if (!(d < (Double)hashMap.get(object2))) continue;
            throw new StructuralException("The graph contains a negative cycle, so Bellman-Ford can't be completed.");
        }
        ArrayList<Map<Object, Object>> arrayList = new ArrayList<Map<Object, Object>>();
        arrayList.add(hashMap);
        arrayList.add(hashMap2);
        return arrayList;
    }

    public static ArrayList<Object[][]> floydRoyWarshall(mxAnalysisGraph mxAnalysisGraph2) throws StructuralException {
        int n;
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(mxAnalysisGraph2.getGraph().getDefaultParent());
        Double[][] doubleArray = new Double[objectArray.length][objectArray.length];
        Object[][] objectArray2 = new Object[objectArray.length][objectArray.length];
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        for (int i = 0; i < objectArray.length; ++i) {
            hashMap.put(objectArray[i], i);
        }
        Object[] objectArray3 = mxAnalysisGraph2.getChildEdges(mxAnalysisGraph2.getGraph().getDefaultParent());
        doubleArray = mxTraversal.initializeWeight(mxAnalysisGraph2, objectArray, objectArray3, hashMap);
        for (n = 0; n < objectArray.length; ++n) {
            for (int i = 0; i < objectArray.length; ++i) {
                for (int j = 0; j < objectArray.length; ++j) {
                    if (!(doubleArray[i][j] > doubleArray[i][n] + doubleArray[n][j])) continue;
                    objectArray2[i][j] = mxGraphStructure.getVertexWithValue(mxAnalysisGraph2, n);
                    doubleArray[i][j] = doubleArray[i][n] + doubleArray[n][j];
                }
            }
        }
        for (n = 0; n < doubleArray[0].length; ++n) {
            if (!(doubleArray[n][n] < 0.0)) continue;
            throw new StructuralException("The graph has negative cycles");
        }
        ArrayList<Object[][]> arrayList = new ArrayList<Object[][]>();
        arrayList.add(doubleArray);
        arrayList.add(objectArray2);
        return arrayList;
    }

    private static Double[][] initializeWeight(mxAnalysisGraph mxAnalysisGraph2, Object[] objectArray, Object[] objectArray2, Map<Object, Integer> map) {
        int n;
        Double[][] doubleArray = new Double[objectArray.length][objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            Arrays.fill(doubleArray[n], (Object)Double.MAX_VALUE);
        }
        n = mxGraphProperties.isDirected(mxAnalysisGraph2.getProperties(), mxGraphProperties.DEFAULT_DIRECTED) ? 1 : 0;
        mxCostFunction mxCostFunction2 = mxAnalysisGraph2.getGenerator().getCostFunction();
        mxGraphView mxGraphView2 = mxAnalysisGraph2.getGraph().getView();
        for (Object object : objectArray2) {
            Object object2 = mxAnalysisGraph2.getTerminal(object, true);
            Object object3 = mxAnalysisGraph2.getTerminal(object, false);
            doubleArray[map.get((Object)object2).intValue()][map.get((Object)object3).intValue()] = mxCostFunction2.getCost(mxGraphView2.getState(object));
            if (n != 0) continue;
            doubleArray[map.get((Object)object3).intValue()][map.get((Object)object2).intValue()] = mxCostFunction2.getCost(mxGraphView2.getState(object));
        }
        for (int i = 0; i < objectArray.length; ++i) {
            doubleArray[i][i] = 0.0;
        }
        return doubleArray;
    }

    public static Object[] getWFIPath(mxAnalysisGraph mxAnalysisGraph2, ArrayList<Object[][]> arrayList, Object object, Object object2) throws StructuralException {
        Object[][] objectArray = arrayList.get(0);
        Object[][] objectArray2 = arrayList.get(1);
        ArrayList<Object> arrayList2 = null;
        if (mxAnalysisGraph2 == null || objectArray2 == null || object == null || object2 == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < objectArray[0].length; ++i) {
            if (!((Double)objectArray[i][i] < 0.0)) continue;
            throw new StructuralException("The graph has negative cycles");
        }
        if (object != object2) {
            mxCostFunction mxCostFunction2 = mxAnalysisGraph2.getGenerator().getCostFunction();
            mxGraphView mxGraphView2 = mxAnalysisGraph2.getGraph().getView();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            arrayList3.add(object);
            while (object != object2) {
                arrayList2 = mxTraversal.getWFIPathRec(mxAnalysisGraph2, objectArray2, object, object2, arrayList3, mxCostFunction2, mxGraphView2);
                object = arrayList2.get(arrayList2.size() - 1);
            }
        }
        if (arrayList2 == null) {
            arrayList2 = new ArrayList();
        }
        return arrayList2.toArray();
    }

    private static ArrayList<Object> getWFIPathRec(mxAnalysisGraph mxAnalysisGraph2, Object[][] objectArray, Object object, Object object2, ArrayList<Object> arrayList, mxCostFunction mxCostFunction2, mxGraphView mxGraphView2) throws StructuralException {
        Double d;
        int n;
        Double d2 = mxCostFunction2.getCost(mxGraphView2.getState(object));
        Object[] objectArray2 = objectArray[d2.intValue()];
        if (objectArray2[n = (d = Double.valueOf(mxCostFunction2.getCost(mxGraphView2.getState(object2)))).intValue()] != null) {
            arrayList = mxTraversal.getWFIPathRec(mxAnalysisGraph2, objectArray, object, objectArray2[n], arrayList, mxCostFunction2, mxGraphView2);
        } else if (mxGraphStructure.areConnected(mxAnalysisGraph2, object, object2) || object == object2) {
            arrayList.add(object2);
        } else {
            throw new StructuralException("The two vertices aren't connected");
        }
        return arrayList;
    }
}

