/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseJavaFromJSReferenceInspection;
import com.intellij.gwt.jsinject.GwtClassMemberReference;
import com.intellij.gwt.jsinject.JSGwtReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GwtJavaFromJSMethodCallsInspection
extends BaseJavaFromJSReferenceInspection {
    @Override
    protected void checkReferenceExpression(JSGwtReferenceExpressionImpl element, List<ProblemDescriptor> problems, InspectionManager manager, boolean isOnTheFly) {
        PsiElement grandParent;
        PsiReference[] references = element.getReferences();
        if (references.length == 0) {
            return;
        }
        PsiReference lastRef = references[references.length - 1];
        if (!(lastRef instanceof GwtClassMemberReference)) {
            return;
        }
        PsiElement resolved = lastRef.resolve();
        if (!(resolved instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)resolved;
        PsiElement parent = element.getParent();
        if (!method.getModifierList().hasModifierProperty("static") && !method.isConstructor() && parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == null) {
            String message = GwtBundle.message("problem.description.cannot.call.instance.method.without.object.instance", PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0));
            problems.add(manager.createProblemDescriptor((PsiElement)element, lastRef.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
        }
        if (parent instanceof JSReferenceExpression && (grandParent = parent.getParent()) instanceof JSCallExpression) {
            int actualParameters;
            JSCallExpression call = (JSCallExpression)grandParent;
            int expectedParameters = method.getParameterList().getParametersCount();
            if (expectedParameters != (actualParameters = call.getArguments().length)) {
                String message = GwtBundle.message("problem.description.incorrect.number.of.arguments.for.method", PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2), expectedParameters, actualParameters);
                JSArgumentList list = call.getArgumentList();
                problems.add(manager.createProblemDescriptor((PsiElement)(list != null ? list : call), message, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
            }
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.incorrect.java.methods.calls.in.js", new Object[0]);
        if (string == null) {
            GwtJavaFromJSMethodCallsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("GwtJavaFromJSMethodCalls" == null) {
            GwtJavaFromJSMethodCallsInspection.$$$reportNull$$$0(1);
        }
        return "GwtJavaFromJSMethodCalls";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/gwt/inspections/GwtJavaFromJSMethodCallsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

