/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run.remoteUi;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.gwt.run.remoteUi.ModuleLogComponent;
import com.intellij.gwt.run.remoteUi.RemoteUiConnection;
import com.intellij.gwt.run.remoteUi.RemoteUiLogManager;
import com.intellij.gwt.run.remoteUi.RemoteUiRequest;
import com.intellij.gwt.run.remoteUi.responses.FailureResponse;
import com.intellij.gwt.run.remoteUi.responses.InitializeResponse;
import com.intellij.gwt.run.remoteUi.responses.RemoteUiResponse;
import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.OpenUrlHyperlinkInfo;
import com.intellij.javaee.run.execution.ConsoleViewWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.io.socketConnection.AbstractResponseHandler;
import com.intellij.util.io.socketConnection.SocketConnection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RemoteUiView
extends ConsoleViewWrapper {
    private ConsoleView myServerConsole;
    private ModuleLogComponent myModuleLogComponent;
    private final RemoteUiConnection myUiConnection;
    private final boolean myDebugSession;

    public RemoteUiView(Project project, final ConsoleView delegate, RemoteUiConnection uiConnection, boolean isDebugSession) {
        super(delegate);
        Disposer.register((Disposable)this, (Disposable)delegate);
        this.myUiConnection = uiConnection;
        this.myDebugSession = isDebugSession;
        this.myServerConsole = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        Disposer.register((Disposable)this, (Disposable)this.myServerConsole);
        this.myModuleLogComponent = new ModuleLogComponent(project);
        Disposer.register((Disposable)this, (Disposable)this.myModuleLogComponent);
        SocketConnection<RemoteUiRequest, RemoteUiResponse> connection = uiConnection.getConnection();
        new RemoteUiLogManager(connection, this).registerHandlers();
        connection.registerHandler(FailureResponse.class, (AbstractResponseHandler)new AbstractResponseHandler<FailureResponse>(){

            public void processResponse(FailureResponse response) {
                delegate.print(response.getMessage(), ConsoleViewContentType.ERROR_OUTPUT);
            }
        });
        connection.registerHandler(InitializeResponse.class, (AbstractResponseHandler)new AbstractResponseHandler<InitializeResponse>(){

            public void processResponse(InitializeResponse response) {
                List<String> urls = response.getStartupUrlsList();
                String message = "Dev Mode initialized";
                if (!urls.isEmpty()) {
                    message = message + ". Startup " + StringUtil.pluralize((String)"URL", (int)urls.size()) + ": ";
                }
                delegate.print(message + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                Condition suitableBrowsers = browser -> RemoteUiView.this.myUiConnection.getSdkVersion().isBrowserSupportedInDevMode(browser.getFamily());
                for (String url : urls) {
                    delegate.printHyperlink(url, (HyperlinkInfo)new OpenUrlHyperlinkInfo(url, suitableBrowsers));
                    delegate.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                }
            }
        });
    }

    public ConsoleView getServerConsole() {
        return this.myServerConsole;
    }

    public ConsoleView getMainConsole() {
        return this.getDelegate();
    }

    public ConsoleView getModuleConsole(@NotNull String moduleName) {
        if (moduleName == null) {
            RemoteUiView.$$$reportNull$$$0(0);
        }
        return this.myModuleLogComponent.getOrCreateModuleConsole(moduleName);
    }

    public void buildUi(RunnerLayoutUi layoutUi) {
        Content mainContent = layoutUi.createContent("ConsoleContent", this.getComponent(), "Dev Mode", AllIcons.Debugger.Console, this.getPreferredFocusableComponent());
        mainContent.setCloseable(false);
        RunContentBuilder.addAdditionalConsoleEditorActions((ExecutionConsole)this, (Content)mainContent);
        int tabIndex = this.myDebugSession ? 1 : 0;
        layoutUi.addContent(mainContent, tabIndex++, PlaceInGrid.bottom, false);
        Content modulesContent = layoutUi.createContent("GWT_REMOTE_UI_MODULES_LOG", (JComponent)this.myModuleLogComponent.getMainPanel(), "Modules", AllIcons.Debugger.Console, null);
        modulesContent.setCloseable(false);
        layoutUi.addContent(modulesContent, tabIndex++, PlaceInGrid.center, false);
        Content consoleContent = layoutUi.createContent("GWT_REMOTE_UI_SERVER_LOG", this.myServerConsole.getComponent(), "Server", AllIcons.Debugger.Console, this.myServerConsole.getPreferredFocusableComponent());
        consoleContent.setCloseable(false);
        layoutUi.addContent(consoleContent, tabIndex, PlaceInGrid.right, false);
        layoutUi.getOptions().setMoveToGridActionEnabled(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/gwt/run/remoteUi/RemoteUiView", "getModuleConsole"));
    }
}

