/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtUiXmlFileUtil {
    private static final Key<CachedValue<MultiValuesMap<String, XmlAttributeValue>>> GWT_UI_FIELDS_ATTRIBUTES_MAP = Key.create((String)"GWT_UI_FIELDS_ATTRIBUTES_MAP");

    private GwtUiXmlFileUtil() {
    }

    @Nullable
    public static XmlTag findTagForField(@NotNull XmlFile file, @NotNull String fieldName) {
        MultiValuesMap<String, XmlAttributeValue> map;
        if (file == null) {
            GwtUiXmlFileUtil.$$$reportNull$$$0(0);
        }
        if (fieldName == null) {
            GwtUiXmlFileUtil.$$$reportNull$$$0(1);
        }
        if ((map = GwtUiXmlFileUtil.getFieldNameToAttributeMap(file)) == null) {
            return null;
        }
        XmlAttributeValue value = (XmlAttributeValue)map.getFirst((Object)fieldName);
        if (value != null) {
            return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value, XmlTag.class);
        }
        return null;
    }

    @Nullable
    public static MultiValuesMap<String, XmlAttributeValue> getFieldNameToAttributeMap(XmlFile file) {
        if (!UiBinderUtil.isUiXmlFile(file)) {
            return null;
        }
        return (MultiValuesMap)CachedValuesManager.getManager((Project)file.getProject()).getCachedValue((UserDataHolder)file, GWT_UI_FIELDS_ATTRIBUTES_MAP, (CachedValueProvider)new UiFieldsMapCachedValueProvider(file), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fieldName";
                break;
            }
        }
        objectArray[1] = "com/intellij/gwt/uiBinder/GwtUiXmlFileUtil";
        objectArray[2] = "findTagForField";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class UiFieldsMapCachedValueProvider
    implements CachedValueProvider<MultiValuesMap<String, XmlAttributeValue>> {
        private final XmlFile myFile;

        public UiFieldsMapCachedValueProvider(XmlFile file) {
            this.myFile = file;
        }

        public CachedValueProvider.Result<MultiValuesMap<String, XmlAttributeValue>> compute() {
            final MultiValuesMap result = new MultiValuesMap();
            this.myFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlAttributeValue(XmlAttributeValue value) {
                    XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)value, XmlAttribute.class);
                    if (attribute != null) {
                        String name = attribute.getLocalName();
                        if (name.equals("field") && UiBinderUtil.hasUiBinderNamespace(attribute)) {
                            result.put((Object)value.getValue(), (Object)value);
                        } else if (name.equals("type")) {
                            XmlTag tag = attribute.getParent();
                            if (UiBinderUtil.hasUiBinderNamespace(attribute) && tag != null && tag.getLocalName().equals("style") && tag.getAttribute("field") == null) {
                                result.put((Object)"style", (Object)value);
                            }
                        }
                    }
                }
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{this.myFile});
        }
    }
}

