/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInspection.JspInspectionGroupNames;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jsp.JspBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JspDirectiveInspection
extends LocalInspectionTool {
    @NonNls
    private static final String TAGLIB_DIRECTIVE = "taglib";
    @NonNls
    private static final String URI_ATT = "uri";
    @NonNls
    private static final String TAGDIR_ATT = "tagdir";

    @NotNull
    public String getGroupDisplayName() {
        String string = JspInspectionGroupNames.JSP_INSPECTIONS;
        if (string == null) {
            JspDirectiveInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = JspBundle.message("jsp.directive.inspection", new Object[0]);
        if (string == null) {
            JspDirectiveInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("JspDirectiveInspection" == null) {
            JspDirectiveInspection.$$$reportNull$$$0(2);
        }
        return "JspDirectiveInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            JspDirectiveInspection.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            JspDirectiveInspection.$$$reportNull$$$0(4);
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (tag instanceof JspDirective && JspDirectiveInspection.TAGLIB_DIRECTIVE.equals(tag.getName()) && tag.getAttributeValue(JspDirectiveInspection.URI_ATT) == null && tag.getAttributeValue(JspDirectiveInspection.TAGDIR_ATT) == null) {
                    LocalQuickFix[] localQuickFixArray;
                    JspFile jspFile = (JspFile)tag.getContainingFile();
                    XmlToken element = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
                    assert (element != null);
                    JspManager manager = JspManager.getInstance((Project)jspFile.getProject());
                    if (isOnTheFly) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
                        localQuickFixArray2[0] = new InsertRequiredAttributeFix(tag, JspDirectiveInspection.URI_ATT, manager.getPossibleTldUris(jspFile));
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[1] = new InsertRequiredAttributeFix(tag, JspDirectiveInspection.TAGDIR_ATT, new String[0]);
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    holder.registerProblem((PsiElement)element, JspBundle.message("either.uri.or.tagdir.attribute.should.be.specified", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, fixes);
                }
            }
        };
        if (xmlElementVisitor == null) {
            JspDirectiveInspection.$$$reportNull$$$0(5);
        }
        return xmlElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/jsp/JspDirectiveInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/jsp/JspDirectiveInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

