/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.HashSet;
import com.intellij.util.net.ssl.CertificateInfoPanel;
import com.intellij.util.net.ssl.CertificateListener;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.CertificateTreeBuilder;
import com.intellij.util.net.ssl.CertificateUtil;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CertificateConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
CertificateListener {
    private static final FileTypeDescriptor CERTIFICATE_DESCRIPTOR = new FileTypeDescriptor("Choose Certificate", ".crt", ".cer", ".pem");
    @NonNls
    public static final String EMPTY_PANEL = "empty.panel";
    private JPanel myRootPanel;
    private JBCheckBox myAcceptAutomatically;
    private JPanel myCertificatesListPanel;
    private JPanel myDetailsPanel;
    private JPanel myEmptyPanel;
    private ConfirmingTrustManager.MutableTrustManager myTrustManager;
    private Tree myTree;
    private CertificateTreeBuilder myTreeBuilder;
    private Set<X509Certificate> myCertificates;

    public CertificateConfigurable() {
        this.$$$setupUI$$$();
        this.myCertificates = new HashSet();
    }

    private void initializeUI() {
        this.myTree = new Tree();
        this.myTreeBuilder = new CertificateTreeBuilder(this.myTree);
        this.myTrustManager = CertificateManager.getInstance().getCustomTrustManager();
        this.myTrustManager.addListener(this);
        this.myTree.getEmptyText().setText("No certificates");
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setRootVisible(false);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myTree).disableUpDownActions();
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                FileChooser.chooseFile((FileChooserDescriptor)CERTIFICATE_DESCRIPTOR, null, null, (Consumer<VirtualFile>)((Consumer)file -> {
                    String path2 = file.getPath();
                    X509Certificate certificate = CertificateUtil.loadX509Certificate(path2);
                    if (certificate == null) {
                        Messages.showErrorDialog(CertificateConfigurable.this.myRootPanel, "Malformed X509 server certificate", "Not Imported");
                    } else if (CertificateConfigurable.this.myCertificates.contains(certificate)) {
                        Messages.showWarningDialog(CertificateConfigurable.this.myRootPanel, "Certificate already exists", "Not Imported");
                    } else {
                        CertificateConfigurable.this.myCertificates.add(certificate);
                        CertificateConfigurable.this.myTreeBuilder.addCertificate(certificate);
                        CertificateConfigurable.this.addCertificatePanel(certificate);
                        CertificateConfigurable.this.myTreeBuilder.selectCertificate(certificate);
                    }
                }));
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                for (X509Certificate certificate : CertificateConfigurable.this.myTreeBuilder.getSelectedCertificates(true)) {
                    CertificateConfigurable.this.myCertificates.remove(certificate);
                    CertificateConfigurable.this.myTreeBuilder.removeCertificate(certificate);
                }
                if (CertificateConfigurable.this.myCertificates.isEmpty()) {
                    CertificateConfigurable.this.showCard(CertificateConfigurable.EMPTY_PANEL);
                } else {
                    CertificateConfigurable.this.myTreeBuilder.selectFirstCertificate();
                }
            }
        });
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                X509Certificate certificate = CertificateConfigurable.this.myTreeBuilder.getFirstSelectedCertificate(true);
                if (certificate != null) {
                    CertificateConfigurable.this.showCard(CertificateConfigurable.getCardName(certificate));
                }
            }
        });
        this.myCertificatesListPanel.add((Component)decorator.createPanel(), "Center");
    }

    private void showCard(@NotNull String cardName) {
        if (cardName == null) {
            CertificateConfigurable.$$$reportNull$$$0(0);
        }
        ((CardLayout)this.myDetailsPanel.getLayout()).show(this.myDetailsPanel, cardName);
    }

    private void addCertificatePanel(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateConfigurable.$$$reportNull$$$0(1);
        }
        String uniqueName = CertificateConfigurable.getCardName(certificate);
        CertificateInfoPanel infoPanel = new CertificateInfoPanel(certificate);
        UIUtil.addInsets((JComponent)infoPanel, (Insets)UIUtil.PANEL_REGULAR_INSETS);
        JBScrollPane scrollPane = new JBScrollPane(infoPanel);
        this.myDetailsPanel.add((Component)scrollPane, uniqueName);
    }

    private static String getCardName(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateConfigurable.$$$reportNull$$$0(2);
        }
        return certificate.getSubjectX500Principal().getName();
    }

    @Override
    @NotNull
    public String getId() {
        if ("http.certificates" == null) {
            CertificateConfigurable.$$$reportNull$$$0(3);
        }
        return "http.certificates";
    }

    @Override
    @Nls
    public String getDisplayName() {
        return "Server Certificates";
    }

    @Override
    @Nullable
    public String getHelpTopic() {
        return "reference.idesettings.server.certificates";
    }

    @Override
    @Nullable
    public JComponent createComponent() {
        this.initializeUI();
        return this.myRootPanel;
    }

    @Override
    public boolean isModified() {
        CertificateManager.Config state = CertificateManager.getInstance().getState();
        return this.myAcceptAutomatically.isSelected() != state.ACCEPT_AUTOMATICALLY || !this.myCertificates.equals(new HashSet(this.myTrustManager.getCertificates()));
    }

    @Override
    public void apply() throws ConfigurationException {
        List<X509Certificate> existing = this.myTrustManager.getCertificates();
        HashSet added = new HashSet(this.myCertificates);
        added.removeAll(existing);
        HashSet removed = new HashSet(existing);
        removed.removeAll(this.myCertificates);
        for (X509Certificate certificate : added) {
            if (this.myTrustManager.addCertificate(certificate)) continue;
            throw new ConfigurationException("Cannot add certificate for " + CertificateUtil.getCommonName(certificate), "Cannot Add Certificate");
        }
        for (X509Certificate certificate : removed) {
            if (this.myTrustManager.removeCertificate(certificate)) continue;
            throw new ConfigurationException("Cannot remove certificate for " + CertificateUtil.getCommonName(certificate), "Cannot Remove Certificate");
        }
        CertificateManager.Config state = CertificateManager.getInstance().getState();
        state.ACCEPT_AUTOMATICALLY = this.myAcceptAutomatically.isSelected();
    }

    @Override
    public void reset() {
        List<X509Certificate> original = this.myTrustManager.getCertificates();
        this.myTreeBuilder.reset(original);
        this.myCertificates.clear();
        this.myCertificates.addAll(original);
        this.myDetailsPanel.removeAll();
        this.myDetailsPanel.add((Component)this.myEmptyPanel, EMPTY_PANEL);
        for (X509Certificate certificate : original) {
            this.addCertificatePanel(certificate);
        }
        if (!this.myCertificates.isEmpty()) {
            this.myTreeBuilder.selectFirstCertificate();
        }
        CertificateManager.Config state = CertificateManager.getInstance().getState();
        this.myAcceptAutomatically.setSelected(state.ACCEPT_AUTOMATICALLY);
    }

    @Override
    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myTreeBuilder);
        this.myTrustManager.removeListener(this);
    }

    @Override
    public void certificateAdded(X509Certificate certificate) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myTreeBuilder != null && !this.myCertificates.contains(certificate)) {
                this.myCertificates.add(certificate);
                this.myTreeBuilder.addCertificate(certificate);
                this.addCertificatePanel(certificate);
            }
        });
    }

    @Override
    public void certificateRemoved(X509Certificate certificate) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myTreeBuilder != null && this.myCertificates.contains(certificate)) {
                this.myCertificates.remove(certificate);
                this.myTreeBuilder.removeCertificate(certificate);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cardName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/ssl/CertificateConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/ssl/CertificateConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showCard";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addCertificatePanel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCardName";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JBCheckBox jBCheckBox;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myRootPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCertificatesListPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(BorderFactory.createEtchedBorder(), "Accepted certificates", 0, 0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAcceptAutomatically = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Accept non-trusted certificates automatically");
        jBCheckBox.setMnemonic('A');
        jBCheckBox.setDisplayedMnemonicIndex(32);
        jPanel5.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDetailsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(499, 24), null));
        this.myEmptyPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "Card1");
        JBLabel jBLabel = new JBLabel();
        ((JLabel)jBLabel).setText("No certificate selected");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Splitter splitter = new Splitter();
        splitter.setOrientation(true);
        splitter.setProportion(0.3f);
        splitter.setShowDividerControls(false);
        jPanel4.add((Component)splitter, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        splitter.setFirstComponent((JComponent)jPanel3);
        splitter.setSecondComponent((JComponent)jPanel2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

