/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateClassActionBase;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.GrCreateClassKind;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;

public abstract class CreateClassFix {
    public static IntentionAction createClassFromNewAction(GrNewExpression expression) {
        return new CreateClassActionBase(GrCreateClassKind.CLASS, expression.getReferenceElement()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
                Module module;
                String name;
                String qualifier;
                PsiFile file;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!((file = element.getContainingFile()) instanceof GroovyFileBase)) {
                    return;
                }
                GroovyFileBase groovyFile = (GroovyFileBase)file;
                PsiManager manager = this.myRefElement.getManager();
                AccessToken accessToken = ReadAction.start();
                try {
                    qualifier = groovyFile instanceof GroovyFile ? groovyFile.getPackageName() : "";
                    name = this.myRefElement.getReferenceName();
                    assert (name != null);
                    module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
                }
                finally {
                    accessToken.finish();
                }
                PsiDirectory targetDirectory = this.getTargetDirectory(project, qualifier, name, module, this.getText());
                if (targetDirectory == null) {
                    return;
                }
                GrTypeDefinition targetClass = 1.createClassByType(targetDirectory, name, manager, this.myRefElement, "Groovy Class.groovy", true);
                if (targetClass == null) {
                    return;
                }
                PsiType[] argTypes = CreateClassFix.getArgTypes(this.myRefElement);
                if (argTypes != null && argTypes.length > 0) {
                    CreateClassFix.generateConstructor(this.myRefElement, name, argTypes, targetClass, project);
                    CreateClassFix.bindRef(targetClass, this.myRefElement);
                } else {
                    CreateClassFix.bindRef(targetClass, this.myRefElement);
                    IntentionUtils.positionCursor(project, targetClass.getContainingFile(), targetClass);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$1";
                objectArray[2] = "processIntention";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static PsiType[] getArgTypes(GrReferenceElement refElement) {
        AccessToken accessToken = ReadAction.start();
        try {
            PsiType[] psiTypeArray = PsiUtil.getArgumentTypes(refElement, false);
            return psiTypeArray;
        }
        finally {
            accessToken.finish();
        }
    }

    private static void generateConstructor(@NotNull PsiElement refElement, @NotNull String name, @NotNull PsiType[] argTypes, @NotNull GrTypeDefinition targetClass, @NotNull Project project) {
        if (refElement == null) {
            CreateClassFix.$$$reportNull$$$0(0);
        }
        if (name == null) {
            CreateClassFix.$$$reportNull$$$0(1);
        }
        if (argTypes == null) {
            CreateClassFix.$$$reportNull$$$0(2);
        }
        if (targetClass == null) {
            CreateClassFix.$$$reportNull$$$0(3);
        }
        if (project == null) {
            CreateClassFix.$$$reportNull$$$0(4);
        }
        WriteAction.run(() -> {
            if (argTypes == null) {
                CreateClassFix.$$$reportNull$$$0(9);
            }
            if (refElement == null) {
                CreateClassFix.$$$reportNull$$$0(10);
            }
            if (targetClass == null) {
                CreateClassFix.$$$reportNull$$$0(11);
            }
            if (project == null) {
                CreateClassFix.$$$reportNull$$$0(12);
            }
            if (name == null) {
                CreateClassFix.$$$reportNull$$$0(13);
            }
            ChooseTypeExpression[] paramTypesExpressions = new ChooseTypeExpression[argTypes.length];
            String[] paramTypes = new String[argTypes.length];
            String[] paramNames = new String[argTypes.length];
            for (int i = 0; i < argTypes.length; ++i) {
                PsiType argType = argTypes[i];
                if (argType == null) {
                    argType = TypesUtil.getJavaLangObject(refElement);
                }
                paramTypes[i] = "Object";
                paramNames[i] = "o" + i;
                TypeConstraint[] constraints = new TypeConstraint[]{SupertypeConstraint.create(argType)};
                paramTypesExpressions[i] = new ChooseTypeExpression(constraints, refElement.getManager(), targetClass.getResolveScope());
            }
            GrMethod method = GroovyPsiElementFactory.getInstance(project).createConstructorFromText(name, paramTypes, paramNames, "{\n}");
            method = (GrMethod)targetClass.addBefore(method, null);
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)refElement, (Class[])new Class[]{PsiMethod.class, PsiClass.class, PsiFile.class});
            IntentionUtils.createTemplateForMethod(argTypes, paramTypesExpressions, method, targetClass, TypeConstraint.EMPTY_ARRAY, true, context);
        });
    }

    public static IntentionAction createClassFixAction(GrReferenceElement refElement, GrCreateClassKind type) {
        return new CreateClassActionBase(type, refElement){

            @Override
            protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
                PsiFile file;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!((file = element.getContainingFile()) instanceof GroovyFileBase)) {
                    return;
                }
                GroovyFileBase groovyFile = (GroovyFileBase)file;
                PsiElement qualifier = this.myRefElement.getQualifier();
                if (qualifier == null || qualifier instanceof GrReferenceElement && ((GrReferenceElement)qualifier).resolve() instanceof PsiPackage) {
                    this.createTopLevelClass(project, groovyFile);
                } else {
                    this.createInnerClass(project, editor, qualifier);
                }
            }

            private void createInnerClass(Project project, Editor editor, PsiElement qualifier) {
                PsiElement resolved = this.resolveQualifier(qualifier);
                if (!(resolved instanceof PsiClass)) {
                    return;
                }
                JVMElementFactory factory = JVMElementFactories.getFactory((Language)resolved.getLanguage(), (Project)project);
                if (factory == null) {
                    return;
                }
                String name = this.myRefElement.getReferenceName();
                PsiClass template = this.createTemplate(factory, name);
                if (template == null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (editor != null && editor.getComponent().isDisplayable()) {
                            HintManager.getInstance().showErrorHint(editor, GroovyIntentionsBundle.message("cannot.create.class", new Object[0]));
                        }
                    });
                    return;
                }
                if (!FileModificationService.getInstance().preparePsiElementForWrite(resolved)) {
                    return;
                }
                WriteAction.run(() -> {
                    PsiClass added = (PsiClass)resolved.add((PsiElement)template);
                    PsiModifierList modifierList = added.getModifierList();
                    if (modifierList != null) {
                        modifierList.setModifierProperty("static", true);
                    }
                    IntentionUtils.positionCursor(project, added.getContainingFile(), (PsiElement)added);
                });
            }

            @Nullable
            private PsiElement resolveQualifier(@NotNull PsiElement qualifier) {
                if (qualifier == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (qualifier instanceof GrCodeReferenceElement) {
                    return ((GrCodeReferenceElement)qualifier).resolve();
                }
                if (qualifier instanceof GrExpression) {
                    PsiElement resolved;
                    PsiType type = ((GrExpression)qualifier).getType();
                    if (type instanceof PsiClassType) {
                        return ((PsiClassType)type).resolve();
                    }
                    if (qualifier instanceof GrReferenceExpression && ((resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass || resolved instanceof PsiPackage)) {
                        return resolved;
                    }
                }
                return null;
            }

            @Nullable
            private PsiClass createTemplate(JVMElementFactory factory, String name) {
                switch (this.getType()) {
                    case ENUM: {
                        return factory.createEnum(name);
                    }
                    case TRAIT: {
                        if (factory instanceof GroovyPsiElementFactory) {
                            return ((GroovyPsiElementFactory)factory).createTrait(name);
                        }
                        return null;
                    }
                    case CLASS: {
                        return factory.createClass(name);
                    }
                    case INTERFACE: {
                        return factory.createInterface(name);
                    }
                    case ANNOTATION: {
                        return factory.createAnnotationType(name);
                    }
                }
                return null;
            }

            private void createTopLevelClass(@NotNull Project project, @NotNull GroovyFileBase file) {
                if (project == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(4);
                }
                String pack = this.getPackage(file);
                PsiManager manager = PsiManager.getInstance((Project)project);
                String name = this.myRefElement.getReferenceName();
                assert (name != null);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
                PsiDirectory targetDirectory = this.getTargetDirectory(project, pack, name, module, this.getText());
                if (targetDirectory == null) {
                    return;
                }
                String templateName = CreateClassFix.getTemplateName(this.getType());
                GrTypeDefinition targetClass = 2.createClassByType(targetDirectory, name, manager, this.myRefElement, templateName, true);
                if (targetClass == null) {
                    return;
                }
                CreateClassFix.bindRef(targetClass, this.myRefElement);
                IntentionUtils.positionCursor(project, targetClass.getContainingFile(), targetClass);
            }

            @NotNull
            private String getPackage(@NotNull PsiClassOwner file) {
                PsiElement resolved;
                PsiElement qualifier;
                if (file == null) {
                    2.$$$reportNull$$$0(5);
                }
                if ((qualifier = this.myRefElement.getQualifier()) instanceof GrReferenceElement && (resolved = ((GrReferenceElement)qualifier).resolve()) instanceof PsiPackage) {
                    String string = ((PsiPackage)resolved).getQualifiedName();
                    if (string == null) {
                        2.$$$reportNull$$$0(6);
                    }
                    return string;
                }
                String string = file instanceof GroovyFile ? file.getPackageName() : "";
                if (string == null) {
                    2.$$$reportNull$$$0(7);
                }
                return string;
            }

            @Override
            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    2.$$$reportNull$$$0(8);
                }
                if (!super.isAvailable(project, editor, file)) {
                    return false;
                }
                PsiElement qualifier = this.myRefElement.getQualifier();
                return qualifier == null || this.resolveQualifier(qualifier) != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 6: 
                    case 7: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 6: 
                    case 7: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qualifier";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$2";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPackage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processIntention";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "resolveQualifier";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "createTopLevelClass";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "getPackage";
                        break;
                    }
                    case 6: 
                    case 7: {
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 6: 
                    case 7: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static void bindRef(@NotNull PsiClass targetClass, @NotNull GrReferenceElement ref) {
        if (targetClass == null) {
            CreateClassFix.$$$reportNull$$$0(5);
        }
        if (ref == null) {
            CreateClassFix.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (ref == null) {
                CreateClassFix.$$$reportNull$$$0(7);
            }
            if (targetClass == null) {
                CreateClassFix.$$$reportNull$$$0(8);
            }
            PsiElement newRef = ref.bindToElement((PsiElement)targetClass);
            JavaCodeStyleManager.getInstance((Project)targetClass.getProject()).shortenClassReferences(newRef);
        });
    }

    private static String getTemplateName(GrCreateClassKind createClassKind) {
        switch (createClassKind) {
            case TRAIT: {
                return "Groovy Trait.groovy";
            }
            case ENUM: {
                return "Groovy Enum.groovy";
            }
            case CLASS: {
                return "Groovy Class.groovy";
            }
            case INTERFACE: {
                return "Groovy Interface.groovy";
            }
            case ANNOTATION: {
                return "Groovy Annotation.groovy";
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argTypes";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateConstructor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "bindRef";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$bindRef$1";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$generateConstructor$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

