/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyStaticImportMethodFix
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.annotator.intentions.GroovyStaticImportMethodFix");
    private final SmartPsiElementPointer<GrMethodCall> myMethodCall;
    private List<PsiMethod> myCandidates;

    public GroovyStaticImportMethodFix(@NotNull GrMethodCall methodCallExpression) {
        if (methodCallExpression == null) {
            GroovyStaticImportMethodFix.$$$reportNull$$$0(0);
        }
        this.myCandidates = null;
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCallExpression.getProject()).createSmartPsiElementPointer((PsiElement)methodCallExpression);
    }

    @Override
    @NotNull
    public String getText() {
        String text = "Static import method";
        if (this.getCandidates().size() == 1) {
            int options = 6145;
            text = text + " '" + PsiFormatUtil.formatMethod((PsiMethod)this.getCandidates().get(0), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)6145, (int)0) + "'";
        } else {
            text = text + "...";
        }
        String string = text;
        if (string == null) {
            GroovyStaticImportMethodFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            GroovyStaticImportMethodFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private GrReferenceExpression getMethodExpression() {
        GrMethodCall methodCall = (GrMethodCall)this.myMethodCall.getElement();
        if (methodCall == null) {
            return null;
        }
        return GroovyStaticImportMethodFix.getMethodExpression(methodCall);
    }

    @Nullable
    private static GrReferenceExpression getMethodExpression(@NotNull GrMethodCall call) {
        GrExpression result;
        if (call == null) {
            GroovyStaticImportMethodFix.$$$reportNull$$$0(3);
        }
        return (result = call.getInvokedExpression()) instanceof GrReferenceExpression ? (GrReferenceExpression)result : null;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            GroovyStaticImportMethodFix.$$$reportNull$$$0(4);
        }
        this.myCandidates = null;
        if (!file.getManager().isInProject((PsiElement)file)) {
            return false;
        }
        GrReferenceExpression invokedExpression = this.getMethodExpression();
        if (invokedExpression == null || invokedExpression.getQualifierExpression() != null) {
            return false;
        }
        return !this.getCandidates().isEmpty();
    }

    @NotNull
    private List<PsiMethod> getMethodsToImport() {
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)this.myMethodCall.getProject());
        GrMethodCall element = (GrMethodCall)this.myMethodCall.getElement();
        LOG.assertTrue(element != null);
        GrReferenceExpression reference = GroovyStaticImportMethodFix.getMethodExpression(element);
        LOG.assertTrue(reference != null);
        GrArgumentList argumentList = element.getArgumentList();
        String name = reference.getReferenceName();
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        if (name == null) {
            ArrayList<PsiMethod> arrayList = list;
            if (arrayList == null) {
                GroovyStaticImportMethodFix.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        GlobalSearchScope scope = element.getResolveScope();
        PsiMethod[] methods = cache.getMethodsByNameIfNotMoreThan(name, scope, 20);
        ArrayList<PsiMethod> applicableList = new ArrayList<PsiMethod>();
        for (PsiMethod method : methods) {
            PsiFile file;
            ProgressManager.checkCanceled();
            if (JavaCompletionUtil.isInExcludedPackage((PsiMember)method, (boolean)false) || !method.hasModifierProperty("static") || !((file = method.getContainingFile()) instanceof PsiClassOwner) || ((PsiClassOwner)file).getPackageName().isEmpty() || !PsiUtil.isAccessible(element, (PsiMember)method)) continue;
            list.add(method);
            if (!PsiUtil.isApplicable(PsiUtil.getArgumentTypes(element, true), method, PsiSubstitutor.EMPTY, element, false)) continue;
            applicableList.add(method);
        }
        ArrayList<PsiMethod> result = applicableList.isEmpty() ? list : applicableList;
        Collections.sort(result, new PsiProximityComparator((PsiElement)argumentList));
        ArrayList<PsiMethod> arrayList = result;
        if (arrayList == null) {
            GroovyStaticImportMethodFix.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            GroovyStaticImportMethodFix.$$$reportNull$$$0(7);
        }
        if (project == null) {
            GroovyStaticImportMethodFix.$$$reportNull$$$0(8);
        }
        if (this.getCandidates().size() == 1) {
            PsiMethod toImport = this.getCandidates().get(0);
            this.doImport(toImport);
        } else {
            this.chooseAndImport(editor);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix$1", "satisfiedBy"));
            }
        };
        if (psiElementPredicate == null) {
            GroovyStaticImportMethodFix.$$$reportNull$$$0(9);
        }
        return psiElementPredicate;
    }

    private void doImport(PsiMethod toImport) {
        CommandProcessor.getInstance().executeCommand(toImport.getProject(), () -> WriteAction.run(() -> {
            try {
                GrReferenceExpression expression = this.getMethodExpression();
                if (expression != null) {
                    expression.bindToElementViaStaticImport((PsiMember)toImport);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }), this.getText(), (Object)this);
    }

    private void chooseAndImport(Editor editor) {
        JBList list = new JBList((Object[])this.getCandidates().toArray(new PsiMethod[this.getCandidates().size()]));
        list.setCellRenderer(new MethodCellRenderer(true));
        new PopupChooserBuilder((JList)list).setTitle(QuickFixBundle.message((String)"static.import.method.choose.method.to.import", (Object[])new Object[0])).setMovable(true).setItemChoosenCallback(() -> this.lambda$chooseAndImport$2((JList)list)).createPopup().showInBestPositionFor(editor);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    private List<PsiMethod> getCandidates() {
        List<PsiMethod> result = this.myCandidates;
        if (result == null) {
            this.myCandidates = result = this.getMethodsToImport();
        }
        List<PsiMethod> list = result;
        if (list == null) {
            GroovyStaticImportMethodFix.$$$reportNull$$$0(10);
        }
        return list;
    }

    private /* synthetic */ void lambda$chooseAndImport$2(JList list) {
        PsiMethod selectedValue = (PsiMethod)list.getSelectedValue();
        if (selectedValue == null) {
            return;
        }
        LOG.assertTrue(selectedValue.isValid());
        this.doImport(selectedValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsToImport";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMethodExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

