/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public abstract class GroovyFileBaseImpl
extends PsiFileBase
implements GroovyFileBase,
GrControlFlowOwner {
    private volatile SoftReference<Instruction[]> myControlFlow;

    protected GroovyFileBaseImpl(FileViewProvider viewProvider, @NotNull Language language) {
        if (language == null) {
            GroovyFileBaseImpl.$$$reportNull$$$0(0);
        }
        super(viewProvider, language);
    }

    public GroovyFileBaseImpl(IFileElementType root, IFileElementType root1, FileViewProvider provider2) {
        this(provider2, root.getLanguage());
        this.init((IElementType)root, (IElementType)root1);
    }

    @NotNull
    public FileType getFileType() {
        GroovyFileType groovyFileType = GroovyFileType.GROOVY_FILE_TYPE;
        if (groovyFileType == null) {
            GroovyFileBaseImpl.$$$reportNull$$$0(1);
        }
        return groovyFileType;
    }

    public String toString() {
        return "Groovy script";
    }

    @Override
    @NotNull
    public GrTypeDefinition[] getTypeDefinitions() {
        StubElement stub = this.getStub();
        if (stub != null) {
            GrTypeDefinition[] grTypeDefinitionArray = (GrTypeDefinition[])stub.getChildrenByType(TokenSets.TYPE_DEFINITIONS, GrTypeDefinition.ARRAY_FACTORY);
            if (grTypeDefinitionArray == null) {
                GroovyFileBaseImpl.$$$reportNull$$$0(2);
            }
            return grTypeDefinitionArray;
        }
        GrTypeDefinition[] grTypeDefinitionArray = (GrTypeDefinition[])this.calcTreeElement().getChildrenAsPsiElements(TokenSets.TYPE_DEFINITIONS, GrTypeDefinition.ARRAY_FACTORY);
        if (grTypeDefinitionArray == null) {
            GroovyFileBaseImpl.$$$reportNull$$$0(3);
        }
        return grTypeDefinitionArray;
    }

    @Override
    @NotNull
    public GrMethod[] getMethods() {
        StubElement stub = this.getStub();
        if (stub != null) {
            GrMethod[] grMethodArray = (GrMethod[])stub.getChildrenByType((IElementType)GroovyElementTypes.METHOD_DEFINITION, GrMethod.ARRAY_FACTORY);
            if (grMethodArray == null) {
                GroovyFileBaseImpl.$$$reportNull$$$0(4);
            }
            return grMethodArray;
        }
        GrMethod[] grMethodArray = (GrMethod[])this.calcTreeElement().getChildrenAsPsiElements((IElementType)GroovyElementTypes.METHOD_DEFINITION, GrMethod.ARRAY_FACTORY);
        if (grMethodArray == null) {
            GroovyFileBaseImpl.$$$reportNull$$$0(5);
        }
        return grMethodArray;
    }

    @Override
    @NotNull
    public GrTopStatement[] getTopStatements() {
        GrTopStatement[] grTopStatementArray = (GrTopStatement[])this.findChildrenByClass(GrTopStatement.class);
        if (grTopStatementArray == null) {
            GroovyFileBaseImpl.$$$reportNull$$$0(6);
        }
        return grTopStatementArray;
    }

    public boolean importClass(PsiClass aClass) {
        return this.addImportForClass(aClass) != null;
    }

    @Override
    public void removeImport(@NotNull GrImportStatement importStatement) throws IncorrectOperationException {
        if (importStatement == null) {
            GroovyFileBaseImpl.$$$reportNull$$$0(7);
        }
        GroovyCodeStyleManager.getInstance(this.getProject()).removeImport(this, importStatement);
    }

    @Override
    public void removeElements(PsiElement[] elements) throws IncorrectOperationException {
        for (PsiElement element : elements) {
            if (!element.isValid()) continue;
            if (element.getParent() != this) {
                throw new IncorrectOperationException();
            }
            this.deleteChildRange(element, element);
        }
    }

    @Override
    @NotNull
    public GrStatement[] getStatements() {
        GrStatement[] grStatementArray = (GrStatement[])this.findChildrenByClass(GrStatement.class);
        if (grStatementArray == null) {
            GroovyFileBaseImpl.$$$reportNull$$$0(8);
        }
        return grStatementArray;
    }

    @Override
    @NotNull
    public GrStatement addStatementBefore(@NotNull GrStatement statement, @Nullable GrStatement anchor) throws IncorrectOperationException {
        if (statement == null) {
            GroovyFileBaseImpl.$$$reportNull$$$0(9);
        }
        PsiElement result = this.addBefore(statement, anchor);
        if (anchor != null) {
            this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchor.getNode());
        } else {
            this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", result.getNode());
        }
        GrStatement grStatement = (GrStatement)result;
        if (grStatement == null) {
            GroovyFileBaseImpl.$$$reportNull$$$0(10);
        }
        return grStatement;
    }

    @Override
    public void removeVariable(GrVariable variable) {
        PsiImplUtil.removeVariable(variable);
    }

    @Override
    public GrVariableDeclaration addVariableDeclarationBefore(GrVariableDeclaration declaration, GrStatement anchor) throws IncorrectOperationException {
        GrStatement statement = this.addStatementBefore(declaration, anchor);
        assert (statement instanceof GrVariableDeclaration);
        return (GrVariableDeclaration)statement;
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitFile(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor2) {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)child).accept(visitor2);
        }
    }

    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getTypeDefinitions();
        if (psiClassArray == null) {
            GroovyFileBaseImpl.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    public void clearCaches() {
        super.clearCaches();
        this.myControlFlow = null;
    }

    @Override
    public Instruction[] getControlFlow() {
        assert (this.isValid());
        Instruction[] result = (Instruction[])SoftReference.dereference(this.myControlFlow);
        if (result == null) {
            result = new ControlFlowBuilder(this.getProject()).buildControlFlow(this);
            this.myControlFlow = new SoftReference((Object)result);
        }
        return ControlFlowBuilder.assertValidPsi(result);
    }

    @Override
    public boolean isTopControlFlowOwner() {
        return false;
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        if (last instanceof GrTopStatement) {
            PsiImplUtil.deleteStatementTail(this, last);
        }
        super.deleteChildRange(first, last);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDefinitions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopStatements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addStatementBefore";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeImport";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addStatementBefore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

