/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifiableCodeBlock;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.resolve.SymbolCollectingProcessor;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyImportHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrPackageDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.ImplicitImportsKt;
import org.jetbrains.plugins.groovy.lang.resolve.MethodTypeInferencer;
import org.jetbrains.plugins.groovy.lang.resolve.PackageSkippingProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;

public class GroovyFileImpl
extends GroovyFileBaseImpl
implements GroovyFile,
PsiModifiableCodeBlock {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl");
    private static final String SYNTHETIC_PARAMETER_NAME = "args";
    private static final CachedValueProvider<ConcurrentMap<String, GrBindingVariable>> BINDING_PROVIDER = () -> {
        ConcurrentMap map2 = ContainerUtil.newConcurrentMap();
        return CachedValueProvider.Result.create((Object)map2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    };
    private volatile Boolean myScript;
    private volatile GroovyScriptClass myScriptClass;
    private volatile GrParameter mySyntheticArgsParameter;
    private volatile PsiElement myContext;
    private final CachedValue<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> myResolveCache;

    public GroovyFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, GroovyLanguage.INSTANCE);
        this.myResolveCache = CachedValuesManager.getManager((Project)this.myManager.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.buildDeclarationCache(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}), false);
    }

    @Override
    @NotNull
    public String getPackageName() {
        String name;
        GrPackageDefinition packageDef = this.getPackageDefinition();
        if (packageDef != null && (name = packageDef.getPackageName()) != null) {
            String string = name;
            if (string == null) {
                GroovyFileImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        if ("" == null) {
            GroovyFileImpl.$$$reportNull$$$0(1);
        }
        return "";
    }

    @Override
    public GrPackageDefinition getPackageDefinition() {
        StubElement stub = this.getStub();
        if (stub != null) {
            for (StubElement element : stub.getChildrenStubs()) {
                if (!(element instanceof GrPackageDefinitionStub)) continue;
                return (GrPackageDefinition)element.getPsi();
            }
            return null;
        }
        ASTNode node = this.calcTreeElement().findChildByType((IElementType)GroovyElementTypes.PACKAGE_DEFINITION);
        return node != null ? (GrPackageDefinition)node.getPsi() : null;
    }

    private GrParameter getSyntheticArgsParameter() {
        GrParameter parameter = this.mySyntheticArgsParameter;
        if (parameter == null) {
            PsiType psiType = JavaPsiFacade.getElementFactory((Project)this.getProject()).createTypeFromText("java.lang.String[]", (PsiElement)this);
            this.mySyntheticArgsParameter = parameter = new GrLightParameter(SYNTHETIC_PARAMETER_NAME, psiType, this);
        }
        return parameter;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            GroovyFileImpl.$$$reportNull$$$0(2);
        }
        if (state == null) {
            GroovyFileImpl.$$$reportNull$$$0(3);
        }
        if (place == null) {
            GroovyFileImpl.$$$reportNull$$$0(4);
        }
        return this.shouldProcessCachedDeclarations(place) ? GroovyFileImpl.processCachedDeclarations(processor, state, (MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>)((MostlySingularMultiMap)this.myResolveCache.getValue())) : this.processDeclarationsNoGuess(processor, state, lastParent, place);
    }

    private boolean shouldProcessCachedDeclarations(@NotNull PsiElement place) {
        if (place == null) {
            GroovyFileImpl.$$$reportNull$$$0(5);
        }
        if (!this.isPhysical()) {
            return false;
        }
        if (this.isScript()) {
            return false;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return false;
        }
        if (Registry.is((String)"groovy.skip.file.cache.for.annotations") && PsiUtilKt.isAnnotationReference(place)) {
            return false;
        }
        return this.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING) == Boolean.TRUE || this.myResolveCache.hasUpToDateValue();
    }

    private static boolean processCachedDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> cache) {
        if (processor == null) {
            GroovyFileImpl.$$$reportNull$$$0(6);
        }
        if (state == null) {
            GroovyFileImpl.$$$reportNull$$$0(7);
        }
        for (PsiScopeProcessor each : GroovyResolverProcessor.allProcessors(processor)) {
            String name = ResolveUtil.getNameHint(each);
            Processor cacheProcessor = res -> {
                if (state == null) {
                    GroovyFileImpl.$$$reportNull$$$0(30);
                }
                return each.execute((PsiElement)res.getElement(), state.put(ClassHint.RESOLVE_CONTEXT, (Object)res.getFileContext()));
            };
            boolean result = name != null ? cache.processForKey((Object)name, cacheProcessor) : cache.processAllValues(cacheProcessor);
            if (result) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> buildDeclarationCache() {
        final MostlySingularMultiMap results2 = new MostlySingularMultiMap();
        this.processDeclarationsNoGuess((PsiScopeProcessor)new BaseScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                PsiElement context;
                String name;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof PsiNamedElement && (name = this.getDeclarationName((PsiNamedElement)element, context = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT))) != null) {
                    results2.add((Object)name, (Object)new SymbolCollectingProcessor.ResultWithContext((PsiNamedElement)element, context));
                }
                return true;
            }

            private String getDeclarationName(@NotNull PsiNamedElement element, @Nullable PsiElement context) {
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                String name = context instanceof GrImportStatement ? ((GrImportStatement)context).getImportedName() : null;
                return name != null ? name : element.getName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDeclarationName";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, ResolveState.initial(), null, this);
        MostlySingularMultiMap mostlySingularMultiMap = results2;
        if (mostlySingularMultiMap == null) {
            GroovyFileImpl.$$$reportNull$$$0(8);
        }
        return mostlySingularMultiMap;
    }

    private boolean processDeclarationsNoGuess(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            GroovyFileImpl.$$$reportNull$$$0(9);
        }
        if (state == null) {
            GroovyFileImpl.$$$reportNull$$$0(10);
        }
        if (place == null) {
            GroovyFileImpl.$$$reportNull$$$0(11);
        }
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (this.myContext != null) {
            return !ResolveUtil.shouldProcessProperties(classHint) || this.processChildrenScopes(processor, state, lastParent, place);
        }
        boolean processClasses = ResolveUtil.shouldProcessClasses(classHint);
        GrImportStatement[] importStatements = this.getImportStatements();
        if (!this.processImports(processor, state, lastParent, place, importStatements, GroovyImportHelper.ImportKind.ALIAS, false)) {
            return false;
        }
        GroovyScriptClass scriptClass = this.getScriptClass();
        if (scriptClass != null && StringUtil.isJavaIdentifier((String)scriptClass.getName())) {
            if (!(lastParent instanceof GrTypeDefinition) && !ResolveUtil.processClassDeclarations(scriptClass, processor, state, lastParent, place)) {
                return false;
            }
            if (processClasses && !ResolveUtil.processElement(processor, scriptClass, state)) {
                return false;
            }
        }
        if (processClasses) {
            for (GrTypeDefinition definition : this.getTypeDefinitions()) {
                if (ResolveUtil.processElement(processor, definition, state)) continue;
                return false;
            }
        }
        if (ResolveUtil.shouldProcessProperties(classHint) && !this.processChildrenScopes(processor, state, lastParent, place)) {
            return false;
        }
        if (!this.processImports(processor, state, lastParent, place, importStatements, GroovyImportHelper.ImportKind.ALIAS, true)) {
            return false;
        }
        if (!this.processImports(processor, state, lastParent, place, importStatements, GroovyImportHelper.ImportKind.SIMPLE, null)) {
            return false;
        }
        if (!this.processDeclarationsInPackage(processor, state, lastParent, place)) {
            return false;
        }
        if (!this.processImports(processor, state, lastParent, place, importStatements, GroovyImportHelper.ImportKind.ON_DEMAND, null)) {
            return false;
        }
        if (!ImplicitImportsKt.processImplicitImports(processor, state, lastParent, place, this)) {
            return false;
        }
        if (ResolveUtil.shouldProcessPackages(classHint)) {
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            String expectedName = nameHint != null ? nameHint.getName(state) : null;
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
            if (expectedName != null) {
                PsiPackage pkg = facade.findPackage(expectedName);
                if (pkg != null && !processor.execute((PsiElement)pkg, state)) {
                    return false;
                }
            } else {
                PsiPackage defaultPackage = facade.findPackage("");
                if (defaultPackage != null) {
                    for (PsiPackage subPackage : defaultPackage.getSubPackages(this.getResolveScope())) {
                        if (ResolveUtil.processElement(processor, (PsiNamedElement)subPackage, state)) continue;
                        return false;
                    }
                }
            }
        }
        return !ResolveUtil.shouldProcessProperties(classHint) || lastParent == null || lastParent instanceof GrTypeDefinition || scriptClass == null || ResolveUtil.processElement(processor, this.getSyntheticArgsParameter(), state);
    }

    public boolean isInScriptBody(PsiElement lastParent, PsiElement place) {
        return this.isScript() && !(lastParent instanceof GrTypeDefinition) && PsiTreeUtil.getParentOfType((PsiElement)place, GrTypeDefinition.class, (boolean)false) == null;
    }

    protected boolean processImports(PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place, @NotNull GrImportStatement[] importStatements, @NotNull GroovyImportHelper.ImportKind kind, @Nullable Boolean processStatic) {
        if (state == null) {
            GroovyFileImpl.$$$reportNull$$$0(12);
        }
        if (place == null) {
            GroovyFileImpl.$$$reportNull$$$0(13);
        }
        if (importStatements == null) {
            GroovyFileImpl.$$$reportNull$$$0(14);
        }
        if (kind == null) {
            GroovyFileImpl.$$$reportNull$$$0(15);
        }
        return GroovyImportHelper.processImports(state, lastParent, place, processor, importStatements, kind, processStatic);
    }

    @NotNull
    public ConcurrentMap<String, GrBindingVariable> getBindings() {
        ConcurrentMap concurrentMap = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)this, BINDING_PROVIDER);
        if (concurrentMap == null) {
            GroovyFileImpl.$$$reportNull$$$0(16);
        }
        return concurrentMap;
    }

    @Override
    public boolean isTopControlFlowOwner() {
        return true;
    }

    private boolean processDeclarationsInPackage(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        PsiPackage aPackage;
        if (processor == null) {
            GroovyFileImpl.$$$reportNull$$$0(17);
        }
        if (state == null) {
            GroovyFileImpl.$$$reportNull$$$0(18);
        }
        if (place == null) {
            GroovyFileImpl.$$$reportNull$$$0(19);
        }
        if (ResolveUtil.shouldProcessClasses((ElementClassHint)processor.getHint(ElementClassHint.KEY)) && (aPackage = JavaPsiFacade.getInstance((Project)this.getProject()).findPackage(this.getPackageName())) != null) {
            return aPackage.processDeclarations((PsiScopeProcessor)new PackageSkippingProcessor(processor), state, lastParent, place);
        }
        return true;
    }

    private boolean processChildrenScopes(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        PsiElement run;
        StubElement stub;
        if (processor == null) {
            GroovyFileImpl.$$$reportNull$$$0(20);
        }
        if (state == null) {
            GroovyFileImpl.$$$reportNull$$$0(21);
        }
        if (place == null) {
            GroovyFileImpl.$$$reportNull$$$0(22);
        }
        if ((stub = this.getStub()) != null) {
            return true;
        }
        PsiElement psiElement = run = lastParent == null ? this.getLastChild() : lastParent.getPrevSibling();
        while (run != null) {
            if (GroovyFileImpl.shouldProcess(lastParent, run) && !run.processDeclarations(processor, state, null, place)) {
                return false;
            }
            run = run.getPrevSibling();
        }
        return true;
    }

    private static boolean shouldProcess(@Nullable PsiElement lastParent, @NotNull PsiElement run) {
        if (run == null) {
            GroovyFileImpl.$$$reportNull$$$0(23);
        }
        return run instanceof GrAssignmentExpression || run instanceof GrTupleAssignmentExpression || run instanceof GrVariableDeclaration && !(lastParent instanceof GrMember);
    }

    @Override
    public GrImportStatement[] getImportStatements() {
        StubElement stub = this.getStub();
        if (stub != null) {
            return (GrImportStatement[])stub.getChildrenByType((IElementType)GroovyElementTypes.IMPORT_STATEMENT, GrImportStatement.ARRAY_FACTORY);
        }
        return (GrImportStatement[])this.calcTreeElement().getChildrenAsPsiElements((IElementType)GroovyElementTypes.IMPORT_STATEMENT, GrImportStatement.ARRAY_FACTORY);
    }

    @Override
    public GrImportStatement addImportForClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GroovyFileImpl.$$$reportNull$$$0(24);
        }
        try {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            String qname = aClass.getQualifiedName();
            if (qname != null) {
                GrImportStatement importStatement = factory.createImportStatementFromText(qname, false, false, null);
                return this.addImport(importStatement);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Override
    @NotNull
    public GrImportStatement addImport(@NotNull GrImportStatement statement) throws IncorrectOperationException {
        if (statement == null) {
            GroovyFileImpl.$$$reportNull$$$0(25);
        }
        GrImportStatement grImportStatement = GroovyCodeStyleManager.getInstance(this.getProject()).addImport(this, statement);
        if (grImportStatement == null) {
            GroovyFileImpl.$$$reportNull$$$0(26);
        }
        return grImportStatement;
    }

    @Override
    public boolean isScript() {
        StubElement stub = this.getStub();
        if (stub instanceof GrFileStub) {
            return ((GrFileStub)stub).isScript();
        }
        Boolean isScript = this.myScript;
        if (isScript == null) {
            this.myScript = isScript = Boolean.valueOf(this.checkIsScript());
        }
        return isScript;
    }

    private boolean checkIsScript() {
        GrTopStatement[] topStatements = (GrTopStatement[])this.findChildrenByClass(GrTopStatement.class);
        boolean hasClassDefinitions = false;
        boolean hasTopStatements = false;
        for (GrTopStatement st : topStatements) {
            if (st instanceof GrTypeDefinition) {
                hasClassDefinitions = true;
                continue;
            }
            if (st instanceof GrImportStatement || st instanceof GrPackageDefinition) continue;
            hasTopStatements = true;
            break;
        }
        return hasTopStatements || !hasClassDefinitions;
    }

    public void subtreeChanged() {
        this.myScript = null;
        super.subtreeChanged();
    }

    @Override
    public GroovyScriptClass getScriptClass() {
        if (!this.isScript()) {
            return null;
        }
        GroovyScriptClass aClass = this.myScriptClass;
        if (aClass == null) {
            this.myScriptClass = aClass = new GroovyScriptClass(this);
        }
        return aClass;
    }

    @Override
    public void setPackageName(String packageName) {
        GrCodeReferenceElement packageReference;
        FileASTNode fileNode = this.getNode();
        GrPackageDefinition currentPackage = this.getPackageDefinition();
        if (packageName == null || packageName.isEmpty()) {
            if (currentPackage != null) {
                ASTNode currNode = currentPackage.getNode();
                fileNode.removeChild(currNode);
            }
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        GrPackageDefinition newPackage = (GrPackageDefinition)factory.createTopElementFromText("package " + packageName);
        if (currentPackage != null && (packageReference = currentPackage.getPackageReference()) != null) {
            GrCodeReferenceElement ref = newPackage.getPackageReference();
            if (ref != null) {
                packageReference.replace(ref);
            }
            return;
        }
        ASTNode newNode = newPackage.getNode();
        if (currentPackage != null) {
            ASTNode currNode = currentPackage.getNode();
            fileNode.replaceChild(currNode, newNode);
        } else {
            ASTNode anchor = fileNode.getFirstChildNode();
            if (anchor != null && anchor.getElementType() == GroovyTokenTypes.mSH_COMMENT) {
                anchor = anchor.getTreeNext();
                fileNode.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchor);
            }
            fileNode.addChild(newNode, anchor);
            if (anchor != null && !anchor.getText().startsWith("\n\n")) {
                fileNode.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchor);
            }
        }
    }

    @Override
    @Nullable
    public GrPackageDefinition setPackage(@Nullable GrPackageDefinition newPackage) {
        GrPackageDefinition oldPackage = this.getPackageDefinition();
        if (oldPackage == null) {
            if (newPackage != null) {
                GrPackageDefinition result = (GrPackageDefinition)this.addAfter(newPackage, null);
                this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", result.getNode().getTreeNext());
                return result;
            }
        } else {
            if (newPackage != null) {
                return (GrPackageDefinition)oldPackage.replace(newPackage);
            }
            oldPackage.delete();
        }
        return null;
    }

    @Override
    public PsiType getInferredScriptReturnType() {
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)GroovyPsiManager.inferType(this, new MethodTypeInferencer(this)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myScriptClass = null;
        this.mySyntheticArgsParameter = null;
    }

    public PsiElement getContext() {
        return this.myContext != null && this.myContext.isValid() ? this.myContext : super.getContext();
    }

    protected GroovyFileImpl clone() {
        GroovyFileImpl clone = (GroovyFileImpl)super.clone();
        clone.myContext = this.myContext;
        return clone;
    }

    public void setContext(PsiElement context) {
        if (context != null) {
            this.myContext = context;
        }
    }

    public void setContextNullable(PsiElement context) {
        this.myContext = context;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] declaredDefs = super.getClasses();
        if (!this.isScript()) {
            if (declaredDefs == null) {
                GroovyFileImpl.$$$reportNull$$$0(27);
            }
            return declaredDefs;
        }
        GroovyScriptClass scriptClass = this.getScriptClass();
        PsiClass[] result = new PsiClass[declaredDefs.length + 1];
        result[result.length - 1] = scriptClass;
        System.arraycopy(declaredDefs, 0, result, 0, declaredDefs.length);
        if (result == null) {
            GroovyFileImpl.$$$reportNull$$$0(28);
        }
        return result;
    }

    public PsiElement getOriginalElement() {
        PsiElement originalElement;
        GroovyScriptClass scriptClass = this.getScriptClass();
        if (scriptClass != null && (originalElement = scriptClass.getOriginalElement()) != scriptClass && originalElement != null) {
            return originalElement.getContainingFile();
        }
        return this;
    }

    @Override
    @NotNull
    public GrVariableDeclaration[] getScriptDeclarations(boolean topLevelOnly) {
        GrVariableDeclaration[] grVariableDeclarationArray = PsiImplUtilKt.getScriptDeclarations(this, topLevelOnly);
        if (grVariableDeclarationArray == null) {
            GroovyFileImpl.$$$reportNull$$$0(29);
        }
        return grVariableDeclarationArray;
    }

    public boolean shouldChangeModificationCount(PsiElement place) {
        if (!this.isContentsLoaded()) {
            return true;
        }
        return !this.isScript() || PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{GrTypeDefinition.class, GrVariableDeclaration.class}) != null;
    }

    @Override
    public String toString() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return super.toString();
        }
        return "GroovyFileImpl:" + this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 12: 
            case 18: 
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatements";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "run";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDeclarationCache";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindings";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "addImport";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessCachedDeclarations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processCachedDeclarations";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsNoGuess";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processImports";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInPackage";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processChildrenScopes";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcess";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addImportForClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processCachedDeclarations$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

