/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.memberPullUp;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.classMembers.GrMemberInfo;
import org.jetbrains.plugins.groovy.refactoring.classMembers.GrMemberInfoStorage;
import org.jetbrains.plugins.groovy.refactoring.memberPullUp.GrPullUpConflictsUtil;
import org.jetbrains.plugins.groovy.refactoring.memberPullUp.GrPullUpDialog;

public class GrPullUpHandler
implements RefactoringActionHandler,
GrPullUpDialog.Callback,
ElementsHandler {
    private static final Logger LOG = Logger.getInstance(GrPullUpHandler.class);
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"pull.members.up.title");
    private PsiClass mySubclass;
    private Project myProject;

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            GrPullUpHandler.$$$reportNull$$$0(0);
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.pull.members.from"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.pullMembersUp");
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)element)) {
                return;
            }
            if (element instanceof GrTypeDefinition || element instanceof GrField || element instanceof GrMethod) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            GrPullUpHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            GrPullUpHandler.$$$reportNull$$$0(2);
        }
        if (elements.length != 1) {
            return;
        }
        this.myProject = project;
        PsiElement element = elements[0];
        if (element instanceof GrTypeDefinition) {
            GrTypeDefinition aClass = (GrTypeDefinition)element;
            this.invokeImpl(project, dataContext, aClass, null);
        } else if (element instanceof GrMethod || element instanceof GrField) {
            GrTypeDefinition aClass = (GrTypeDefinition)((GrMember)element).getContainingClass();
            this.invokeImpl(project, dataContext, aClass, element);
        }
    }

    private void invokeImpl(Project project, DataContext dataContext, GrTypeDefinition aClass, PsiElement aMember) {
        Editor editor;
        Editor editor2 = editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        if (aClass == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.pullMembersUp");
            return;
        }
        ArrayList bases = RefactoringHierarchyUtil.createBasesList((PsiClass)aClass, (boolean)false, (boolean)true);
        if (bases.isEmpty()) {
            GrTypeDefinition containingClass = (GrTypeDefinition)aClass.getContainingClass();
            if (containingClass != null) {
                this.invokeImpl(project, dataContext, containingClass, aClass);
                return;
            }
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.does.not.have.base.classes.interfaces.in.current.project", (Object[])new Object[]{aClass.getQualifiedName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.pullMembersUp");
            return;
        }
        this.mySubclass = aClass;
        GrMemberInfoStorage memberInfoStorage = new GrMemberInfoStorage((GrTypeDefinition)this.mySubclass, new MemberInfoBase.Filter<GrMember>(){

            public boolean includeMember(GrMember element) {
                return true;
            }
        });
        List members = memberInfoStorage.getClassMemberInfos((PsiElement)this.mySubclass);
        PsiManager manager = this.mySubclass.getManager();
        for (GrMemberInfo member : members) {
            if (!manager.areElementsEquivalent(member.getMember(), aMember)) continue;
            member.setChecked(true);
            break;
        }
        GrPullUpDialog dialog = new GrPullUpDialog(project, aClass, bases, memberInfoStorage, this);
        dialog.show();
    }

    @Override
    public boolean checkConflicts(GrPullUpDialog dialog) {
        List _infos = dialog.getSelectedMemberInfos();
        GrMemberInfo[] infos = _infos.toArray(new GrMemberInfo[_infos.size()]);
        PsiClass superClass = (PsiClass)dialog.getSuperClass();
        if (!this.checkWritable(superClass, infos)) {
            return false;
        }
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            PsiDirectory targetDirectory = superClass.getContainingFile().getContainingDirectory();
            PsiPackage targetPackage = targetDirectory != null ? JavaDirectoryService.getInstance().getPackage(targetDirectory) : null;
            conflicts.putAllValues(GrPullUpConflictsUtil.checkConflicts(infos, this.mySubclass, superClass, targetPackage, targetDirectory, dialog.getContainmentVerifier()));
        }), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, this.myProject)) {
            return false;
        }
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, conflicts);
            conflictsDialog.show();
            boolean ok = conflictsDialog.isOK();
            if (!ok && conflictsDialog.isShowConflicts()) {
                dialog.close(1);
            }
            return ok;
        }
        return true;
    }

    private boolean checkWritable(PsiClass superClass, GrMemberInfo[] infos) {
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)superClass)) {
            return false;
        }
        for (GrMemberInfo info : infos) {
            if (info.getMember() instanceof PsiClass && info.getOverrides() != null || CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)info.getMember())) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PsiClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/refactoring/memberPullUp/GrPullUpHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

