/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.snapShooter;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.util.JreVersionDetector;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.designSurface.InsertComponentProcessor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.radComponents.LayoutManagerRegistry;
import com.intellij.uiDesigner.radComponents.RadComponentFactory;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.snapShooter.SnapShooterConfigurationSettings;
import com.intellij.uiDesigner.snapShooter.SnapShotClient;
import com.intellij.uiDesigner.snapShooter.SnapShotRemoteComponent;
import com.intellij.uiDesigner.snapShooter.SnapShotTreeModel;
import com.intellij.util.IncorrectOperationException;
import icons.UIDesignerIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSnapShotAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.uiDesigner.snapShooter.CreateSnapShotAction");

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        e.getPresentation().setVisible(project != null && view != null && CreateSnapShotAction.hasDirectoryInPackage(project, view));
    }

    private static boolean hasDirectoryInPackage(Project project, IdeView view) {
        PsiDirectory[] dirs;
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiDirectory dir : dirs = view.getDirectories()) {
            if (!projectFileIndex.isInSourceContent(dir.getVirtualFile()) || JavaDirectoryService.getInstance().getPackage(dir) == null) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        if (project == null || view == null) {
            return;
        }
        PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null) {
            return;
        }
        SnapShotClient client = new SnapShotClient();
        ArrayList<RunnerAndConfigurationSettings> appConfigurations = new ArrayList<RunnerAndConfigurationSettings>();
        RunnerAndConfigurationSettings snapshotConfiguration = null;
        boolean connected = false;
        ApplicationConfigurationType cfgType = ApplicationConfigurationType.getInstance();
        List racsi = RunManager.getInstance((Project)project).getConfigurationSettingsList((ConfigurationType)cfgType);
        for (RunnerAndConfigurationSettings config : racsi) {
            if (!(config.getConfiguration() instanceof ApplicationConfiguration)) continue;
            ApplicationConfiguration appConfig = (ApplicationConfiguration)config.getConfiguration();
            appConfigurations.add(config);
            if (appConfig.ENABLE_SWING_INSPECTOR) {
                SnapShooterConfigurationSettings settings = SnapShooterConfigurationSettings.get((RunConfigurationBase)appConfig);
                snapshotConfiguration = config;
                if (settings.getLastPort() > 0) {
                    try {
                        client.connect(settings.getLastPort());
                        connected = true;
                    }
                    catch (IOException ex) {
                        connected = false;
                    }
                }
            }
            if (!connected) continue;
            break;
        }
        if (snapshotConfiguration == null && (snapshotConfiguration = CreateSnapShotAction.promptForSnapshotConfiguration(project, appConfigurations)) == null) {
            return;
        }
        if (!connected) {
            int rc = Messages.showYesNoDialog((Project)project, (String)UIDesignerBundle.message("snapshot.run.prompt", new Object[0]), (String)UIDesignerBundle.message("snapshot.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (rc == 1) {
                return;
            }
            ApplicationConfiguration appConfig = (ApplicationConfiguration)snapshotConfiguration.getConfiguration();
            SnapShooterConfigurationSettings settings = SnapShooterConfigurationSettings.get((RunConfigurationBase)appConfig);
            settings.setNotifyRunnable(() -> ApplicationManager.getApplication().invokeLater(() -> {
                Messages.showMessageDialog((Project)project, (String)UIDesignerBundle.message("snapshot.prepare.notice", new Object[0]), (String)UIDesignerBundle.message("snapshot.title", new Object[0]), (Icon)Messages.getInformationIcon());
                try {
                    client.connect(settings.getLastPort());
                }
                catch (IOException ex) {
                    Messages.showMessageDialog((Project)project, (String)UIDesignerBundle.message("snapshot.connection.error", new Object[0]), (String)UIDesignerBundle.message("snapshot.title", new Object[0]), (Icon)Messages.getErrorIcon());
                    return;
                }
                CreateSnapShotAction.runSnapShooterSession(client, project, dir, view);
            }));
            try {
                ExecutionEnvironmentBuilder.create((Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunnerAndConfigurationSettings)snapshotConfiguration).buildAndExecute();
            }
            catch (ExecutionException ex) {
                Messages.showMessageDialog((Project)project, (String)UIDesignerBundle.message("snapshot.run.error", ex.getMessage()), (String)UIDesignerBundle.message("snapshot.title", new Object[0]), (Icon)Messages.getErrorIcon());
            }
        } else {
            CreateSnapShotAction.runSnapShooterSession(client, project, dir, view);
        }
    }

    private static void runSnapShooterSession(SnapShotClient client, Project project, PsiDirectory dir, IdeView view) {
        try {
            client.suspendSwing();
        }
        catch (IOException e1) {
            Messages.showMessageDialog((Project)project, (String)UIDesignerBundle.message("snapshot.connection.error", new Object[0]), (String)UIDesignerBundle.message("snapshot.title", new Object[0]), (Icon)Messages.getInformationIcon());
            return;
        }
        MyDialog dlg = new MyDialog(project, client, dir);
        dlg.show();
        if (dlg.getExitCode() == 0) {
            int id = dlg.getSelectedComponentId();
            Ref result = new Ref();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                try {
                    result.set((Object)client.createSnapshot(id));
                }
                catch (Exception ex) {
                    result.set((Object)ex);
                }
            }, UIDesignerBundle.message("progress.creating.snapshot", new Object[0]), false, project);
            String snapshot = null;
            if (result.get() instanceof String) {
                snapshot = (String)result.get();
            } else {
                Exception ex = (Exception)result.get();
                Messages.showMessageDialog((Project)project, (String)UIDesignerBundle.message("snapshot.create.error", ex.getMessage()), (String)UIDesignerBundle.message("snapshot.title", new Object[0]), (Icon)Messages.getErrorIcon());
            }
            if (snapshot != null) {
                String snapshot1 = snapshot;
                ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project, () -> {
                    try {
                        PsiFile formFile = PsiFileFactory.getInstance((Project)dir.getProject()).createFileFromText(dlg.getFormName() + ".form", snapshot1);
                        formFile = (PsiFile)dir.add((PsiElement)formFile);
                        formFile.getVirtualFile().setCharset(CharsetToolkit.UTF8_CHARSET);
                        formFile.getViewProvider().getDocument().setText((CharSequence)snapshot1);
                        view.selectElement((PsiElement)formFile);
                    }
                    catch (IncorrectOperationException ex) {
                        Messages.showMessageDialog((Project)project, (String)UIDesignerBundle.message("snapshot.save.error", ex.getMessage()), (String)UIDesignerBundle.message("snapshot.title", new Object[0]), (Icon)Messages.getErrorIcon());
                    }
                }, "", null));
            }
        }
        try {
            client.resumeSwing();
        }
        catch (IOException ex) {
            Messages.showErrorDialog((Project)project, (String)UIDesignerBundle.message("snapshot.connection.broken", new Object[0]), (String)UIDesignerBundle.message("snapshot.title", new Object[0]));
        }
        client.dispose();
    }

    @Nullable
    private static RunnerAndConfigurationSettings promptForSnapshotConfiguration(Project project, List<RunnerAndConfigurationSettings> configurations) {
        RunnerAndConfigurationSettings snapshotConfiguration;
        if (configurations.isEmpty()) {
            Messages.showMessageDialog((Project)project, (String)UIDesignerBundle.message("snapshot.no.configuration.error", new Object[0]), (String)UIDesignerBundle.message("snapshot.title", new Object[0]), (Icon)Messages.getInformationIcon());
            return null;
        }
        for (int i = configurations.size() - 1; i >= 0; --i) {
            JreVersionDetector detector = new JreVersionDetector();
            ApplicationConfiguration configuration = (ApplicationConfiguration)configurations.get(i).getConfiguration();
            if (detector.isJre50Configured((CommonJavaRunConfigurationParameters)configuration) || detector.isModuleJre50Configured((ModuleBasedConfiguration)configuration)) continue;
            configurations.remove(i);
        }
        if (configurations.isEmpty()) {
            Messages.showMessageDialog((Project)project, (String)UIDesignerBundle.message("snapshot.no.compatible.configuration.error", new Object[0]), (String)UIDesignerBundle.message("snapshot.title", new Object[0]), (Icon)Messages.getInformationIcon());
            return null;
        }
        if (configurations.size() == 1) {
            int rc = Messages.showYesNoDialog((Project)project, (String)UIDesignerBundle.message("snapshot.confirm.configuration.prompt", configurations.get(0).getConfiguration().getName()), (String)UIDesignerBundle.message("snapshot.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (rc == 1) {
                return null;
            }
            snapshotConfiguration = configurations.get(0);
        } else {
            String[] names = new String[configurations.size()];
            for (int i = 0; i < configurations.size(); ++i) {
                names[i] = configurations.get(i).getConfiguration().getName();
            }
            int rc = Messages.showChooseDialog((Project)project, (String)UIDesignerBundle.message("snapshot.choose.configuration.prompt", new Object[0]), (String)UIDesignerBundle.message("snapshot.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])names, (String)names[0]);
            if (rc < 0) {
                return null;
            }
            snapshotConfiguration = configurations.get(rc);
        }
        ((ApplicationConfiguration)snapshotConfiguration.getConfiguration()).ENABLE_SWING_INSPECTOR = true;
        return snapshotConfiguration;
    }

    private static class MyDialog
    extends DialogWrapper {
        private JPanel myRootPanel;
        private JTree myComponentTree;
        private JTextField myFormNameTextField;
        private JLabel myErrorLabel;
        private final Project myProject;
        private final SnapShotClient myClient;
        private final PsiDirectory myDirectory;
        @NonNls
        private static final String SWING_PACKAGE = "javax.swing.";

        private MyDialog(Project project, SnapShotClient client, PsiDirectory dir) {
            super(project, true);
            this.myProject = project;
            this.myClient = client;
            this.myDirectory = dir;
            this.$$$setupUI$$$();
            this.init();
            this.setTitle(UIDesignerBundle.message("snapshot.title", new Object[0]));
            SnapShotTreeModel model = new SnapShotTreeModel(client);
            this.myComponentTree.setModel(model);
            this.myComponentTree.getSelectionModel().setSelectionMode(1);
            this.myComponentTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    this.updateOKAction();
                }
            });
            for (int i = 0; i < 2; ++i) {
                for (int row = this.myComponentTree.getRowCount() - 1; row >= 0; --row) {
                    this.myComponentTree.expandRow(row);
                }
            }
            this.myComponentTree.getSelectionModel().setSelectionPath(this.myComponentTree.getPathForRow(0));
            this.myFormNameTextField.setText(this.suggestFormName());
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            TextAttributes attributes = globalScheme.getAttributes(JavaHighlightingColors.STRING);
            final SimpleTextAttributes titleAttributes = new SimpleTextAttributes(0, attributes.getForegroundColor());
            this.myComponentTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    SnapShotRemoteComponent rc = (SnapShotRemoteComponent)value;
                    String className = rc.getClassName();
                    if (className.startsWith(MyDialog.SWING_PACKAGE)) {
                        this.append(className.substring(MyDialog.SWING_PACKAGE.length()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else {
                        this.append(className, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    if (rc.getText().length() > 0) {
                        this.append(" \"" + rc.getText() + "\"", titleAttributes);
                    }
                    if (rc.getLayoutManager().length() > 0) {
                        this.append(" (" + rc.getLayoutManager() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                    if (rc.isTopLevel()) {
                        this.setIcon(AllIcons.FileTypes.UiForm);
                    } else {
                        Palette palette = Palette.getInstance(myProject);
                        ComponentItem item = palette.getItem(rc.getClassName());
                        if (item != null) {
                            this.setIcon(item.getSmallIcon());
                        } else {
                            this.setIcon(UIDesignerIcons.Unknown);
                        }
                    }
                }
            });
            this.myFormNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    this.updateOKAction();
                }
            });
            this.updateOKAction();
        }

        @NonNls
        private String suggestFormName() {
            int count = 0;
            while (this.myDirectory.findFile("Form" + ++count + ".form") != null) {
            }
            return "Form" + count;
        }

        private void updateOKAction() {
            boolean selectedComponentValid = this.isSelectedComponentValid();
            this.setOKActionEnabled(this.isFormNameValid() && selectedComponentValid);
            if (this.myComponentTree.getSelectionPath() != null && !selectedComponentValid) {
                this.myErrorLabel.setText(UIDesignerBundle.message("snapshooter.invalid.container", new Object[0]));
            } else {
                this.myErrorLabel.setText(" ");
            }
        }

        private boolean isSelectedComponentValid() {
            TreePath selectionPath = this.myComponentTree.getSelectionPath();
            if (selectionPath == null) {
                return false;
            }
            SnapShotRemoteComponent rc = (SnapShotRemoteComponent)selectionPath.getLastPathComponent();
            if (this.isValidComponent(rc)) {
                return true;
            }
            if (selectionPath.getPathCount() == 2) {
                SnapShotRemoteComponent[] children = rc.getChildren();
                return children != null && children.length > 0 && this.isValidComponent(children[0]);
            }
            return false;
        }

        private boolean isValidComponent(SnapShotRemoteComponent rc) {
            for (PsiClass componentClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(rc.getClassName().replace('$', '.'), GlobalSearchScope.allScope((Project)this.myProject)); componentClass != null; componentClass = componentClass.getSuperClass()) {
                if (!JPanel.class.getName().equals(componentClass.getQualifiedName()) && !JTabbedPane.class.getName().equals(componentClass.getQualifiedName()) && !JScrollPane.class.getName().equals(componentClass.getQualifiedName()) && !JSplitPane.class.getName().equals(componentClass.getQualifiedName())) continue;
                return true;
            }
            return false;
        }

        private boolean isFormNameValid() {
            return this.myFormNameTextField.getText().length() > 0;
        }

        @NonNls
        protected String getDimensionServiceKey() {
            return "CreateSnapShotAction.MyDialog";
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myFormNameTextField;
        }

        @NotNull
        protected Action getOKAction() {
            Action okAction = super.getOKAction();
            okAction.putValue("Name", UIDesignerBundle.message("create.snapshot.button", new Object[0]));
            Action action = okAction;
            if (action == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            return action;
        }

        protected void doOKAction() {
            if (this.getOKAction().isEnabled()) {
                try {
                    this.myDirectory.checkCreateFile(this.getFormName() + ".form");
                }
                catch (IncorrectOperationException e) {
                    JOptionPane.showMessageDialog(this.myRootPanel, UIDesignerBundle.message("error.form.already.exists", this.getFormName()));
                    return;
                }
                if (!this.checkUnknownLayoutManagers(this.myDirectory.getProject())) {
                    return;
                }
                this.close(0);
            }
        }

        private boolean checkUnknownLayoutManagers(Project project) {
            TreeSet layoutManagerClasses = new TreeSet();
            SnapShotRemoteComponent rc = (SnapShotRemoteComponent)this.myComponentTree.getSelectionPath().getLastPathComponent();
            assert (rc != null);
            Ref err = new Ref();
            Runnable runnable = () -> {
                try {
                    this.collectUnknownLayoutManagerClasses(project, rc, layoutManagerClasses);
                }
                catch (IOException e) {
                    err.set((Object)e);
                }
            };
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, UIDesignerBundle.message("progress.validating.layout.managers", new Object[0]), false, project)) {
                return false;
            }
            if (!err.isNull()) {
                Messages.showErrorDialog((Component)this.myRootPanel, (String)UIDesignerBundle.message("snapshot.connection.broken", new Object[0]), (String)UIDesignerBundle.message("snapshot.title", new Object[0]));
                return false;
            }
            if (!layoutManagerClasses.isEmpty()) {
                StringBuilder builder = new StringBuilder(UIDesignerBundle.message("snapshot.unknown.layout.prefix", new Object[0]));
                for (String layoutManagerClass : layoutManagerClasses) {
                    builder.append(layoutManagerClass).append("\n");
                }
                builder.append(UIDesignerBundle.message("snapshot.unknown.layout.prompt", new Object[0]));
                return Messages.showYesNoDialog((Project)this.myProject, (String)builder.toString(), (String)UIDesignerBundle.message("snapshot.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
            }
            return true;
        }

        private void collectUnknownLayoutManagerClasses(Project project, SnapShotRemoteComponent rc, Set<String> layoutManagerClasses) throws IOException {
            SnapShotRemoteComponent[] children;
            RadComponentFactory factory = InsertComponentProcessor.getRadComponentFactory(project, rc.getClassName());
            if (factory instanceof RadContainer.Factory && rc.getLayoutManager().length() > 0 && !LayoutManagerRegistry.isKnownLayoutClass(rc.getLayoutManager())) {
                layoutManagerClasses.add(rc.getLayoutManager());
            }
            if ((children = rc.getChildren()) == null) {
                children = this.myClient.listChildren(rc.getId());
                rc.setChildren(children);
            }
            for (SnapShotRemoteComponent child : children) {
                this.collectUnknownLayoutManagerClasses(project, child, layoutManagerClasses);
            }
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myRootPanel;
        }

        public int getSelectedComponentId() {
            SnapShotRemoteComponent[] children;
            TreePath selectionPath = this.myComponentTree.getSelectionPath();
            SnapShotRemoteComponent rc = (SnapShotRemoteComponent)selectionPath.getLastPathComponent();
            if (!this.isValidComponent(rc) && selectionPath.getPathCount() == 2 && (children = rc.getChildren()) != null && children.length > 0 && this.isValidComponent(children[0])) {
                return children[0].getId();
            }
            return rc.getId();
        }

        public String getFormName() {
            return this.myFormNameTextField.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/snapShooter/CreateSnapShotAction$MyDialog", "getOKAction"));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JLabel jLabel;
            JTextField jTextField;
            JPanel jPanel;
            this.myRootPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JBScrollPane jBScrollPane = new JBScrollPane();
            jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, null, null));
            Tree tree = new Tree();
            this.myComponentTree = tree;
            tree.setRootVisible(false);
            tree.setShowsRootHandles(true);
            jBScrollPane.setViewportView((Component)tree);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("snapshot.form.name.field"));
            jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myFormNameTextField = jTextField = new JTextField();
            jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            JLabel jLabel3 = new JLabel();
            this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("snapshot.components.label"));
            jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myErrorLabel = jLabel = new JLabel();
            jLabel.setText(" ");
            jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            jLabel2.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myRootPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

