/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.beans;

import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomSetting {
    private String myName;
    private String myDescription;

    public String getName() {
        return this.myName;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public abstract void setStringValue(@NotNull String var1);

    @Nullable
    public abstract String getStringValue();

    public abstract boolean isModified();

    public abstract void apply();

    public abstract void reset();

    protected CustomSetting(String name, String description) {
        this.myName = name;
        this.myDescription = description;
    }

    protected CustomSetting(Key<? extends CustomSetting> key, String description) {
        this.myName = key.toString();
        this.myDescription = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomSetting setting = (CustomSetting)o;
        return this.myName.equals(setting.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public static class BOOLEAN
    extends CustomSetting {
        private Boolean myValue = null;
        private boolean myDefaultValue;
        private boolean myModified;

        public BOOLEAN(Key<BOOLEAN> key, String description, boolean defaultValue) {
            super(key, description);
            this.myDefaultValue = defaultValue;
        }

        public void setBooleanValue(boolean value) {
            boolean currentValue = this.getBooleanValue();
            if (value != currentValue) {
                this.myModified = true;
                this.myValue = value;
            }
        }

        public boolean getBooleanValue() {
            return this.myModified || this.myValue == null ? this.myDefaultValue : this.myValue;
        }

        @Nullable
        public Boolean getValue() {
            return this.myValue;
        }

        public boolean getDefaultValue() {
            return this.myDefaultValue;
        }

        @Override
        public void setStringValue(@NotNull String value) {
            if (value == null) {
                BOOLEAN.$$$reportNull$$$0(0);
            }
            this.setBooleanValue(Boolean.valueOf(value));
        }

        @Override
        @Nullable
        public String getStringValue() {
            return this.myValue == null ? null : Boolean.toString(this.myValue);
        }

        @Override
        public void apply() {
            this.myModified = false;
        }

        @Override
        public void reset() {
            if (this.myModified) {
                this.myValue = null;
            }
            this.myModified = false;
        }

        @Override
        public boolean isModified() {
            return this.myModified;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/facet/beans/CustomSetting$BOOLEAN", "setStringValue"));
        }
    }

    public static class STRING
    extends CustomSetting {
        private String myValue;
        private String myDefaultValue;
        private boolean myModified;

        public STRING(Key<STRING> key, String description, String defaultValue) {
            super(key, description);
            this.myDefaultValue = defaultValue;
        }

        public void clear() {
            this.myValue = null;
        }

        @NotNull
        public String getDefaultValue() {
            String string = this.myDefaultValue;
            if (string == null) {
                STRING.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void setStringValue(@NotNull String value) {
            if (value == null) {
                STRING.$$$reportNull$$$0(1);
            }
            if (!value.equals(this.myValue)) {
                this.myValue = value;
                this.myModified = true;
            }
        }

        @Override
        @Nullable
        public String getStringValue() {
            return this.myValue;
        }

        @Override
        public boolean isModified() {
            return this.myModified;
        }

        @Override
        public void apply() {
            this.myModified = false;
        }

        @Override
        public void reset() {
            if (this.myModified) {
                this.myValue = null;
            }
            this.myModified = false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/facet/beans/CustomSetting$STRING";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/facet/beans/CustomSetting$STRING";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setStringValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

