/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.Actions;
import org.fest.swing.driver.ContainerDriver;
import org.fest.swing.driver.JComponentToolTipQuery;
import org.fest.swing.driver.KeyStrokes;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JComponentDriver
extends ContainerDriver {
    private static final String TOOL_TIP_TEXT_PROPERTY = "toolTipText";

    public JComponentDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JComponentDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    @RunsInCurrentThread
    protected final void scrollToVisible(@Nonnull JComponent c, @Nonnull Rectangle r) {
        if (c == null) {
            JComponentDriver.$$$reportNull$$$0(1);
        }
        if (r == null) {
            JComponentDriver.$$$reportNull$$$0(2);
        }
        c.scrollRectToVisible(r);
    }

    @RunsInCurrentThread
    protected static boolean isVisible(@Nonnull JComponent c, @Nonnull Rectangle r) {
        if (c == null) {
            JComponentDriver.$$$reportNull$$$0(3);
        }
        if (r == null) {
            JComponentDriver.$$$reportNull$$$0(4);
        }
        return c.getVisibleRect().contains(r);
    }

    @RunsInCurrentThread
    protected final boolean isVisible(@Nonnull JComponent c, @Nonnull Point p) {
        if (c == null) {
            JComponentDriver.$$$reportNull$$$0(5);
        }
        if (p == null) {
            JComponentDriver.$$$reportNull$$$0(6);
        }
        return c.getVisibleRect().contains(p);
    }

    @RunsInEDT
    protected final void invokeAction(@Nonnull JComponent c, @Nonnull String name) {
        if (c == null) {
            JComponentDriver.$$$reportNull$$$0(7);
        }
        if (name == null) {
            JComponentDriver.$$$reportNull$$$0(8);
        }
        this.robot.focusAndWaitForFocusGain(c);
        for (KeyStroke keyStroke : JComponentDriver.keyStrokesForAction(c, name)) {
            try {
                this.type((KeyStroke)Preconditions.checkNotNull((Object)keyStroke));
                this.robot.waitForIdle();
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw ActionFailedException.actionFailure(String.format("Unable to type any key for the action with key '%s'", name));
    }

    @RunsInCurrentThread
    private static KeyStroke[] keyStrokesForAction(@Nonnull JComponent component, @Nonnull String actionName) {
        if (component == null) {
            JComponentDriver.$$$reportNull$$$0(9);
        }
        if (actionName == null) {
            JComponentDriver.$$$reportNull$$$0(10);
        }
        Object key = Actions.findActionKey(actionName, (ActionMap)Preconditions.checkNotNull((Object)component.getActionMap()));
        return KeyStrokes.findKeyStrokesForAction(actionName, key, (InputMap)Preconditions.checkNotNull((Object)component.getInputMap()));
    }

    private void type(@Nonnull KeyStroke keyStroke) {
        if (keyStroke == null) {
            JComponentDriver.$$$reportNull$$$0(11);
        }
        if (keyStroke.getKeyCode() == 0) {
            this.robot.type(keyStroke.getKeyChar());
            return;
        }
        this.robot.pressAndReleaseKey(keyStroke.getKeyCode(), keyStroke.getModifiers());
    }

    @RunsInEDT
    public void requireToolTip(@Nonnull JComponent c, @Nullable String expected) {
        if (c == null) {
            JComponentDriver.$$$reportNull$$$0(12);
        }
        TextAssert.verifyThat(JComponentToolTipQuery.toolTipOf(c)).as(JComponentDriver.propertyName(c, TOOL_TIP_TEXT_PROPERTY)).isEqualOrMatches(expected);
    }

    @RunsInEDT
    public void requireToolTip(@Nonnull JComponent c, @Nonnull Pattern pattern) {
        if (c == null) {
            JComponentDriver.$$$reportNull$$$0(13);
        }
        if (pattern == null) {
            JComponentDriver.$$$reportNull$$$0(14);
        }
        TextAssert.verifyThat(JComponentToolTipQuery.toolTipOf(c)).as(JComponentDriver.propertyName(c, TOOL_TIP_TEXT_PROPERTY)).matches(pattern);
    }

    @Nullable
    @RunsInEDT
    public Object clientProperty(@Nonnull JComponent c, @Nonnull Object key) {
        if (c == null) {
            JComponentDriver.$$$reportNull$$$0(15);
        }
        if (key == null) {
            JComponentDriver.$$$reportNull$$$0(16);
        }
        return JComponentDriver.clientPropertyIn(c, Preconditions.checkNotNull((Object)key));
    }

    @Nullable
    private static Object clientPropertyIn(final @Nonnull JComponent c, final @Nonnull Object key) {
        if (c == null) {
            JComponentDriver.$$$reportNull$$$0(17);
        }
        if (key == null) {
            JComponentDriver.$$$reportNull$$$0(18);
        }
        return GuiActionRunner.execute(new GuiQuery<Object>(){

            @Override
            @Nullable
            protected Object executeInEDT() {
                return c.getClientProperty(key);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStroke";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/driver/JComponentDriver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollToVisible";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisible";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeAction";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "keyStrokesForAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "type";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "requireToolTip";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "clientProperty";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "clientPropertyIn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

