/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import javax.annotation.Nonnull;
import javax.swing.JScrollBar;
import org.fest.assertions.Assertions;
import org.fest.assertions.IntAssert;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JScrollBarLocation;
import org.fest.swing.driver.JScrollBarSetValueTask;
import org.fest.swing.driver.JScrollBarValueQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.GenericRange;
import org.fest.swing.util.Pair;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

@InternalApi
public class JScrollBarDriver
extends JComponentDriver {
    private static final String VALUE_PROPERTY = "value";
    private final JScrollBarLocation location;

    public JScrollBarDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JScrollBarDriver.$$$reportNull$$$0(0);
        }
        super(robot);
        this.location = new JScrollBarLocation();
    }

    public void scrollUnitUp(@Nonnull JScrollBar scrollBar) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(1);
        }
        this.scrollUnitUp(scrollBar, 1);
    }

    public void scrollUnitUp(@Nonnull JScrollBar scrollBar, int times) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(2);
        }
        this.checkPositive(times, "scroll up one unit");
        Pair<Point, Integer> scrollInfo = JScrollBarDriver.findScrollUnitInfo(scrollBar, this.location(), times * -1);
        this.scroll(scrollBar, scrollInfo);
    }

    public void scrollUnitDown(@Nonnull JScrollBar scrollBar) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(3);
        }
        this.scrollUnitDown(scrollBar, 1);
    }

    public void scrollUnitDown(@Nonnull JScrollBar scrollBar, int times) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(4);
        }
        this.checkPositive(times, "scroll down one unit");
        Pair<Point, Integer> scrollInfo = JScrollBarDriver.findScrollUnitInfo(scrollBar, this.location(), times);
        this.scroll(scrollBar, scrollInfo);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Point, Integer> findScrollUnitInfo(final @Nonnull JScrollBar scrollBar, final @Nonnull JScrollBarLocation location, final int times) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(5);
        }
        if (location == null) {
            JScrollBarDriver.$$$reportNull$$$0(6);
        }
        Pair<Point, Integer> result = GuiActionRunner.execute(new GuiQuery<Pair<Point, Integer>>(){

            @Override
            protected Pair<Point, Integer> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(scrollBar);
                return JScrollBarDriver.scrollUnitInfo(scrollBar, location, times);
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JScrollBarDriver.$$$reportNull$$$0(7);
        }
        return pair;
    }

    @Nonnull
    @RunsInCurrentThread
    private static Pair<Point, Integer> scrollUnitInfo(@Nonnull JScrollBar scrollBar, @Nonnull JScrollBarLocation location, int times) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(8);
        }
        if (location == null) {
            JScrollBarDriver.$$$reportNull$$$0(9);
        }
        Point where = JScrollBarDriver.blockLocation(scrollBar, location, times);
        int count = times * scrollBar.getUnitIncrement();
        Pair<Point, Integer> pair = Pair.of(where, scrollBar.getValue() + count);
        if (pair == null) {
            JScrollBarDriver.$$$reportNull$$$0(10);
        }
        return pair;
    }

    @RunsInEDT
    public void scrollBlockUp(@Nonnull JScrollBar scrollBar) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(11);
        }
        this.scrollBlockUp(scrollBar, 1);
    }

    @RunsInEDT
    public void scrollBlockUp(@Nonnull JScrollBar scrollBar, int times) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(12);
        }
        this.checkPositive(times, "scroll up one block");
        Pair<Point, Integer> scrollInfo = JScrollBarDriver.validateAndFindScrollBlockInfo(scrollBar, this.location(), times * -1);
        this.scroll(scrollBar, scrollInfo);
    }

    @RunsInEDT
    public void scrollBlockDown(@Nonnull JScrollBar scrollBar) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(13);
        }
        this.scrollBlockDown(scrollBar, 1);
    }

    @RunsInEDT
    public void scrollBlockDown(@Nonnull JScrollBar scrollBar, int times) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(14);
        }
        this.checkPositive(times, "scroll down one block");
        Pair<Point, Integer> scrollInfo = JScrollBarDriver.validateAndFindScrollBlockInfo(scrollBar, this.location(), times);
        this.scroll(scrollBar, scrollInfo);
    }

    private void checkPositive(int times, @Nonnull String action) {
        if (action == null) {
            JScrollBarDriver.$$$reportNull$$$0(15);
        }
        if (times > 0) {
            return;
        }
        String msg = String.format("The number of times to %s should be greater than zero, but was <%d>", action, times);
        throw new IllegalArgumentException(msg);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Point, Integer> validateAndFindScrollBlockInfo(final @Nonnull JScrollBar scrollBar, final @Nonnull JScrollBarLocation location, final int times) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(16);
        }
        if (location == null) {
            JScrollBarDriver.$$$reportNull$$$0(17);
        }
        Pair<Point, Integer> result = GuiActionRunner.execute(new GuiQuery<Pair<Point, Integer>>(){

            @Override
            protected Pair<Point, Integer> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(scrollBar);
                return JScrollBarDriver.scrollBlockInfo(scrollBar, location, times);
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JScrollBarDriver.$$$reportNull$$$0(18);
        }
        return pair;
    }

    @RunsInCurrentThread
    private static Pair<Point, Integer> scrollBlockInfo(@Nonnull JScrollBar scrollBar, @Nonnull JScrollBarLocation location, int times) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(19);
        }
        if (location == null) {
            JScrollBarDriver.$$$reportNull$$$0(20);
        }
        Point where = JScrollBarDriver.blockLocation(scrollBar, location, times);
        int count = times * scrollBar.getBlockIncrement();
        return Pair.of(where, scrollBar.getValue() + count);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point blockLocation(@Nonnull JScrollBar scrollBar, @Nonnull JScrollBarLocation location, int times) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(21);
        }
        if (location == null) {
            JScrollBarDriver.$$$reportNull$$$0(22);
        }
        Point point = times > 0 ? location.blockLocationToScrollDown(scrollBar) : location.blockLocationToScrollUp(scrollBar);
        if (point == null) {
            JScrollBarDriver.$$$reportNull$$$0(23);
        }
        return point;
    }

    @RunsInEDT
    private void scroll(@Nonnull JScrollBar scrollBar, @Nonnull Pair<Point, Integer> scrollInfo) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(24);
        }
        if (scrollInfo == null) {
            JScrollBarDriver.$$$reportNull$$$0(25);
        }
        this.robot.moveMouse(scrollBar, (Point)Preconditions.checkNotNull(scrollInfo.first));
        this.setValueProperty(scrollBar, (Integer)scrollInfo.second);
    }

    @RunsInEDT
    public void scrollToMaximum(@Nonnull JScrollBar scrollBar) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(26);
        }
        Pair<Integer, GenericRange<Point>> scrollInfo = JScrollBarDriver.findScrollToMaximumInfo(scrollBar, this.location());
        this.scroll(scrollBar, (Integer)scrollInfo.first, (GenericRange)Preconditions.checkNotNull(scrollInfo.second));
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Integer, GenericRange<Point>> findScrollToMaximumInfo(final @Nonnull JScrollBar scrollBar, final @Nonnull JScrollBarLocation location) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(27);
        }
        if (location == null) {
            JScrollBarDriver.$$$reportNull$$$0(28);
        }
        Pair<Integer, GenericRange<Point>> result = GuiActionRunner.execute(new GuiQuery<Pair<Integer, GenericRange<Point>>>(){

            @Override
            protected Pair<Integer, GenericRange<Point>> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(scrollBar);
                int position = scrollBar.getMaximum();
                GenericRange scrollInfo = JScrollBarDriver.scrollInfo(scrollBar, location, position);
                return Pair.of(position, scrollInfo);
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JScrollBarDriver.$$$reportNull$$$0(29);
        }
        return pair;
    }

    @RunsInEDT
    public void scrollToMinimum(@Nonnull JScrollBar scrollBar) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(30);
        }
        Pair<Integer, GenericRange<Point>> scrollInfo = JScrollBarDriver.findScrollToMinimumInfo(scrollBar, this.location);
        this.scroll(scrollBar, (Integer)scrollInfo.first, (GenericRange)Preconditions.checkNotNull(scrollInfo.second));
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Integer, GenericRange<Point>> findScrollToMinimumInfo(final @Nonnull JScrollBar scrollBar, final JScrollBarLocation location) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(31);
        }
        Pair<Integer, GenericRange<Point>> result = GuiActionRunner.execute(new GuiQuery<Pair<Integer, GenericRange<Point>>>(){

            @Override
            protected Pair<Integer, GenericRange<Point>> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(scrollBar);
                int position = scrollBar.getMinimum();
                GenericRange scrollInfo = JScrollBarDriver.scrollInfo(scrollBar, location, position);
                return Pair.of(position, scrollInfo);
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JScrollBarDriver.$$$reportNull$$$0(32);
        }
        return pair;
    }

    @RunsInEDT
    public void scrollTo(@Nonnull JScrollBar scrollBar, int position) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(33);
        }
        GenericRange<Point> scrollInfo = JScrollBarDriver.validateAndFindScrollInfo(scrollBar, this.location(), position);
        this.scroll(scrollBar, position, scrollInfo);
    }

    @Nonnull
    @RunsInEDT
    private static GenericRange<Point> validateAndFindScrollInfo(final @Nonnull JScrollBar scrollBar, final @Nonnull JScrollBarLocation location, final int position) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(34);
        }
        if (location == null) {
            JScrollBarDriver.$$$reportNull$$$0(35);
        }
        GenericRange<Point> result = GuiActionRunner.execute(new GuiQuery<GenericRange<Point>>(){

            @Override
            protected GenericRange<Point> executeInEDT() {
                JScrollBarDriver.checkPositionInBounds(scrollBar, position);
                ComponentPreconditions.checkEnabledAndShowing(scrollBar);
                return JScrollBarDriver.scrollInfo(scrollBar, location, position);
            }
        });
        GenericRange genericRange = (GenericRange)Preconditions.checkNotNull(result);
        if (genericRange == null) {
            JScrollBarDriver.$$$reportNull$$$0(36);
        }
        return genericRange;
    }

    @RunsInCurrentThread
    private static void checkPositionInBounds(@Nonnull JScrollBar scrollBar, int position) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(37);
        }
        int min = scrollBar.getMinimum();
        int max = scrollBar.getMaximum();
        if (position >= min && position <= max) {
            return;
        }
        throw new IllegalArgumentException(Strings.concat((Object[])new Object[]{"Position <", position, "> is not within the JScrollBar bounds of <", min, "> and <", max, ">"}));
    }

    @Nonnull
    @RunsInCurrentThread
    private static GenericRange<Point> scrollInfo(@Nonnull JScrollBar scrollBar, @Nonnull JScrollBarLocation location, int position) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(38);
        }
        if (location == null) {
            JScrollBarDriver.$$$reportNull$$$0(39);
        }
        Point from = location.thumbLocation(scrollBar, scrollBar.getValue());
        Point to = location.thumbLocation(scrollBar, position);
        GenericRange<Point> genericRange = new GenericRange<Point>(from, to);
        if (genericRange == null) {
            JScrollBarDriver.$$$reportNull$$$0(40);
        }
        return genericRange;
    }

    private void scroll(@Nonnull JScrollBar scrollBar, int position, @Nonnull GenericRange<Point> points) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(41);
        }
        if (points == null) {
            JScrollBarDriver.$$$reportNull$$$0(42);
        }
        this.simulateScrolling(scrollBar, points);
        this.setValueProperty(scrollBar, position);
    }

    @RunsInEDT
    private void simulateScrolling(@Nonnull JScrollBar scrollBar, @Nonnull GenericRange<Point> points) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(43);
        }
        if (points == null) {
            JScrollBarDriver.$$$reportNull$$$0(44);
        }
        this.robot.moveMouse(scrollBar, points.from());
        this.robot.moveMouse(scrollBar, points.to());
    }

    @RunsInEDT
    private void setValueProperty(@Nonnull JScrollBar scrollBar, int value) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(45);
        }
        JScrollBarSetValueTask.setValue(scrollBar, value);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void requireValue(@Nonnull JScrollBar scrollBar, int value) {
        if (scrollBar == null) {
            JScrollBarDriver.$$$reportNull$$$0(46);
        }
        ((IntAssert)Assertions.assertThat((int)JScrollBarValueQuery.valueOf(scrollBar)).as(JScrollBarDriver.propertyName(scrollBar, VALUE_PROPERTY))).isEqualTo(value);
    }

    @Nonnull
    private JScrollBarLocation location() {
        JScrollBarLocation jScrollBarLocation = this.location;
        if (jScrollBarLocation == null) {
            JScrollBarDriver.$$$reportNull$$$0(47);
        }
        return jScrollBarLocation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 18: 
            case 23: 
            case 29: 
            case 32: 
            case 36: 
            case 40: 
            case 47: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 18: 
            case 23: 
            case 29: 
            case 32: 
            case 36: 
            case 40: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollBar";
                break;
            }
            case 6: 
            case 9: 
            case 17: 
            case 20: 
            case 22: 
            case 28: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 7: 
            case 10: 
            case 18: 
            case 23: 
            case 29: 
            case 32: 
            case 36: 
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JScrollBarDriver";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollInfo";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "points";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JScrollBarDriver";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findScrollUnitInfo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollUnitInfo";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "validateAndFindScrollBlockInfo";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "blockLocation";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findScrollToMaximumInfo";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "findScrollToMinimumInfo";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "validateAndFindScrollInfo";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollInfo";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scrollUnitUp";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scrollUnitDown";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findScrollUnitInfo";
                break;
            }
            case 7: 
            case 10: 
            case 18: 
            case 23: 
            case 29: 
            case 32: 
            case 36: 
            case 40: 
            case 47: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "scrollUnitInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "scrollBlockUp";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "scrollBlockDown";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkPositive";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "validateAndFindScrollBlockInfo";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "scrollBlockInfo";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "blockLocation";
                break;
            }
            case 24: 
            case 25: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "scroll";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "scrollToMaximum";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findScrollToMaximumInfo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "scrollToMinimum";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findScrollToMinimumInfo";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "scrollTo";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "validateAndFindScrollInfo";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "checkPositionInBounds";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "scrollInfo";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "simulateScrolling";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setValueProperty";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "requireValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 18: 
            case 23: 
            case 29: 
            case 32: 
            case 36: 
            case 40: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

