/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Assertions;
import org.fest.assertions.ObjectAssert;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.fixture.ColorFixture;
import org.fest.swing.fixture.FontFixture;
import org.fest.swing.fixture.MouseInputSimulationFixture;
import org.fest.swing.format.Formatting;
import org.fest.swing.query.ComponentEnabledQuery;
import org.fest.swing.timing.Timeout;
import org.fest.util.Preconditions;

public abstract class AbstractComponentFixture<S, C extends Component, D extends ComponentDriver>
implements MouseInputSimulationFixture<S> {
    protected static final String FONT_PROPERTY = "font";
    protected static final String BACKGROUND_PROPERTY = "background";
    protected static final String FOREGROUND_PROPERTY = "foreground";
    private final Robot robot;
    private final C target;
    private final S myself;
    private D driver;

    public AbstractComponentFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nonnull Class<? extends C> type) {
        if (selfType == null) {
            AbstractComponentFixture.$$$reportNull$$$0(0);
        }
        if (robot == null) {
            AbstractComponentFixture.$$$reportNull$$$0(1);
        }
        if (type == null) {
            AbstractComponentFixture.$$$reportNull$$$0(2);
        }
        this(selfType, robot, AbstractComponentFixture.findTarget(robot, type));
    }

    @Nonnull
    private static <C extends Component> C findTarget(@Nonnull Robot robot, @Nonnull Class<? extends C> type) {
        if (robot == null) {
            AbstractComponentFixture.$$$reportNull$$$0(3);
        }
        if (type == null) {
            AbstractComponentFixture.$$$reportNull$$$0(4);
        }
        Preconditions.checkNotNull((Object)robot);
        Preconditions.checkNotNull(type);
        C c = robot.finder().findByType(type, AbstractComponentFixture.requireShowing(robot));
        if (c == null) {
            AbstractComponentFixture.$$$reportNull$$$0(5);
        }
        return c;
    }

    public AbstractComponentFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nullable String name, @Nonnull Class<? extends C> type) {
        if (selfType == null) {
            AbstractComponentFixture.$$$reportNull$$$0(6);
        }
        if (robot == null) {
            AbstractComponentFixture.$$$reportNull$$$0(7);
        }
        if (type == null) {
            AbstractComponentFixture.$$$reportNull$$$0(8);
        }
        this(selfType, robot, AbstractComponentFixture.findTarget(robot, name, type));
    }

    @Nonnull
    private static <C extends Component> C findTarget(@Nonnull Robot robot, @Nullable String name, @Nonnull Class<? extends C> type) {
        if (robot == null) {
            AbstractComponentFixture.$$$reportNull$$$0(9);
        }
        if (type == null) {
            AbstractComponentFixture.$$$reportNull$$$0(10);
        }
        Preconditions.checkNotNull((Object)robot);
        Preconditions.checkNotNull(type);
        C c = robot.finder().findByName(name, type, AbstractComponentFixture.requireShowing(robot));
        if (c == null) {
            AbstractComponentFixture.$$$reportNull$$$0(11);
        }
        return c;
    }

    public AbstractComponentFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nonnull C target) {
        if (selfType == null) {
            AbstractComponentFixture.$$$reportNull$$$0(12);
        }
        if (robot == null) {
            AbstractComponentFixture.$$$reportNull$$$0(13);
        }
        if (target == null) {
            AbstractComponentFixture.$$$reportNull$$$0(14);
        }
        this.myself = ((Class)Preconditions.checkNotNull(selfType)).cast(this);
        this.robot = (Robot)Preconditions.checkNotNull((Object)robot);
        this.target = (Component)Preconditions.checkNotNull(target);
        this.replaceDriverWith(this.createDriver(robot));
    }

    @Nonnull
    protected abstract D createDriver(@Nonnull Robot var1);

    @Nonnull
    protected final D driver() {
        D d = this.driver;
        if (d == null) {
            AbstractComponentFixture.$$$reportNull$$$0(15);
        }
        return d;
    }

    public final void replaceDriverWith(@Nonnull D driver) {
        if (driver == null) {
            AbstractComponentFixture.$$$reportNull$$$0(16);
        }
        this.driver = (ComponentDriver)Preconditions.checkNotNull(driver);
    }

    @Override
    @Nonnull
    public final S click() {
        ((ComponentDriver)this.driver).click((Component)this.target());
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(17);
        }
        return s;
    }

    @Override
    @Nonnull
    public final S click(@Nonnull MouseButton button) {
        if (button == null) {
            AbstractComponentFixture.$$$reportNull$$$0(18);
        }
        ((ComponentDriver)this.driver).click((Component)this.target(), button);
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(19);
        }
        return s;
    }

    @Override
    @Nonnull
    public final S click(@Nonnull MouseClickInfo mouseClickInfo) {
        if (mouseClickInfo == null) {
            AbstractComponentFixture.$$$reportNull$$$0(20);
        }
        ((ComponentDriver)this.driver).click((Component)this.target(), mouseClickInfo);
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(21);
        }
        return s;
    }

    @Override
    @Nonnull
    public final S doubleClick() {
        ((ComponentDriver)this.driver).doubleClick((Component)this.target());
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(22);
        }
        return s;
    }

    @Override
    @Nonnull
    public final S rightClick() {
        ((ComponentDriver)this.driver).rightClick((Component)this.target());
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(23);
        }
        return s;
    }

    @Nonnull
    public final S focus() {
        ((ComponentDriver)this.driver).focus((Component)this.target());
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(24);
        }
        return s;
    }

    @Nonnull
    public final S pressAndReleaseKey(@Nonnull KeyPressInfo keyPressInfo) {
        if (keyPressInfo == null) {
            AbstractComponentFixture.$$$reportNull$$$0(25);
        }
        ((ComponentDriver)this.driver).pressAndReleaseKey((Component)this.target(), keyPressInfo);
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(26);
        }
        return s;
    }

    @Nonnull
    public final S pressAndReleaseKeys(int ... keyCodes) {
        if (keyCodes == null) {
            AbstractComponentFixture.$$$reportNull$$$0(27);
        }
        ((ComponentDriver)this.driver).pressAndReleaseKeys((Component)this.target(), keyCodes);
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(28);
        }
        return s;
    }

    @Nonnull
    public final S pressKey(int keyCode) {
        ((ComponentDriver)this.driver).pressKey((Component)this.target(), keyCode);
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(29);
        }
        return s;
    }

    @Nonnull
    public final S releaseKey(int keyCode) {
        ((ComponentDriver)this.driver).releaseKey((Component)this.target(), keyCode);
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(30);
        }
        return s;
    }

    @Nonnull
    public final S requireFocused() {
        ((ComponentDriver)this.driver).requireFocused((Component)this.target());
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(31);
        }
        return s;
    }

    @Nonnull
    public final S requireEnabled() {
        ((ComponentDriver)this.driver).requireEnabled((Component)this.target());
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(32);
        }
        return s;
    }

    @Nonnull
    public final S requireEnabled(@Nonnull Timeout timeout) {
        if (timeout == null) {
            AbstractComponentFixture.$$$reportNull$$$0(33);
        }
        ((ComponentDriver)this.driver).requireEnabled((Component)this.target(), timeout);
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(34);
        }
        return s;
    }

    @Nonnull
    public final S requireDisabled() {
        ((ComponentDriver)this.driver).requireDisabled((Component)this.target());
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(35);
        }
        return s;
    }

    @Nonnull
    public final S requireVisible() {
        ((ComponentDriver)this.driver).requireVisible((Component)this.target());
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(36);
        }
        return s;
    }

    @Nonnull
    public final S requireNotVisible() {
        ((ComponentDriver)this.driver).requireNotVisible((Component)this.target());
        S s = this.myself();
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(37);
        }
        return s;
    }

    protected boolean requireShowing() {
        return AbstractComponentFixture.requireShowing(this.robot());
    }

    private static boolean requireShowing(@Nonnull Robot robot) {
        if (robot == null) {
            AbstractComponentFixture.$$$reportNull$$$0(38);
        }
        return robot.settings().componentLookupScope().requireShowing();
    }

    @Nonnull
    public final FontFixture font() {
        Font font = ((ComponentDriver)this.driver).fontOf((Component)this.target);
        FontFixture fontFixture = new FontFixture(font, ComponentDriver.propertyName(this.target(), FONT_PROPERTY));
        if (fontFixture == null) {
            AbstractComponentFixture.$$$reportNull$$$0(39);
        }
        return fontFixture;
    }

    @Nonnull
    public final ColorFixture background() {
        Color background = ((ComponentDriver)this.driver).backgroundOf((Component)this.target);
        ColorFixture colorFixture = new ColorFixture(background, ComponentDriver.propertyName(this.target(), BACKGROUND_PROPERTY));
        if (colorFixture == null) {
            AbstractComponentFixture.$$$reportNull$$$0(40);
        }
        return colorFixture;
    }

    @Nonnull
    public final ColorFixture foreground() {
        Color foreground = ((ComponentDriver)this.driver).foregroundOf((Component)this.target);
        ColorFixture colorFixture = new ColorFixture(foreground, ComponentDriver.propertyName(this.target(), FOREGROUND_PROPERTY));
        if (colorFixture == null) {
            AbstractComponentFixture.$$$reportNull$$$0(41);
        }
        return colorFixture;
    }

    public final boolean isEnabled() {
        return ComponentEnabledQuery.isEnabled(this.target());
    }

    @Nonnull
    public final <T extends C> C targetCastedTo(@Nonnull Class<T> type) {
        if (type == null) {
            AbstractComponentFixture.$$$reportNull$$$0(42);
        }
        ((ObjectAssert)Assertions.assertThat(this.target).as(Formatting.format(this.target))).isInstanceOf(type);
        Component component = (Component)type.cast(this.target);
        if (component == null) {
            AbstractComponentFixture.$$$reportNull$$$0(43);
        }
        return (C)component;
    }

    @Nonnull
    public final C target() {
        C c = this.target;
        if (c == null) {
            AbstractComponentFixture.$$$reportNull$$$0(44);
        }
        return c;
    }

    @Nonnull
    public final Robot robot() {
        Robot robot = this.robot;
        if (robot == null) {
            AbstractComponentFixture.$$$reportNull$$$0(45);
        }
        return robot;
    }

    @Nonnull
    protected final S myself() {
        S s = this.myself;
        if (s == null) {
            AbstractComponentFixture.$$$reportNull$$$0(46);
        }
        return s;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfType";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 13: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/fixture/AbstractComponentFixture";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseClickInfo";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPressInfo";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyCodes";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/fixture/AbstractComponentFixture";
                break;
            }
            case 5: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findTarget";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "driver";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "click";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "doubleClick";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "rightClick";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "focus";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "pressAndReleaseKey";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "pressAndReleaseKeys";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "pressKey";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "releaseKey";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "requireFocused";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "requireEnabled";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "requireDisabled";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "requireVisible";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "requireNotVisible";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = FONT_PROPERTY;
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = BACKGROUND_PROPERTY;
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = FOREGROUND_PROPERTY;
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "targetCastedTo";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "target";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "robot";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "myself";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findTarget";
                break;
            }
            case 5: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replaceDriverWith";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "click";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "pressAndReleaseKey";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "pressAndReleaseKeys";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "requireEnabled";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "requireShowing";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "targetCastedTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

