/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.listener;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import org.fest.util.VisibleForTesting;

public final class WeakEventListener
implements AWTEventListener {
    private final WeakReference<AWTEventListener> listenerReference;
    private final Toolkit toolkit;

    @Nonnull
    public static WeakEventListener attachAsWeakEventListener(@Nonnull Toolkit toolkit, @Nonnull AWTEventListener listener, long eventMask) {
        if (toolkit == null) {
            WeakEventListener.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            WeakEventListener.$$$reportNull$$$0(1);
        }
        WeakEventListener l = new WeakEventListener(toolkit, listener);
        toolkit.addAWTEventListener(l, eventMask);
        WeakEventListener weakEventListener = l;
        if (weakEventListener == null) {
            WeakEventListener.$$$reportNull$$$0(2);
        }
        return weakEventListener;
    }

    private WeakEventListener(@Nonnull Toolkit toolkit, @Nonnull AWTEventListener listener) {
        if (toolkit == null) {
            WeakEventListener.$$$reportNull$$$0(3);
        }
        if (listener == null) {
            WeakEventListener.$$$reportNull$$$0(4);
        }
        this.listenerReference = new WeakReference<AWTEventListener>(listener);
        this.toolkit = toolkit;
    }

    @Nonnull
    public AWTEventListener underlyingListener() {
        AWTEventListener aWTEventListener = (AWTEventListener)this.listenerReference.get();
        if (aWTEventListener == null) {
            WeakEventListener.$$$reportNull$$$0(5);
        }
        return aWTEventListener;
    }

    @Override
    public void eventDispatched(AWTEvent e) {
        AWTEventListener listener = (AWTEventListener)this.listenerReference.get();
        if (listener == null) {
            this.dispose();
            return;
        }
        listener.eventDispatched(e);
    }

    public void dispose() {
        this.toolkit.removeAWTEventListener(this);
    }

    @VisibleForTesting
    void simulateUnderlyingListenerIsGarbageCollected() {
        this.listenerReference.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/listener/WeakEventListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/listener/WeakEventListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "attachAsWeakEventListener";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "underlyingListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attachAsWeakEventListener";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

