/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.listener.WeakEventListener;
import org.fest.swing.monitor.Context;
import org.fest.swing.monitor.Windows;
import org.fest.swing.query.ComponentParentQuery;

final class ContextMonitor
implements AWTEventListener {
    private static final long EVENT_MASK = 65L;
    private final Context context;
    private final Windows windows;

    ContextMonitor(Context context, Windows windows) {
        this.context = context;
        this.windows = windows;
    }

    void attachTo(@Nonnull Toolkit toolkit) {
        if (toolkit == null) {
            ContextMonitor.$$$reportNull$$$0(0);
        }
        WeakEventListener.attachAsWeakEventListener(toolkit, this, 65L);
    }

    @Override
    @RunsInEDT
    public void eventDispatched(AWTEvent e) {
        if (!(e instanceof ComponentEvent)) {
            return;
        }
        ComponentEvent event = (ComponentEvent)e;
        Component component = event.getComponent();
        if (!(component instanceof Applet) && !(component instanceof Window)) {
            return;
        }
        this.processEvent(event);
        if (!component.getToolkit().getSystemEventQueue().equals(this.context.storedQueueFor(component))) {
            this.context.addContextFor(component);
        }
    }

    private void processEvent(@Nonnull ComponentEvent event) {
        Component component;
        if (event == null) {
            ContextMonitor.$$$reportNull$$$0(1);
        }
        if ((component = event.getComponent()) == null) {
            return;
        }
        int id = event.getID();
        if (id == 200) {
            this.recognizeAsOpenWindow(component);
            return;
        }
        if (id == 202) {
            this.recognizeAsClosedWindow(component);
            return;
        }
        if (id == 201) {
            return;
        }
        if ((id >= 200 && id <= 209 || id == 102) && (!this.context.rootWindows().contains(component) || this.windows.isClosed(component))) {
            this.recognizeAsOpenWindow(component);
        }
    }

    private void recognizeAsOpenWindow(@Nonnull Component component) {
        if (component == null) {
            ContextMonitor.$$$reportNull$$$0(2);
        }
        this.context.addContextFor(component);
        if (!(component instanceof Window)) {
            return;
        }
        this.windows.attachNewWindowVisibilityMonitor((Window)component);
        this.windows.markAsShowing((Window)component);
        if (component instanceof FileDialog) {
            this.windows.markAsReady((Window)component);
        }
    }

    private void recognizeAsClosedWindow(@Nonnull Component component) {
        if (component == null) {
            ContextMonitor.$$$reportNull$$$0(3);
        }
        if (ComponentParentQuery.parentOf(component) == null) {
            this.context.removeContextFor(component);
        }
        if (component instanceof Window) {
            this.windows.markAsClosed((Window)component);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/monitor/ContextMonitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "attachTo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "recognizeAsOpenWindow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "recognizeAsClosedWindow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

