/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.monitor.Context;
import org.fest.swing.monitor.ContextMonitor;
import org.fest.swing.monitor.WindowAvailabilityMonitor;
import org.fest.swing.monitor.WindowStatus;
import org.fest.swing.monitor.Windows;
import org.fest.swing.util.ToolkitProvider;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

public class WindowMonitor {
    private final Context context;
    private final ContextMonitor contextMonitor;
    private final Windows windows;
    private final WindowStatus windowStatus;
    private final WindowAvailabilityMonitor windowAvailabilityMonitor;

    @RunsInCurrentThread
    WindowMonitor(@Nonnull Toolkit toolkit) {
        if (toolkit == null) {
            WindowMonitor.$$$reportNull$$$0(0);
        }
        this(toolkit, new Context(toolkit), new WindowStatus(new Windows()));
    }

    @VisibleForTesting
    @RunsInCurrentThread
    WindowMonitor(@Nonnull Toolkit toolkit, @Nonnull Context context, @Nonnull WindowStatus windowStatus) {
        if (toolkit == null) {
            WindowMonitor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            WindowMonitor.$$$reportNull$$$0(2);
        }
        if (windowStatus == null) {
            WindowMonitor.$$$reportNull$$$0(3);
        }
        this.context = context;
        this.windowStatus = windowStatus;
        this.windows = windowStatus.windows();
        this.contextMonitor = new ContextMonitor(context, this.windows);
        this.contextMonitor.attachTo(toolkit);
        this.windowAvailabilityMonitor = new WindowAvailabilityMonitor(this.windows);
        this.windowAvailabilityMonitor.attachTo(toolkit);
        this.populateExistingWindows();
    }

    private void populateExistingWindows() {
        for (Frame f : Frame.getFrames()) {
            this.examine((Window)Preconditions.checkNotNull((Object)f));
        }
    }

    @RunsInCurrentThread
    private void examine(@Nonnull Window w) {
        if (w == null) {
            WindowMonitor.$$$reportNull$$$0(4);
        }
        this.windows.attachNewWindowVisibilityMonitor(w);
        for (Window owned : w.getOwnedWindows()) {
            this.examine((Window)Preconditions.checkNotNull((Object)owned));
        }
        this.windows.markExisting(w);
        this.context.addContextFor(w);
    }

    public boolean isWindowReady(@Nonnull Window w) {
        if (w == null) {
            WindowMonitor.$$$reportNull$$$0(5);
        }
        if (this.windows.isReady(w)) {
            return true;
        }
        this.windowStatus.checkIfReady(w);
        return false;
    }

    @Nullable
    public EventQueue eventQueueFor(@Nonnull Component c) {
        if (c == null) {
            WindowMonitor.$$$reportNull$$$0(6);
        }
        return this.context.eventQueueFor(c);
    }

    @Nonnull
    public Collection<EventQueue> allEventQueues() {
        Collection<EventQueue> collection = this.context.allEventQueues();
        if (collection == null) {
            WindowMonitor.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Nonnull
    public Collection<Window> rootWindows() {
        Collection<Window> collection = this.context.rootWindows();
        if (collection == null) {
            WindowMonitor.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Nonnull
    @RunsInEDT
    public static WindowMonitor instance() {
        WindowMonitor windowMonitor = SingletonLazyLoader.INSTANCE;
        if (windowMonitor == null) {
            WindowMonitor.$$$reportNull$$$0(9);
        }
        return windowMonitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowStatus";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/monitor/WindowMonitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/monitor/WindowMonitor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "allEventQueues";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "rootWindows";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "instance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "examine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isWindowReady";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "eventQueueFor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @RunsInEDT
    private static class SingletonLazyLoader {
        static final WindowMonitor INSTANCE = GuiActionRunner.execute(new GuiQuery<WindowMonitor>(){

            @Override
            @Nullable
            protected WindowMonitor executeInEDT() {
                return new WindowMonitor(ToolkitProvider.instance().defaultToolkit());
            }
        });

        private SingletonLazyLoader() {
        }
    }
}

