/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.util.Objects;
import org.fest.util.Preconditions;

public final class Strings {
    public static boolean isDefaultToString(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        int at = s.indexOf("@");
        if (at == -1) {
            return false;
        }
        String hash = s.substring(at + 1, s.length());
        try {
            Integer.parseInt(hash, 16);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean areEqualOrMatch(@Nullable String pattern, @Nullable String s) {
        if (Objects.areEqual((Object)pattern, (Object)s)) {
            return true;
        }
        if (pattern != null && s != null) {
            try {
                return s.matches(pattern);
            }
            catch (PatternSyntaxException invalidRegex) {
                return s.contains(pattern);
            }
        }
        return false;
    }

    public static boolean match(@Nonnull Pattern p, @Nullable String s) {
        if (p == null) {
            Strings.$$$reportNull$$$0(0);
        }
        return Strings.match(p, (CharSequence)s);
    }

    public static boolean match(@Nonnull Pattern p, @Nullable CharSequence s) {
        if (p == null) {
            Strings.$$$reportNull$$$0(1);
        }
        Preconditions.checkNotNull((Object)p);
        if (s == null) {
            return false;
        }
        return p.matcher(s).matches();
    }

    private Strings() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "p", "org/fest/swing/util/Strings", "match"));
    }
}

