/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite.references;

import com.intellij.jsf.composite.CompositeComponentDescriptor;
import com.intellij.jsf.composite.CompositeUtil;
import com.intellij.jsf.composite.references.AbstractCompositeVariantsReferenceProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.xml.XmlElementDescriptor;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractForAttributeReferenceProvider
extends AbstractCompositeVariantsReferenceProvider {
    private static final String FOR_ATTRIBUTE_NAME = "for";
    public final ElementFilter ELEMENT_FILTER = new ElementFilter(){

        public boolean isAcceptable(Object element, PsiElement context) {
            return CompositeUtil.isInsideCompositeComponentTag(context) && AbstractForAttributeReferenceProvider.this.isXmlTagAccepted((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class));
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    };

    protected AbstractForAttributeReferenceProvider(Function<XmlFile, Map<String, PsiElement>> variantsMap) {
        super(variantsMap);
    }

    @Override
    public ElementFilter getElementFilter() {
        return this.ELEMENT_FILTER;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{FOR_ATTRIBUTE_NAME};
    }

    public boolean isXmlTagAccepted(@Nullable XmlTag xmlTag) {
        if (xmlTag == null) {
            return false;
        }
        Map<String, List<String>> map = this.getSupportedTagsMap();
        List<String> tagNames = map.get(xmlTag.getNamespace());
        if (tagNames != null) {
            for (String tagName : tagNames) {
                if (!tagName.equals(xmlTag.getLocalName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    protected XmlFile getCompositeComponentXmlFile(PsiElement xmlAttributeValue) {
        PsiElement element;
        XmlTag componentTag = CompositeUtil.getParentCompositeComponentTag(xmlAttributeValue);
        if (componentTag == null) {
            return null;
        }
        XmlElementDescriptor descriptor = componentTag.getDescriptor();
        if (descriptor instanceof CompositeComponentDescriptor && (element = descriptor.getDeclaration()) instanceof XmlFile) {
            return (XmlFile)element;
        }
        return null;
    }

    public abstract Map<String, List<String>> getSupportedTagsMap();
}

