/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterDescriptor;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JSLinterLanguageServicePackageTracker
implements StartupActivity {
    private static final Logger LOG = Logger.getInstance(JSLinterLanguageServicePackageTracker.class);

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            JSLinterLanguageServicePackageTracker.$$$reportNull$$$0(0);
        }
        List<Class<? extends JSLinterConfiguration>> linters = Arrays.stream(JSLinterDescriptor.EP_NAME.getExtensions()).filter(JSLinterDescriptor::usesLanguageService).map(JSLinterDescriptor::getConfigurationClass).collect(Collectors.toList());
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyListener(project, linters));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterLanguageServicePackageTracker", "runActivity"));
    }

    private static final class MyListener
    extends BulkVirtualFileListenerAdapter {
        public MyListener(final @NotNull Project project, final List<Class<? extends JSLinterConfiguration>> linterConfigurations) {
            if (project == null) {
                MyListener.$$$reportNull$$$0(0);
            }
            super((VirtualFileListener)new VirtualFileContentsChangedAdapter(){

                protected void onFileChange(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (("package.json".equals(file.getName()) || file.isDirectory()) && (JSLibraryUtil.getLibraryFolder(file, "node_modules") != null || "node_modules".equals(file.getName()))) {
                        Ref anyMatch = new Ref((Object)false);
                        linterConfigurations.forEach(configClass -> {
                            Object instance;
                            if (project == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            if (file == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            if (!((JSLinterConfiguration)(instance = JSLinterConfiguration.getInstance(project, configClass))).isEnabled()) {
                                return;
                            }
                            JSNpmLinterState linterState = (JSNpmLinterState)ObjectUtils.tryCast(((JSLinterConfiguration)instance).getExtendedState().getState(), JSNpmLinterState.class);
                            if (linterState != null && !StringUtil.isEmptyOrSpaces((String)linterState.getLinterPackagePath()) && (!file.isDirectory() && FileUtil.pathsEqual((String)file.getParent().getPath(), (String)linterState.getLinterPackagePath()) || file.isDirectory() && FileUtil.isAncestor((String)file.getPath(), (String)linterState.getLinterPackagePath(), (boolean)false))) {
                                Class<JSLinterInspection> clazz = ((JSLinterConfiguration)instance).getInspectionClass();
                                LOG.debug(String.format("Restart '%s' service because of '%s' change", clazz.getName(), file.getPath()));
                                JSLinterInspection.ensureInspectionServiceStopped(project, clazz);
                                anyMatch.set((Object)true);
                            }
                        });
                        if (Boolean.TRUE.equals(anyMatch.get())) {
                            DaemonCodeAnalyzer.getInstance((Project)project).restart();
                        }
                    }
                }

                protected void onBeforeFileChange(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterLanguageServicePackageTracker$MyListener$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onFileChange";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onBeforeFileChange";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$onFileChange$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterLanguageServicePackageTracker$MyListener", "<init>"));
        }
    }
}

