/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.version;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.lang.javascript.linter.jshint.version.JSHintVersionDescriptor;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintVersionUtil {
    private static final Logger LOG = Logger.getInstance(JSHintVersionUtil.class);
    private static final String VERSIONS_JSON_FILENAME = "versions.json";
    private static final String BASE_URL = "http://download.jetbrains.com/idea/jshint";
    public static final String BUNDLED_VERSION = "2.9.5";
    private static final int DOWNLOAD_ATTEMPT_COUNT = 3;
    private static volatile ImmutableList<JSHintVersionDescriptor> OUR_CACHED_VERSION_DESCRIPTORS;

    private JSHintVersionUtil() {
    }

    @NotNull
    public static String guessUrl(@NotNull String version) {
        if (version == null) {
            JSHintVersionUtil.$$$reportNull$$$0(0);
        }
        String string = JSHintVersionUtil.createUrl(JSHintVersionUtil.getJSHintSourceFileBaseName(version));
        if (string == null) {
            JSHintVersionUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void downloadVersions(@Nullable ProgressIndicator indicator) throws IOException {
        String url = JSHintVersionUtil.createUrl(VERSIONS_JSON_FILENAME);
        JSHintVersionUtil.downloadFile(indicator, VERSIONS_JSON_FILENAME, url, 3, (Predicate<String>)((Predicate)input -> {
            if (input != null) {
                try {
                    List<JSHintVersionDescriptor> versions = JSHintVersionUtil.parseVersion(input);
                    return versions.size() > 0;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }));
        OUR_CACHED_VERSION_DESCRIPTORS = null;
    }

    @NotNull
    public static File downloadSourceVersionOnce(@Nullable ProgressIndicator indicator, @NotNull JSHintVersionDescriptor versionDescriptor) throws IOException {
        if (versionDescriptor == null) {
            JSHintVersionUtil.$$$reportNull$$$0(2);
        }
        File file = JSHintVersionUtil.downloadSourceVersion(indicator, versionDescriptor, 1);
        if (file == null) {
            JSHintVersionUtil.$$$reportNull$$$0(3);
        }
        return file;
    }

    @NotNull
    public static File downloadSourceVersion(@Nullable ProgressIndicator indicator, @NotNull JSHintVersionDescriptor versionDescriptor, int attempts) throws IOException {
        if (versionDescriptor == null) {
            JSHintVersionUtil.$$$reportNull$$$0(4);
        }
        String fileBaseName = JSHintVersionUtil.getJSHintSourceFileBaseName(versionDescriptor.getVersion());
        File file = JSHintVersionUtil.downloadFile(indicator, fileBaseName, versionDescriptor.getUrl(), attempts, (Predicate<String>)((Predicate)input -> input != null && input.contains("JSHINT")));
        if (file == null) {
            JSHintVersionUtil.$$$reportNull$$$0(5);
        }
        return file;
    }

    @NotNull
    public static ImmutableList<JSHintVersionDescriptor> getVersions() {
        ImmutableList<JSHintVersionDescriptor> descriptors = OUR_CACHED_VERSION_DESCRIPTORS;
        if (descriptors != null) {
            ImmutableList<JSHintVersionDescriptor> immutableList = descriptors;
            if (immutableList == null) {
                JSHintVersionUtil.$$$reportNull$$$0(6);
            }
            return immutableList;
        }
        OUR_CACHED_VERSION_DESCRIPTORS = descriptors = JSHintVersionUtil.doGetVersions();
        ImmutableList<JSHintVersionDescriptor> immutableList = descriptors;
        if (immutableList == null) {
            JSHintVersionUtil.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    @NotNull
    private static ImmutableList<JSHintVersionDescriptor> doGetVersions() {
        String content;
        File versionJsonFile = JSHintVersionUtil.getVersionsJsonFile();
        Object descriptors = null;
        if (versionJsonFile.isFile()) {
            try {
                content = Files.toString((File)versionJsonFile, (Charset)StandardCharsets.UTF_8);
                descriptors = JSHintVersionUtil.parseVersion(content);
            }
            catch (Exception e) {
                FileUtil.delete((File)versionJsonFile);
                LOG.warn("Can not parse '" + versionJsonFile.getAbsolutePath() + "'!", (Throwable)e);
            }
        }
        if (descriptors == null) {
            try {
                content = JSHintVersionUtil.readFromClassPath(VERSIONS_JSON_FILENAME);
                descriptors = JSHintVersionUtil.parseVersion(content);
            }
            catch (Exception e) {
                throw new RuntimeException("Can not parse bundled versions.json!", e);
            }
        }
        descriptors = JSHintVersionUtil.addGuessableVersionDescriptorFirstIfMissing(descriptors, BUNDLED_VERSION);
        ImmutableList immutableList = ImmutableList.copyOf(descriptors);
        if (immutableList == null) {
            JSHintVersionUtil.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    @NotNull
    public static ImmutableList<JSHintVersionDescriptor> addGuessableVersionDescriptorFirstIfMissing(@NotNull List<JSHintVersionDescriptor> descriptors, @NotNull String version) {
        JSHintVersionDescriptor descriptor2;
        if (descriptors == null) {
            JSHintVersionUtil.$$$reportNull$$$0(9);
        }
        if (version == null) {
            JSHintVersionUtil.$$$reportNull$$$0(10);
        }
        if ((descriptor2 = JSHintVersionUtil.find(descriptors, version)) != null) {
            ImmutableList immutableList = ImmutableList.copyOf(descriptors);
            if (immutableList == null) {
                JSHintVersionUtil.$$$reportNull$$$0(11);
            }
            return immutableList;
        }
        ArrayList list = ContainerUtil.newArrayList();
        list.add(new JSHintVersionDescriptor(version, JSHintVersionUtil.guessUrl(version)));
        list.addAll(descriptors);
        ImmutableList immutableList = ImmutableList.copyOf((Collection)list);
        if (immutableList == null) {
            JSHintVersionUtil.$$$reportNull$$$0(12);
        }
        return immutableList;
    }

    @Nullable
    public static JSHintVersionDescriptor find(@NotNull List<JSHintVersionDescriptor> descriptors, @NotNull String version) {
        if (descriptors == null) {
            JSHintVersionUtil.$$$reportNull$$$0(13);
        }
        if (version == null) {
            JSHintVersionUtil.$$$reportNull$$$0(14);
        }
        for (JSHintVersionDescriptor versionDescriptor : descriptors) {
            if (!versionDescriptor.getVersion().equals(version)) continue;
            return versionDescriptor;
        }
        return null;
    }

    @NotNull
    private static List<JSHintVersionDescriptor> parseVersion(@NotNull String versionsFileContent) {
        List<JSHintVersionDescriptor> list;
        JsonElement jsonElement;
        if (versionsFileContent == null) {
            JSHintVersionUtil.$$$reportNull$$$0(15);
        }
        if (versionsFileContent.trim().isEmpty()) {
            throw new RuntimeException("Can not parse version list from empty content!");
        }
        try {
            JsonParser jsonParser = new JsonParser();
            jsonElement = jsonParser.parse(versionsFileContent);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not parse JSON from version list. Malformed JSON was received, content: '" + versionsFileContent, e);
        }
        try {
            list = JSHintVersionUtil.toVersionList(jsonElement);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Wrong JSON was received, content: '" + versionsFileContent, e);
        }
        if (list == null) {
            JSHintVersionUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    private static List<JSHintVersionDescriptor> toVersionList(@NotNull JsonElement jsonElement) {
        if (jsonElement == null) {
            JSHintVersionUtil.$$$reportNull$$$0(17);
        }
        if (!jsonElement.isJsonArray()) {
            throw new RuntimeException("jsonElement is expected be an instance of " + JsonArray.class.getName());
        }
        JsonArray array = jsonElement.getAsJsonArray();
        ArrayList versions = ContainerUtil.newArrayList();
        for (JsonElement element : array) {
            if (!element.isJsonObject()) {
                throw new RuntimeException("Unexpected child element " + element.getClass().getName());
            }
            JsonObject obj = element.getAsJsonObject();
            JsonElement nameElement = obj.get("version");
            String name = null;
            if (nameElement != null) {
                name = nameElement.getAsString();
            }
            String url = null;
            JsonElement urlElement = obj.get("url");
            if (urlElement != null) {
                url = urlElement.getAsString();
            }
            if (name == null || url == null) continue;
            versions.add(new JSHintVersionDescriptor(name, url));
        }
        ArrayList arrayList = versions;
        if (arrayList == null) {
            JSHintVersionUtil.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    private static String createUrl(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            JSHintVersionUtil.$$$reportNull$$$0(19);
        }
        String string = StringUtil.trimEnd((String)BASE_URL, (String)"/") + "/" + fileBaseName;
        if (string == null) {
            JSHintVersionUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String getJSHintSourceFileBaseName(@NotNull String version) {
        if (version == null) {
            JSHintVersionUtil.$$$reportNull$$$0(21);
        }
        String string = "jshint-" + version + ".js";
        if (string == null) {
            JSHintVersionUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private static File downloadFile(@Nullable ProgressIndicator indicator, @NotNull String fileBaseName, @NotNull String url, int attempts, @Nullable Predicate<String> contentChecker) throws IOException {
        if (fileBaseName == null) {
            JSHintVersionUtil.$$$reportNull$$$0(23);
        }
        if (url == null) {
            JSHintVersionUtil.$$$reportNull$$$0(24);
        }
        File dir = JSHintVersionUtil.getJSHintDirOrCreateIfNeeded();
        File outputFile = new File(dir, fileBaseName);
        File tempFile = FileUtil.createTempFile((File)dir, (String)fileBaseName, (String)".tmp");
        for (int i = 1; i <= attempts; ++i) {
            File file;
            String message = (attempts > 1 ? "[Attempt#" + i + "] " : "") + "Downloading " + url;
            long startTimeNano = System.nanoTime();
            try {
                boolean success = DownloadUtil.downloadAtomically((ProgressIndicator)indicator, (String)url, (File)outputFile, (File)tempFile, contentChecker);
                if (!success) {
                    throw new IOException("Content check failed.");
                }
                LOG.info(message + " succeed in " + JSHintVersionUtil.formatTakenTime(startTimeNano) + " and saved to " + outputFile);
                file = outputFile;
            }
            catch (IOException e) {
                LOG.warn(message + " failed in " + JSHintVersionUtil.formatTakenTime(startTimeNano));
                if (i != attempts) continue;
                throw e;
            }
            if (file == null) {
                JSHintVersionUtil.$$$reportNull$$$0(25);
            }
            return file;
        }
        File file = outputFile;
        if (file == null) {
            JSHintVersionUtil.$$$reportNull$$$0(26);
        }
        return file;
    }

    private static String formatTakenTime(long startTimeNano) {
        return String.format("%.1f ms", (double)(System.nanoTime() - startTimeNano) / 1000000.0);
    }

    @NotNull
    private static File getJSHintDir() {
        File file;
        File javascriptDir = new File(PathManager.getSystemPath(), "javascript");
        File jshintDir = new File(javascriptDir, "jshint");
        try {
            file = jshintDir.getCanonicalFile();
        }
        catch (IOException e) {
            File file2 = jshintDir;
            if (file2 == null) {
                JSHintVersionUtil.$$$reportNull$$$0(28);
            }
            return file2;
        }
        if (file == null) {
            JSHintVersionUtil.$$$reportNull$$$0(27);
        }
        return file;
    }

    @NotNull
    private static File getJSHintDirOrCreateIfNeeded() throws IOException {
        File dir = JSHintVersionUtil.getJSHintDir();
        if (!FileUtil.createDirectory((File)dir)) {
            throw new IOException("Can't create " + dir.getAbsolutePath());
        }
        File file = dir;
        if (file == null) {
            JSHintVersionUtil.$$$reportNull$$$0(29);
        }
        return file;
    }

    private static File getVersionsJsonFile() {
        File jshintDir = JSHintVersionUtil.getJSHintDir();
        return new File(jshintDir, VERSIONS_JSON_FILENAME);
    }

    static boolean isBundledVersion(@NotNull String version) {
        if (version == null) {
            JSHintVersionUtil.$$$reportNull$$$0(30);
        }
        return version.equals(BUNDLED_VERSION);
    }

    public static boolean isSourceLocallyAvailable(@NotNull String version) {
        if (version == null) {
            JSHintVersionUtil.$$$reportNull$$$0(31);
        }
        if (JSHintVersionUtil.isBundledVersion(version)) {
            return true;
        }
        String fileBaseName = JSHintVersionUtil.getJSHintSourceFileBaseName(version);
        File dir = JSHintVersionUtil.getJSHintDir();
        File outputFile = new File(dir, fileBaseName);
        return outputFile.isFile();
    }

    @NotNull
    private static String readFromClassPath(@NotNull String fileBaseName) throws IOException {
        InputStream inputStream;
        if (fileBaseName == null) {
            JSHintVersionUtil.$$$reportNull$$$0(32);
        }
        if ((inputStream = JSHintVersionUtil.class.getResourceAsStream(fileBaseName)) == null) {
            throw new RuntimeException("Resource " + fileBaseName + " is not found!");
        }
        InputStreamReader reader = new InputStreamReader(inputStream, CharsetToolkit.UTF8_CHARSET);
        String string = FileUtil.loadTextAndClose((Reader)reader);
        if (string == null) {
            JSHintVersionUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    public static void downloadSourceContent(@NotNull String version) throws IOException {
        ImmutableList<JSHintVersionDescriptor> descriptors;
        JSHintVersionDescriptor descriptor2;
        if (version == null) {
            JSHintVersionUtil.$$$reportNull$$$0(34);
        }
        if ((descriptor2 = JSHintVersionUtil.find(descriptors = JSHintVersionUtil.getVersions(), version)) == null) {
            JSHintVersionUtil.downloadVersions(null);
            descriptors = JSHintVersionUtil.getVersions();
            descriptor2 = JSHintVersionUtil.find(descriptors, version);
        }
        if (descriptor2 != null) {
            JSHintVersionUtil.downloadSourceVersion(null, descriptor2, 3);
        }
    }

    public static void downloadSourceContentUnderProgress(@NotNull Project project, final @NotNull String version, final @NotNull Runnable callback) {
        if (project == null) {
            JSHintVersionUtil.$$$reportNull$$$0(35);
        }
        if (version == null) {
            JSHintVersionUtil.$$$reportNull$$$0(36);
        }
        if (callback == null) {
            JSHintVersionUtil.$$$reportNull$$$0(37);
        }
        Task.Backgroundable task = new Task.Backgroundable(project, "Updating JSHint to " + version, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    JSHintVersionUtil.downloadSourceContent(version);
                }
                catch (Exception e) {
                    LOG.warn("Can't fetch JSHint " + version, (Throwable)e);
                }
                finally {
                    callback.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil$1", "run"));
            }
        };
        task.queue();
    }

    @Nullable
    public static String loadSourceContentFromLocalDrive(@NotNull String version) throws IOException {
        if (version == null) {
            JSHintVersionUtil.$$$reportNull$$$0(38);
        }
        String fileBaseName = JSHintVersionUtil.getJSHintSourceFileBaseName(version);
        if (JSHintVersionUtil.isBundledVersion(version)) {
            LOG.info("JSHint " + version + " is loaded from classpath");
            return JSHintVersionUtil.readFromClassPath(fileBaseName);
        }
        File dir = JSHintVersionUtil.getJSHintDir();
        File outputFile = new File(dir, fileBaseName);
        if (outputFile.isFile()) {
            LOG.info("JSHint " + version + " is loaded from " + outputFile.getAbsolutePath());
            return FileUtil.loadFile((File)outputFile, (Charset)CharsetToolkit.UTF8_CHARSET);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionDescriptor";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionsFileContent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonElement";
                break;
            }
            case 19: 
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBaseName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "guessUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadSourceVersionOnce";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadSourceVersion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetVersions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addGuessableVersionDescriptorFirstIfMissing";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersion";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toVersionList";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrl";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSHintSourceFileBaseName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFile";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSHintDir";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSHintDirOrCreateIfNeeded";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromClassPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "guessUrl";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "downloadSourceVersionOnce";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "downloadSourceVersion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addGuessableVersionDescriptorFirstIfMissing";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "toVersionList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createUrl";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getJSHintSourceFileBaseName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isBundledVersion";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isSourceLocallyAvailable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "readFromClassPath";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "downloadSourceContent";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "downloadSourceContentUnderProgress";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "loadSourceContentFromLocalDrive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

