/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSInheritedLanguagesConfigurableProvider {
    public static final LanguageExtension<JSInheritedLanguagesConfigurableProvider> INSTANCE = new LanguageExtension("JavaScript.inheritedLanguagesConfigurableProvider");

    public Language getLanguage() {
        return JavascriptLanguage.INSTANCE;
    }

    public boolean isBadExpressionStatement(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(0);
        }
        return true;
    }

    public boolean isNeedToBeTerminated(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(1);
        }
        return true;
    }

    public boolean isLHSExpression(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(2);
        }
        return false;
    }

    public boolean isCaseStatementInterrupted(JSStatement statement) {
        return false;
    }

    public boolean forConditionShouldUseVariables() {
        return true;
    }

    public boolean constructorCallWithoutNewActual() {
        return true;
    }

    public boolean unnecessaryBlockStatement(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(3);
        }
        return true;
    }

    public boolean hasNonBlockBranch(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(4);
        }
        return false;
    }

    public boolean isRemoveUnnecessaryParenthesesEnabled(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(5);
        }
        return true;
    }

    public boolean isSimplifyBooleanFixEnabled(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(6);
        }
        return true;
    }

    public boolean shouldRenameFileWithClass(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(7);
        }
        return true;
    }

    @Nullable
    protected PsiElement createExpressionFromText(@NotNull String text, @NotNull PsiElement element, boolean reportErrorIfFailed) {
        if (text == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(8);
        }
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(9);
        }
        if (reportErrorIfFailed) {
            return JSChangeUtil.createExpressionWithContext(text, element).getPsi();
        }
        ASTNode node = JSChangeUtil.tryCreateExpressionWithContext(text, element);
        return node != null ? node.getPsi() : null;
    }

    protected PsiElement createStatementFromText(@NotNull String text, @NotNull PsiElement element) {
        if (text == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(10);
        }
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(11);
        }
        return JSChangeUtil.createStatementFromText(element.getProject(), text, JSUtils.getDialect(element.getContainingFile())).getPsi();
    }

    public boolean isMultilineLiteral(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(12);
        }
        return element instanceof JSStringTemplateExpression;
    }

    public String getMultilineLiteralContent(@NotNull String text) {
        if (text == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(13);
        }
        return "`" + StringUtil.escapeChar((String)text, (char)'`') + "`";
    }

    public TextRange getRangeInElement(PsiElement element) {
        JSLiteralExpression literal = (JSLiteralExpression)element;
        int length = literal.getTextLength();
        if (literal.isQuotedLiteral() && length >= 2) {
            ASTNode quotedLiteralNode;
            ASTNode backquote;
            int startOffset = 1;
            if (element instanceof JSStringTemplateExpression && (backquote = (quotedLiteralNode = element.getNode()).findChildByType(JSTokenTypes.BACKQUOTE)) != null) {
                startOffset = backquote.getStartOffset() - quotedLiteralNode.getStartOffset() + 1;
            }
            return new TextRange(startOffset, length - 1);
        }
        return new TextRange(0, length);
    }

    public boolean supportsJavaScriptInjections() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isBadExpressionStatement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isNeedToBeTerminated";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isLHSExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "unnecessaryBlockStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNonBlockBranch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRemoveUnnecessaryParenthesesEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isSimplifyBooleanFixEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRenameFileWithClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createExpressionFromText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createStatementFromText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isMultilineLiteral";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getMultilineLiteralContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

