/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSStatementWithLabelReference;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStatementWithLabelReferenceImpl
extends JSStatementImpl
implements JSStatementWithLabelReference {
    private PsiReference[] myReferences;
    private String myReferencesText;

    protected JSStatementWithLabelReferenceImpl(IElementType elementType) {
        super(elementType);
    }

    @Nullable
    public String getLabel() {
        ASTNode label = this.getLabelIdentifierNode();
        return label != null ? label.getText() : null;
    }

    protected ASTNode getLabelIdentifierNode() {
        return this.getNode().findChildByType(JSTokenTypes.IDENTIFIER);
    }

    @Nullable
    public PsiElement getLabelIdentifier() {
        ASTNode labelNode = this.getLabelIdentifierNode();
        return labelNode != null ? labelNode.getPsi() : null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        String text = this.getText();
        if (!text.equals(this.myReferencesText) || this.myReferences == null || this.myReferences.length != 0 && !((LabelReference)this.myReferences[0]).labelNode.isValid()) {
            ASTNode label = this.getLabelIdentifierNode();
            this.myReferences = label != null ? new PsiReference[]{this.createReference(label.getPsi())} : PsiReference.EMPTY_ARRAY;
            this.myReferencesText = text;
        }
        if (this.myReferences == null) {
            JSStatementWithLabelReferenceImpl.$$$reportNull$$$0(0);
        }
        return this.myReferences;
    }

    @NotNull
    protected LabelReference createReference(PsiElement label) {
        LabelReference labelReference = new LabelReference(label);
        if (labelReference == null) {
            JSStatementWithLabelReferenceImpl.$$$reportNull$$$0(1);
        }
        return labelReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/psi/impl/JSStatementWithLabelReferenceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createReference";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    protected class LabelReference
    implements PsiReference {
        private final PsiElement labelNode;

        protected LabelReference(PsiElement _labelNode) {
            this.labelNode = _labelNode;
        }

        public PsiElement getElement() {
            return JSStatementWithLabelReferenceImpl.this;
        }

        public TextRange getRangeInElement() {
            int startOffsetInParent = this.labelNode.getStartOffsetInParent();
            return new TextRange(startOffsetInParent, startOffsetInParent + this.labelNode.getTextLength());
        }

        @Nullable
        public PsiElement resolve() {
            final PsiElement[] result = new PsiElement[1];
            this.processElements(new PsiElementProcessor<JSLabeledStatement>(){
                private final String label;
                {
                    this.label = LabelReference.this.getCanonicalText();
                }

                public boolean execute(@NotNull JSLabeledStatement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (this.label.equals(element.getLabel())) {
                        result[0] = element;
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSStatementWithLabelReferenceImpl$LabelReference$1", "execute"));
                }
            });
            return result[0];
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.labelNode.getText();
            if (string == null) {
                LabelReference.$$$reportNull$$$0(0);
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            JSChangeUtil.doIdentifierReplacement(this.getElement(), this.labelNode, newElementName);
            return this.getElement();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                LabelReference.$$$reportNull$$$0(1);
            }
            return null;
        }

        public boolean isReferenceTo(PsiElement element) {
            return JSStatementWithLabelReferenceImpl.this.getManager().areElementsEquivalent(this.resolve(), element);
        }

        @NotNull
        public Object[] getVariants() {
            final ArrayList labels = new ArrayList(1);
            this.processElements(new PsiElementProcessor<JSLabeledStatement>(){

                public boolean execute(@NotNull JSLabeledStatement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    labels.add(element.getLabel());
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSStatementWithLabelReferenceImpl$LabelReference$2", "execute"));
                }
            });
            Object[] objectArray = ArrayUtil.toStringArray(labels);
            if (objectArray == null) {
                LabelReference.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        protected void processElements(PsiElementProcessor<JSLabeledStatement> processor) {
            for (PsiElement run2 = JSStatementWithLabelReferenceImpl.this.getParent(); run2 != null; run2 = run2.getParent()) {
                if (run2 instanceof JSLabeledStatement && !processor.execute((PsiElement)((JSLabeledStatement)run2))) {
                    return;
                }
                if (run2 instanceof JSFunction) break;
            }
        }

        public boolean isSoft() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSStatementWithLabelReferenceImpl$LabelReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSStatementWithLabelReferenceImpl$LabelReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

