/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.macro.Macro;
import com.intellij.idea.RareLogger;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceInitialState;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceRequest;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLanguageServiceNodeStdProtocolBase
implements JSLanguageServiceProtocol {
    private static final Logger RARE_LOGGER = RareLogger.wrap((Logger)JSLanguageServiceQueue.LOGGER, (boolean)false);
    protected static final String ANSWER_READY = "ready";
    protected static final String ANSWER_ERROR = "error";
    @NotNull
    protected final Project myProject;
    @Nullable
    private volatile String myInitializeError;
    protected final long mySessionId;
    @NotNull
    private final Consumer<JsonObject> myInitialStateConsumer;
    private final AtomicInteger mySeq;
    @Nullable
    private OutputStream myProcessInput;
    protected final ConcurrentMap<Integer, JSLanguageServiceAnswerConsumer> myCallbacks;

    public JSLanguageServiceNodeStdProtocolBase(@NotNull Project project, @NotNull Consumer<?> readyConsumer) {
        if (project == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(0);
        }
        if (readyConsumer == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(1);
        }
        this.mySessionId = System.currentTimeMillis();
        this.mySeq = new AtomicInteger();
        this.myCallbacks = ContainerUtil.newConcurrentMap();
        this.myProject = project;
        this.myInitialStateConsumer = readyConsumer;
    }

    @Override
    @Nullable
    public final String getInitializeError() {
        return this.myInitializeError;
    }

    protected boolean waitingReadyNotification(@NotNull OSProcessHandler processHandler, @NotNull ThrowableRunnable<Exception> action, final @NotNull ReadyChecker checker) throws Exception {
        if (processHandler == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(2);
        }
        if (action == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(3);
        }
        if (checker == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(4);
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Ref result = new Ref((Object)false);
        ProcessAdapter listener2 = new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                checker.check(event, outputType, (Ref<Boolean>)result, countDownLatch);
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                countDownLatch.countDown();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processHandler.addProcessListener((ProcessListener)listener2);
        action.run();
        try {
            JSLanguageServiceQueue.LOGGER.debug("Start waiting for ready start");
            countDownLatch.await(30L, TimeUnit.SECONDS);
            JSLanguageServiceQueue.LOGGER.debug("End waiting for process starting. Result " + result.get());
        }
        catch (InterruptedException e) {
            JSLanguageServiceQueue.LOGGER.debug("Process interrupted while waiting ready state");
        }
        processHandler.removeProcessListener((ProcessListener)listener2);
        return (Boolean)result.get();
    }

    @NotNull
    protected final GeneralCommandLine createCommandLine() throws Macro.ExecutionCancelledException {
        String interpreter = this.getNodeInterpreter();
        if (StringUtil.isEmptyOrSpaces((String)interpreter)) {
            this.myInitializeError = JSBundle.message((String)"javascript.service.node.error", (Object[])new Object[0]);
            throw new RuntimeException(this.myInitializeError);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{interpreter});
        this.addNodeProcessAdditionalArguments(commandLine);
        File file = new File(this.getEntryPointFolder(), this.getEntryPointFile());
        if (!file.exists()) {
            throw new RuntimeException("Cannot find resource start point: " + file.getAbsolutePath());
        }
        commandLine.withWorkDirectory(this.getWorkingDirectory());
        commandLine.addParameter(file.getAbsolutePath());
        commandLine.addParameter(this.getSessionIdParam());
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.LOGGER.debug("Commandline " + commandLine.toString());
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(5);
        }
        return generalCommandLine;
    }

    protected String getWorkingDirectory() {
        return this.myProject.getBasePath();
    }

    @Nullable
    protected String getNodeInterpreter() {
        NodeJsInterpreter node = NodeJsInterpreterManager.getInstance(this.myProject).getDefault();
        if (node == null) {
            return null;
        }
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(node);
        if (localInterpreter == null || !localInterpreter.isValid()) {
            localInterpreter = NodeJsLocalInterpreterManager.getInstance().detectMostRelevant();
        }
        return localInterpreter == null ? null : localInterpreter.getInterpreterSystemDependentPath();
    }

    protected void addNodeProcessAdditionalArguments(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(6);
        }
    }

    @NotNull
    protected String getEntryPointFile() {
        if ("js-language-service.js" == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(7);
        }
        return "js-language-service.js";
    }

    protected final String getSessionIdParam() {
        return "-id=" + this.mySessionId;
    }

    protected File getEntryPointFolder() {
        return JSLanguageServiceUtil.getPluginStarterDirectory();
    }

    @Override
    public void cancelCommand(@Nullable Object cancellationToken) {
        if (cancellationToken == null) {
            return;
        }
        if (cancellationToken instanceof Collection) {
            ((Collection)cancellationToken).forEach(el -> {
                JSLanguageServiceAnswerConsumer cfr_ignored_0 = (JSLanguageServiceAnswerConsumer)this.myCallbacks.remove(el);
            });
        } else {
            this.myCallbacks.remove(cancellationToken);
        }
    }

    @NotNull
    protected final String toSystemCommand(String command) {
        String string = this.mySessionId + " " + command;
        if (string == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    protected OSProcessHandler createProcessHandler(GeneralCommandLine line) throws ExecutionException {
        OSProcessHandler oSProcessHandler = new OSProcessHandler(line){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                final BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
                BaseOutputReader.Options options2 = new BaseOutputReader.Options(){

                    public BaseDataReader.SleepingPolicy policy() {
                        return options.policy();
                    }

                    public boolean splitToLines() {
                        return options.splitToLines();
                    }

                    public boolean sendIncompleteLines() {
                        return false;
                    }

                    public boolean withSeparators() {
                        return true;
                    }
                };
                if (options2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return options2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$2", "readerOptions"));
            }
        };
        if (oSProcessHandler == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(9);
        }
        return oSProcessHandler;
    }

    @Override
    @NotNull
    public ProcessHandler connect() throws Exception {
        GeneralCommandLine line = this.createCommandLine();
        OSProcessHandler processHandler = this.createProcessHandler(line);
        JSLanguageServiceQueue.LOGGER.debug("Language service was started. Start initialization of the plugin");
        OSProcessHandler oSProcessHandler = processHandler;
        if (oSProcessHandler == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(10);
        }
        return oSProcessHandler;
    }

    @Override
    public boolean awaitReadyNotification(@NotNull ProcessHandler _processHandler) throws Exception {
        if (_processHandler == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(11);
        }
        OSProcessHandler processHandler = (OSProcessHandler)_processHandler;
        this.myProcessInput = processHandler.getProcessInput();
        try {
            if (!this.waitingReadyNotification(processHandler, (ThrowableRunnable<Exception>)((ThrowableRunnable)() -> ((OSProcessHandler)processHandler).startNotify()), this::checkReadyCommand)) {
                processHandler.destroyProcess();
                return false;
            }
            if (!this.waitingReadyNotification(processHandler, (ThrowableRunnable<Exception>)((ThrowableRunnable)this::sendInitialState), (event, outputType, result, countDownLatch) -> {
                block8: {
                    if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)event.getText())) {
                        String text = StringUtil.trim((String)event.getText());
                        if (text.startsWith("{") && text.endsWith("}")) {
                            JsonElement answer = new JsonParser().parse(text);
                            JsonObject answerAsJsonObject = answer.getAsJsonObject();
                            try {
                                JsonPrimitive success = answerAsJsonObject.getAsJsonPrimitive("success");
                                JsonPrimitive error = answerAsJsonObject.getAsJsonPrimitive(ANSWER_ERROR);
                                if (success.getAsBoolean()) {
                                    result.set((Object)true);
                                    countDownLatch.countDown();
                                    this.myInitialStateConsumer.consume((Object)answerAsJsonObject);
                                    break block8;
                                }
                                String errorText = StringUtil.notNullize((String)error.getAsString());
                                JsonPrimitive stack = answerAsJsonObject.getAsJsonPrimitive("stack");
                                JSLanguageServiceQueue.LOGGER.debug("Error initialization " + errorText + "\n" + (stack == null ? "" : stack.getAsString()));
                                this.myInitializeError = errorText;
                                countDownLatch.countDown();
                            }
                            catch (Exception e) {
                                JSLanguageServiceQueue.LOGGER.debug(this.getClass().getName() + " Error initialization " + e.getMessage());
                                this.myInitializeError = "Cannot parse service initialization answer " + text + "\n";
                            }
                        } else {
                            JSLanguageServiceQueue.LOGGER.warn(this.getClass().getName() + " Expected json answer: " + event.getText());
                        }
                    } else if (outputType == ProcessOutputTypes.STDERR) {
                        JSLanguageServiceQueue.LOGGER.debug(this.getClass().getName() + " Starting language service output error: " + event.getText());
                    }
                }
            })) {
                processHandler.destroyProcess();
                return false;
            }
        }
        catch (Exception e) {
            processHandler.destroyProcess();
            throw e;
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text;
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)(text = event.getText()))) {
                    text = StringUtil.trim((String)text);
                    JSLanguageServiceNodeStdProtocolBase.this.processText(text);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$3";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return true;
    }

    private void processText(String text) {
        if (text.startsWith("{") && text.endsWith("}")) {
            JSLanguageServiceAnswer answer = null;
            try {
                answer = new JSLanguageServiceAnswer(text);
            }
            catch (Exception e) {
                RARE_LOGGER.error("Cannot parse answer for protocol: " + this.getClass().getName() + ", text:\n " + JSLanguageServiceNodeStdProtocolBase.truncateText(text), (Throwable)e);
            }
            if (answer == null) {
                return;
            }
            this.processAnswer(answer, text);
        }
    }

    protected void processAnswer(@NotNull JSLanguageServiceAnswer answer, @NotNull String text) {
        Integer seq;
        if (answer == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(12);
        }
        if (text == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(13);
        }
        if ((seq = answer.getSeq()) != null) {
            JSLanguageServiceAnswerConsumer consumer = (JSLanguageServiceAnswerConsumer)this.myCallbacks.remove(seq);
            if (consumer != null) {
                if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                    JSLanguageServiceQueue.LOGGER.debug(this.getClass().getName() + " Pass request " + seq + " to consumer");
                }
                consumer.consume(answer);
            } else if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                JSLanguageServiceQueue.LOGGER.debug(this.getClass().getName() + " No callback for seq: " + text);
            }
        } else if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.LOGGER.debug(this.getClass().getName() + " No sequence number, skip request: " + text);
        }
    }

    private void sendInitialState() throws Exception {
        JSLanguageServiceInitialState initialState = (JSLanguageServiceInitialState)ReadAction.compute(() -> this.createState());
        String state = JSLanguageServiceQueue.GSON.toJson((Object)initialState);
        JSLanguageServiceQueue.LOGGER.debug(this.getClass().getName() + " Send state to service: " + state);
        this.write(state + "\n");
    }

    protected abstract JSLanguageServiceInitialState createState();

    @Override
    public Object sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, @Nullable JSLanguageServiceAnswerConsumer resultConsumer) throws Exception {
        if (command == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(14);
        }
        if (data == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(15);
        }
        int value = this.getUniqueCommandId();
        if (resultConsumer != null) {
            this.myCallbacks.put(value, resultConsumer);
        }
        String request = this.getWritableString(command, data, value);
        this.write(request);
        return value;
    }

    @NotNull
    protected String getWritableString(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, int value) {
        if (command == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(16);
        }
        if (data == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(17);
        }
        JSLanguageServiceRequest toSend = new JSLanguageServiceRequest(command, data, this.mySessionId, value);
        String jsonData = JSLanguageServiceQueue.GSON.toJson((Object)toSend);
        String request = jsonData + "\n";
        if (JSLanguageServiceQueue.LOGGER.isTraceEnabled()) {
            String toPrint = JSLanguageServiceNodeStdProtocolBase.truncateText(request);
            JSLanguageServiceQueue.LOGGER.trace(this.getClass().getName() + " Request: " + toPrint);
        }
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.LOGGER.debug(this.getClass().getName() + " Request command: " + command.getCommand());
        }
        String string = request;
        if (string == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String truncateText(String request) {
        String toPrint = request;
        if (Registry.is((String)"JavaScript.Language.Service.truncate.traced.messages", (boolean)true) && request.length() > 1000) {
            toPrint = request.substring(0, 200) + "\n ................................(truncated)";
        }
        String string = toPrint;
        if (string == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(19);
        }
        return string;
    }

    protected int getUniqueCommandId() {
        return this.mySeq.getAndIncrement();
    }

    protected final void checkReadyCommand(ProcessEvent event, Key outputType, Ref<Boolean> result, CountDownLatch countDownLatch) {
        if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)event.getText())) {
            String prefix;
            JSLanguageServiceQueue.LOGGER.debug("Starting language service output: " + event.getText());
            String text = event.getText().trim();
            if (this.toSystemCommand(ANSWER_READY).equals(text)) {
                result.set((Object)true);
                countDownLatch.countDown();
            }
            if (text.startsWith(prefix = this.toSystemCommand(ANSWER_ERROR))) {
                JSLanguageServiceQueue.LOGGER.debug("Error initialization " + text.substring(prefix.length()));
                this.myInitializeError = text.substring(prefix.length());
                countDownLatch.countDown();
            }
        } else if (outputType == ProcessOutputTypes.STDERR) {
            JSLanguageServiceQueue.LOGGER.debug("Starting language service output error: " + event.getText());
        }
    }

    protected void write(@NotNull String data) throws IOException {
        if (data == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(20);
        }
        if (this.myProcessInput != null) {
            this.myProcessInput.write(data.getBytes(CharsetToolkit.UTF8_CHARSET));
            this.myProcessInput.flush();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readyConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_processHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryPointFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemCommand";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getWritableString";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "waitingReadyNotification";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addNodeProcessAdditionalArguments";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "awaitReadyNotification";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processAnswer";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sendCommand";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getWritableString";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface ReadyChecker {
        public void check(@NotNull ProcessEvent var1, @NotNull Key var2, @NotNull Ref<Boolean> var3, @NotNull CountDownLatch var4);
    }
}

