/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.inspections.JSDuplicatedDeclarationInspection;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSConditionalCompileVariableReference;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesCheckUtil {
    private DuplicatesCheckUtil() {
    }

    public static void checkDuplicates(@NotNull JSNamedElement node, @NotNull JSAnnotatorProblemReporter reporter) {
        if (node == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(0);
        }
        if (reporter == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(1);
        }
        String name = node.getName();
        PsiElement nameIdentifier = node.getNameIdentifier();
        if (name == null || nameIdentifier == null) {
            return;
        }
        DuplicatesCheckUtil.checkForDuplicateDeclaration(name, (PsiElement)node, nameIdentifier, reporter);
    }

    public static void checkDuplicatesForVariable(@NotNull JSVariable var, @NotNull JSAnnotatorProblemReporter reporter) {
        PsiElement nameIdentifier;
        if (var == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(2);
        }
        if (reporter == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(3);
        }
        if ((nameIdentifier = var.getNameIdentifier()) == null) {
            return;
        }
        PsiElement next = nameIdentifier.getNextSibling();
        String name = nameIdentifier.getText();
        if (next == null || next.getNode().getElementType() instanceof JSElementType || next instanceof PsiWhiteSpace) {
            DuplicatesCheckUtil.checkForDuplicateDeclaration(name, (PsiElement)var, nameIdentifier, reporter);
        }
    }

    private static void checkForDuplicateDeclaration(@NotNull String name, @NotNull PsiElement decl, @NotNull PsiElement nameIdentifier, @NotNull JSAnnotatorProblemReporter reporter) {
        PsiElement scope;
        if (name == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(4);
        }
        if (decl == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(5);
        }
        if (nameIdentifier == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(6);
        }
        if (reporter == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(7);
        }
        if (DialectDetector.isTypeScript(decl)) {
            return;
        }
        if (decl instanceof JSFunctionExpression) {
            return;
        }
        BlockContext blockContext = BlockContext.createBlockContext(decl);
        if (blockContext != null && blockContext.myIsEmpty) {
            return;
        }
        PsiElement psiElement = scope = blockContext != null ? blockContext.myBlock : PsiTreeUtil.getParentOfType((PsiElement)decl, (Class[])new Class[]{JSExecutionScope.class, JSClass.class, JSObjectLiteralExpression.class, JSPackageStatement.class, PsiFile.class, TypeScriptType.class});
        if (scope instanceof JSPackageStatement) {
            return;
        }
        if (scope instanceof JSFile && scope.getContext() != null) {
            scope = scope.getContext().getContainingFile();
        }
        PsiElement place = scope instanceof JSClass ? scope : decl;
        MySinkResolveProcessor processor = new MySinkResolveProcessor(name, place, scope, decl);
        processor.setSkipImplicitDeclarations(true);
        PsiElement parent = JSResolveUtil.findParent(decl);
        if (parent instanceof JSClass) {
            processor.configureClassScope((JSClass)parent);
        }
        PsiElement startFrom = blockContext != null ? blockContext.myLastStatement : decl;
        PsiElement lastParent = null;
        JSClass clazzOfContext = null;
        if (decl instanceof JSFunction || decl instanceof JSVariable && blockContext == null || decl instanceof JSNamespaceDeclaration) {
            processor.getAccessibilityProcessingHandler().setProcessStatics(JSPsiImplUtils.hasModifier((JSAttributeListOwner)decl, JSAttributeList.ModifierType.STATIC));
            if (!(parent instanceof XmlBackedJSClass)) {
                if (parent instanceof JSClass) {
                    lastParent = parent;
                } else if (parent != null) {
                    lastParent = parent.getFirstChild();
                }
                startFrom = parent;
            }
            if ((clazzOfContext = DuplicatesCheckUtil.getClassForHierarchyCheck(decl)) != null) {
                if (parent != clazzOfContext) {
                    processor.configureClassScope(clazzOfContext);
                }
                processor.setToProcessHierarchy(true);
            }
        }
        processor.setLocalResolve(true);
        JSResolveUtil.treeWalkUp(processor, startFrom, lastParent, startFrom, scope);
        PsiElement result = processor.getResult();
        if (result != null && result != scope && result.isValid()) {
            PsiElement resultParent = JSResolveUtil.findParent(result);
            if (resultParent instanceof JSQualifiedNamedElement && "Object".equals(((JSQualifiedNamedElement)resultParent).getQualifiedName())) {
                return;
            }
            if (DialectDetector.isActionScript(decl) && clazzOfContext != null && scope != null && DuplicatesCheckUtil.actionScriptCheck(name, decl, nameIdentifier, reporter, scope, result, resultParent)) {
                return;
            }
            if (!DuplicatesCheckUtil.checkVariableScopes(decl, result)) {
                return;
            }
            ProblemHighlightType highlightType = DuplicatesCheckUtil.getHighlightTypeWhenDuplicateFound(result, decl);
            if (!DialectDetector.isActionScript(decl) && result instanceof JSParameter) {
                reporter.registerProblem(result, JSBundle.message((String)"javascript.validation.message.duplicate.declaration", (Object[])new Object[0]), highlightType, JSDuplicatedDeclarationInspection.SHORT_NAME, new LocalQuickFix[0]);
            }
            reporter.registerProblem(nameIdentifier, JSBundle.message((String)"javascript.validation.message.duplicate.declaration", (Object[])new Object[0]), highlightType, JSDuplicatedDeclarationInspection.SHORT_NAME, new LocalQuickFix[0]);
        }
    }

    private static JSClass getClassForHierarchyCheck(@NotNull PsiElement decl) {
        if (decl == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(8);
        }
        if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)decl, JSAttributeList.ModifierType.OVERRIDE)) {
            return null;
        }
        if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)decl, JSAttributeList.ModifierType.STATIC)) {
            return null;
        }
        if (JSClassUtils.isES6ClassImplementation(decl)) {
            return null;
        }
        return JSResolveUtil.getClassOfContext(decl);
    }

    private static boolean actionScriptCheck(@NotNull String name, @NotNull PsiElement decl, @NotNull PsiElement nameIdentifier, @NotNull JSAnnotatorProblemReporter reporter, @NotNull PsiElement scope, PsiElement result, PsiElement resultParent) {
        boolean problemWithinScope;
        if (name == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(9);
        }
        if (decl == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(10);
        }
        if (nameIdentifier == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(11);
        }
        if (reporter == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(13);
        }
        boolean bl = problemWithinScope = scope instanceof XmlFile && resultParent == JSResolveUtil.findParent(decl) || PsiTreeUtil.findCommonParent((PsiElement)result, (PsiElement)scope.getFirstChild()) == scope;
        if (!problemWithinScope) {
            String namespace = DuplicatesCheckUtil.getActionScriptNamespace(result);
            if (decl instanceof JSFunction && result instanceof JSFunction && DuplicatesCheckUtil.getActionScriptNamespace(decl).equals(DuplicatesCheckUtil.getActionScriptNamespace(result))) {
                return true;
            }
            if (resultParent instanceof JSClass) {
                String qualifiedName = ((JSClass)resultParent).getQualifiedName();
                String message = JSBundle.message((String)"javascript.validation.message.conflicting.definition.was.found.with.the.same.name", (Object[])new Object[]{qualifiedName + "." + name, namespace});
                reporter.registerProblem(nameIdentifier, message, DuplicatesCheckUtil.getHighlightTypeWhenDuplicateFound(result, decl), JSDuplicatedDeclarationInspection.SHORT_NAME, new LocalQuickFix[0]);
                return true;
            }
        }
        return false;
    }

    private static boolean isInLetScope(@NotNull JSVariable let, @NotNull PsiElement element) {
        JSFunction function;
        if (let == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(14);
        }
        if (element == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(15);
        }
        if (let instanceof JSParameter) {
            return true;
        }
        if (element instanceof JSParameter && (function = ((JSParameter)element).getDeclaringFunction()) != null) {
            return PsiTreeUtil.isAncestor((PsiElement)element.getParent().getParent(), (PsiElement)let, (boolean)true);
        }
        element = element instanceof JSVariable ? element.getParent() : element;
        boolean elementIsLet = element instanceof JSVariable && ((JSVariable)element).hasBlockScope();
        JSVarStatement parent = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)let, JSVarStatement.class);
        if (parent != null) {
            PsiElement grand = parent.getParent();
            PsiElement[] children = grand.getChildren();
            boolean found = false;
            for (PsiElement child : children) {
                if (elementIsLet ? child == element : PsiTreeUtil.isAncestor((PsiElement)child, (PsiElement)element, (boolean)false)) {
                    return true;
                }
                if (found || child != parent) continue;
                found = true;
            }
        }
        return false;
    }

    private static boolean checkVariableScopes(PsiElement decl, PsiElement result) {
        boolean declIsLet;
        boolean resultIsLet = result instanceof JSVariable && ((JSVariable)result).hasBlockScope();
        boolean bl = declIsLet = decl instanceof JSVariable && ((JSVariable)decl).hasBlockScope();
        if (!declIsLet && !resultIsLet) {
            return true;
        }
        BlockContext declContext = BlockContext.createBlockContext(decl);
        BlockContext elementContext = BlockContext.createBlockContext(result);
        if (declIsLet && resultIsLet && declContext != null && elementContext != null) {
            return !declContext.myIsEmpty && !elementContext.myIsEmpty && declContext.myBlock == elementContext.myBlock;
        }
        if (resultIsLet && DuplicatesCheckUtil.isInLetScope((JSVariable)result, decl)) {
            return true;
        }
        return declIsLet && DuplicatesCheckUtil.isInLetScope((JSVariable)decl, result);
    }

    @NotNull
    private static String getActionScriptNamespace(PsiElement result) {
        JSAttributeList attributeList;
        String namespace = "internal";
        if (result instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)result).getAttributeList()) != null) {
            String ns;
            JSAttributeList.AccessType accessType = attributeList.getAccessType();
            if (accessType == JSAttributeList.AccessType.PUBLIC) {
                namespace = "public";
            } else if (accessType == JSAttributeList.AccessType.PROTECTED || accessType == JSAttributeList.AccessType.PRIVATE) {
                namespace = "protected";
            } else if (accessType == JSAttributeList.AccessType.PACKAGE_LOCAL && (ns = JSResolveUtil.getNamespaceValue(attributeList)) != null) {
                namespace = ns;
            }
        }
        String string = namespace;
        if (string == null) {
            DuplicatesCheckUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static ProblemHighlightType getHighlightTypeWhenDuplicateFound(PsiElement result, PsiElement decl) {
        boolean unconditionalError;
        boolean bl = unconditionalError = decl.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        if (unconditionalError) {
            PsiElement declParent = JSResolveUtil.findParent(decl);
            PsiElement resultParent = JSResolveUtil.findParent(result);
            if (result instanceof JSParameter && !(decl instanceof JSParameter) || decl instanceof JSVariable && !(decl instanceof JSParameter) && result instanceof JSVariable && DuplicatesCheckUtil.isLocalVar(declParent) && DuplicatesCheckUtil.isLocalVar(resultParent)) {
                unconditionalError = false;
            }
        } else if ((result instanceof JSParameter && decl instanceof JSParameter || result instanceof JSProperty && decl instanceof JSProperty) && JSResolveUtil.isEcmaScript5(decl)) {
            unconditionalError = true;
        }
        return unconditionalError ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    private static boolean isLocalVar(PsiElement declParent) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)declParent, (Class[])new Class[]{JSFunction.class}) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "let";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/DuplicatesCheckUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/DuplicatesCheckUtil";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionScriptNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicates";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicatesForVariable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkForDuplicateDeclaration";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getClassForHierarchyCheck";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "actionScriptCheck";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isInLetScope";
                break;
            }
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySinkResolveProcessor
    extends SinkResolveProcessor<ResolveResultSink> {
        private final PsiElement myDecl;

        public MySinkResolveProcessor(String name, PsiElement place, PsiElement scope, PsiElement decl) {
            super(name, place, new ResolveResultSink(scope, name){

                @Override
                public void addCandidateResult(PsiElement element, boolean isCompleteMatch, @Nullable String problemKey) {
                }
            });
            this.myDecl = decl;
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                MySinkResolveProcessor.$$$reportNull$$$0(0);
            }
            if (state == null) {
                MySinkResolveProcessor.$$$reportNull$$$0(1);
            }
            if (element == this.myDecl) {
                return true;
            }
            if (this.myDecl instanceof JSParameter && this.myDecl.getParent() != element.getParent()) {
                return false;
            }
            if (element instanceof JSFunction && this.myDecl instanceof JSFunction) {
                JSFunction declFunction = (JSFunction)this.myDecl;
                JSFunction elementFunction = (JSFunction)element;
                if (declFunction.isGetProperty() && elementFunction.isSetProperty() || declFunction.isSetProperty() && elementFunction.isGetProperty()) {
                    return true;
                }
            } else if (element instanceof JSProperty && this.myDecl instanceof JSProperty) {
                JSProperty elementProperty = (JSProperty)element;
                JSProperty declProperty = (JSProperty)this.myDecl;
                if (declProperty.isGetProperty() && elementProperty.isSetProperty() || declProperty.isSetProperty() && elementProperty.isGetProperty()) {
                    return true;
                }
            }
            if (element instanceof JSFunction && this.myDecl instanceof JSClass && element.getParent() == this.myDecl) {
                return true;
            }
            if (MySinkResolveProcessor.isScopeNamedElement(element) && MySinkResolveProcessor.isScopeNamedElement(this.myDecl)) {
                boolean notStatic;
                JSAttributeList attrList2;
                JSAttributeList attrList = element instanceof JSAttributeListOwner ? ((JSAttributeListOwner)element).getAttributeList() : null;
                JSAttributeList jSAttributeList = attrList2 = this.myDecl instanceof JSAttributeListOwner ? ((JSAttributeListOwner)this.myDecl).getAttributeList() : null;
                if (attrList != null && attrList2 != null) {
                    String ns = JSResolveUtil.getNamespaceValue(attrList);
                    String ns2 = JSResolveUtil.getNamespaceValue(attrList2);
                    if (ns != null && !ns.equals(ns2) || ns2 != null && !ns2.equals(ns)) {
                        return true;
                    }
                    JSConditionalCompileVariableReference conditionalCompileVar = attrList.getConditionalCompileVariableReference();
                    JSConditionalCompileVariableReference conditionalCompileVar2 = attrList2.getConditionalCompileVariableReference();
                    if (conditionalCompileVar != null && conditionalCompileVar2 != null) {
                        JSReferenceExpression expression = conditionalCompileVar.getExpression();
                        JSReferenceExpression expression2 = conditionalCompileVar2.getExpression();
                        if (expression != null && expression2 != null && !expression.getText().equals(expression2.getText())) {
                            return true;
                        }
                    }
                } else if (attrList != null && attrList.getNamespace() != null || attrList2 != null && attrList2.getNamespace() != null) {
                    return true;
                }
                boolean notStatic2 = attrList2 == null || !attrList2.hasModifier(JSAttributeList.ModifierType.STATIC);
                boolean bl = notStatic = attrList == null || !attrList.hasModifier(JSAttributeList.ModifierType.STATIC);
                if (notStatic2 && !notStatic || notStatic && !notStatic2) {
                    return true;
                }
            }
            if (element instanceof ImplicitJSVariableImpl || element instanceof JSImplicitElement) {
                return true;
            }
            if (element instanceof JSDefinitionExpression) {
                return true;
            }
            return super.execute(element, state);
        }

        private static boolean isScopeNamedElement(@NotNull PsiElement element) {
            if (element == null) {
                MySinkResolveProcessor.$$$reportNull$$$0(2);
            }
            return element instanceof JSAttributeListOwner || element instanceof ES6ImportSpecifierAlias || element instanceof ES6ImportedBinding;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/validation/DuplicatesCheckUtil$MySinkResolveProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isScopeNamedElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BlockContext {
        private static final BlockContext EMPTY = new BlockContext(true, null, null);
        private final boolean myIsEmpty;
        private final PsiElement myBlock;
        private final PsiElement myLastStatement;

        private BlockContext(boolean empty, PsiElement block, PsiElement lastStatement) {
            this.myIsEmpty = empty;
            this.myBlock = block;
            this.myLastStatement = lastStatement;
        }

        @Nullable
        public static BlockContext createBlockContext(@NotNull PsiElement decl) {
            if (decl == null) {
                BlockContext.$$$reportNull$$$0(0);
            }
            if (!(decl instanceof JSVariable) || !((JSVariable)decl).hasBlockScope() || decl instanceof JSParameter) {
                return null;
            }
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)decl, JSVarStatement.class);
            if (parent != null) {
                BlockContext prev;
                PsiElement switchStatement;
                BlockContext prev2;
                PsiElement grand = parent.getParent();
                if (grand instanceof JSCaseClause && grand.getParent() instanceof JSSwitchStatement && (prev2 = BlockContext.createBlockContextForBlockHolder(switchStatement = grand.getParent())) != null) {
                    return prev2;
                }
                if (grand instanceof JSBlockStatement && grand.getParent() instanceof JSFunction && (prev = BlockContext.createBlockContextForBlockHolder(grand.getParent())) != null) {
                    return prev;
                }
                if ((grand instanceof JSBlockStatement || grand instanceof PsiFile) && (prev = BlockContext.createBlockContextForBlockHolder(grand)) != null) {
                    return prev;
                }
            }
            return EMPTY;
        }

        @Nullable
        private static BlockContext createBlockContextForBlockHolder(PsiElement grand) {
            JSElement last;
            JSElement prev = last = BlockContext.getLastChild(grand);
            while (last != null) {
                prev = last;
                last = BlockContext.getLastChild((PsiElement)last);
            }
            if (prev != null) {
                return new BlockContext(false, grand, (PsiElement)prev);
            }
            return null;
        }

        @Nullable
        private static JSElement getLastChild(PsiElement grand) {
            JSElement last = null;
            for (JSElement next : SyntaxTraverser.psiTraverser().children((Object)grand).filter(JSElement.class)) {
                if (!(next instanceof JSCaseClause) && !(next instanceof JSSourceElement)) continue;
                last = next;
            }
            return last;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decl", "com/intellij/lang/javascript/validation/DuplicatesCheckUtil$BlockContext", "createBlockContext"));
        }
    }
}

