/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ognl.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.ognl.OgnlTypes;
import com.intellij.lang.ognl.psi.OgnlExpression;
import com.intellij.lang.ognl.psi.OgnlFqnTypeExpression;
import com.intellij.lang.ognl.psi.OgnlReferenceExpression;
import com.intellij.lang.ognl.psi.OgnlTokenGroups;
import com.intellij.lang.ognl.psi.OgnlVariableAssignmentExpression;
import com.intellij.lang.ognl.psi.OgnlVariableExpression;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class OgnlKeywordCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final PsiElementPattern.Capture<PsiElement> FQN_TYPE_EXPRESSION = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(OgnlFqnTypeExpression.class);
    private static final PsiElementPattern.Capture<PsiElement> VARIABLE_EXPRESSION = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(OgnlVariableExpression.class);
    private static final PsiElementPattern.Capture<PsiElement> VARIABLE_ASSIGNMENT_EXPRESSION = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(OgnlVariableAssignmentExpression.class);
    private static final PsiElementPattern.Capture<PsiElement> AFTER_OPERATIONS = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(OgnlTokenGroups.OPERATIONS));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_NEW = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(OgnlTypes.NEW_KEYWORD));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_QUESTION = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(OgnlTypes.QUESTION));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_COLON = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(OgnlTypes.COLON));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_EXPRESSION = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().inside(OgnlExpression.class))).andNot(AFTER_OPERATIONS)).andNot(AFTER_QUESTION)).andNot(AFTER_COLON)).andNot(AFTER_NEW)).andNot(VARIABLE_EXPRESSION)).andNot(VARIABLE_ASSIGNMENT_EXPRESSION)).andNot(FQN_TYPE_EXPRESSION);
    private static final PsiElementPattern.Capture<PsiElement> AFTER_IDENTIFIER = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().inside(OgnlReferenceExpression.class));

    public OgnlKeywordCompletionContributor() {
        this.installBinaryOperations();
        this.installSequence();
        this.installIdentifier();
        this.installBooleanNull();
        this.installNew();
    }

    private void installBinaryOperations() {
        this.extendKeywordCompletion(AFTER_EXPRESSION, "shl", "shr", "ushr", "and", "band", "or", "bor", "xor", "eq", "neq", "lt", "lte", "gt", "gte");
    }

    private void installSequence() {
        this.extendKeywordCompletion(AFTER_EXPRESSION, "not in", "in");
    }

    private void installIdentifier() {
        this.extendKeywordCompletion(AFTER_IDENTIFIER, "instanceof");
    }

    private void installBooleanNull() {
        TokenSet precedingOperators = TokenSet.create((IElementType[])new IElementType[]{OgnlTypes.EQUAL, OgnlTypes.EQ_KEYWORD, OgnlTypes.NOT_EQUAL, OgnlTypes.NEQ_KEYWORD, OgnlTypes.QUESTION, OgnlTypes.COLON, OgnlTypes.AND_KEYWORD, OgnlTypes.AND_AND, OgnlTypes.OR_KEYWORD, OgnlTypes.OR_OR, OgnlTypes.NEGATE, OgnlTypes.NOT_KEYWORD, OgnlTypes.EQ});
        this.extendKeywordCompletion((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(OgnlExpression.class)).withElementType(precedingOperators))), "false", "true", "null");
    }

    private void installNew() {
        this.extendKeywordCompletion((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().atStartOf((ElementPattern)PlatformPatterns.psiElement(OgnlExpression.class))).andNot(AFTER_OPERATIONS)).andNot(AFTER_NEW)), "new");
    }

    private void extendKeywordCompletion(PsiElementPattern.Capture<PsiElement> pattern, final String ... keywords) {
        this.extend(CompletionType.BASIC, (ElementPattern)pattern, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters completionParameters, ProcessingContext processingContext, @NotNull CompletionResultSet completionResultSet) {
                if (completionParameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (completionResultSet == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (String keyword : keywords) {
                    LookupElementBuilder builder = LookupElementBuilder.create((String)keyword).bold();
                    completionResultSet.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)builder, (TailType)TailType.SPACE));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "completionParameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "completionResultSet";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/ognl/completion/OgnlKeywordCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

