/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.SuspendContext;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.caches.resolve.JavaResolutionUtils;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u001c\u0010\u0015\u001a\u00020\u0010*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d\u001a\f\u0010\u001e\u001a\u00020\u001f*\u00020 H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u0014\u0010\n\u001a\u00020\u0003X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0005\"\u0014\u0010\f\u001a\u00020\u0003X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0005\"\u000e\u0010\u000e\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"DEBUG_MODE", "", "GENERATED_FUNCTION_NAME", "", "getGENERATED_FUNCTION_NAME", "()Ljava/lang/String;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "RECEIVER_NAME", "getRECEIVER_NAME", "THIS_NAME", "getTHIS_NAME", "template", "createFileForDebugger", "Lorg/jetbrains/kotlin/psi/KtFile;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "extractedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "createKtFile", "Lcom/intellij/psi/PsiElement;", "fileName", "fileText", "getClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/org/objectweb/asm/Type;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getInvokePolicy", "", "Lcom/intellij/debugger/engine/SuspendContext;", "idea"})
public final class KotlinEvaluationBuilderKt {
    @NotNull
    private static final String RECEIVER_NAME = "$receiver";
    @NotNull
    private static final String THIS_NAME = "this";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String GENERATED_FUNCTION_NAME = "generated_for_debugger_kotlin_rulezzzz";
    private static final boolean DEBUG_MODE = false;
    private static final String template = "\n!PACKAGE!\n\n!IMPORT_LIST!\n\n!FUNCTION!\n";

    @NotNull
    public static final String getRECEIVER_NAME() {
        return RECEIVER_NAME;
    }

    @NotNull
    public static final String getTHIS_NAME() {
        return THIS_NAME;
    }

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    @NotNull
    public static final String getGENERATED_FUNCTION_NAME() {
        return GENERATED_FUNCTION_NAME;
    }

    private static final KtFile createFileForDebugger(KtCodeFragment codeFragment, KtNamedFunction extractedFunction) {
        KtFile jetFile;
        block7: {
            Object $i$a$1$let;
            Object it;
            Object object;
            Object it2;
            KtFile containingContextFile = codeFragment.getContextContainingFile();
            Object object2 = containingContextFile;
            if (object2 == null || (object2 = ((KtFile)object2).getImportList()) == null || (object2 = (it2 = (object = object2)).getText() + "\n") == null) {
                object2 = "";
            }
            Object importsFromContextFile = object2;
            String fileText = StringsKt.replace$default((String)template, (String)"!IMPORT_LIST!", (String)((String)importsFromContextFile + CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)codeFragment.importsToString(), (String[])new String[]{KtCodeFragment.Companion.getIMPORT_SEPARATOR()}, (boolean)false, (int)0, (int)6, null), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)), (boolean)false, (int)4, null);
            Object object3 = containingContextFile;
            if (object3 == null || (object3 = ((KtFile)object3).getPackageFqName()) == null || (object3 = !((FqName)(it = ($i$a$1$let = object3))).isRoot() ? "package " + UtilsKt.quoteSegmentsIfNeeded((FqName)it) : "") == null) {
                object3 = "";
            }
            Object packageFromContextFile = object3;
            fileText = StringsKt.replace$default((String)fileText, (String)"!PACKAGE!", (String)packageFromContextFile, (boolean)false, (int)4, null);
            String extractedFunctionText = extractedFunction.getText();
            boolean bl = it = extractedFunctionText != null;
            if (_Assertions.ENABLED && !it) {
                String string = "Text of extracted function shouldn't be null";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            String string = extractedFunction.getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            fileText = StringsKt.replace$default((String)fileText, (String)"!FUNCTION!", (String)string, (boolean)false, (int)4, null);
            jetFile = KotlinEvaluationBuilderKt.createKtFile((PsiElement)codeFragment, "debugFile.kt", fileText);
            CodeFragmentUtilKt.setSuppressDiagnosticsInDebugMode(jetFile, true);
            List<KtDeclaration> list2 = jetFile.getDeclarations();
            KtDeclaration ktDeclaration = list2.get(0);
            if (ktDeclaration == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            }
            KtNamedFunction function2 = (KtNamedFunction)ktDeclaration;
            KtTypeReference ktTypeReference = function2.getReceiverTypeReference();
            if (ktTypeReference != null) {
                KtTypeReference ktTypeReference2 = extractedFunction.getReceiverTypeReference();
                CodeFragmentUtilKt.setDebugTypeInfo(ktTypeReference, ktTypeReference2 != null ? CodeFragmentUtilKt.getDebugTypeInfo(ktTypeReference2) : null);
            }
            List<KtParameter> list3 = function2.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"function.valueParameters");
            Iterable iterable = list3;
            List<KtParameter> list4 = extractedFunction.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"extractedFunction.valueParameters");
            for (Pair pair2 : CollectionsKt.zip((Iterable)iterable, (Iterable)list4)) {
                KtParameter newParam = (KtParameter)pair2.component1();
                KtParameter oldParam = (KtParameter)pair2.component2();
                KtParameter ktParameter = newParam;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"newParam");
                KtTypeReference ktTypeReference3 = ktParameter.getTypeReference();
                if (ktTypeReference3 == null) continue;
                KtParameter ktParameter2 = oldParam;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter2, (String)"oldParam");
                KtTypeReference ktTypeReference4 = ktParameter2.getTypeReference();
                CodeFragmentUtilKt.setDebugTypeInfo(ktTypeReference3, ktTypeReference4 != null ? CodeFragmentUtilKt.getDebugTypeInfo(ktTypeReference4) : null);
            }
            KtTypeReference ktTypeReference5 = function2.getTypeReference();
            if (ktTypeReference5 == null) break block7;
            KtTypeReference ktTypeReference6 = extractedFunction.getTypeReference();
            CodeFragmentUtilKt.setDebugTypeInfo(ktTypeReference5, ktTypeReference6 != null ? CodeFragmentUtilKt.getDebugTypeInfo(ktTypeReference6) : null);
        }
        return jetFile;
    }

    private static final KtFile createKtFile(@NotNull PsiElement $receiver, String fileName, String fileText) {
        LightVirtualFile virtualFile2 = new LightVirtualFile(fileName, (Language)KotlinLanguage.INSTANCE, (CharSequence)fileText);
        virtualFile2.setCharset(CharsetToolkit.UTF8_CHARSET);
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)$receiver.getProject());
        if (psiFileFactory == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.PsiFileFactoryImpl");
        }
        PsiFile psiFile = ((PsiFileFactoryImpl)psiFileFactory).trySetupPsiForFile(virtualFile2, (Language)KotlinLanguage.INSTANCE, true, false);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile jetFile = (KtFile)psiFile;
        KtPsiFactoryKt.setAnalysisContext(jetFile, $receiver);
        return jetFile;
    }

    public static final int getInvokePolicy(@NotNull SuspendContext $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)RECEIVER_NAME);
        return $receiver.getSuspendPolicy() == 1 ? 1 : 0;
    }

    @Nullable
    public static final ClassDescriptor getClassDescriptor(@NotNull Type $receiver, @NotNull GlobalSearchScope scope2) {
        FqName jvmName;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)RECEIVER_NAME);
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        if (AsmUtil.isPrimitive($receiver)) {
            return null;
        }
        JvmClassName jvmClassName = JvmClassName.byInternalName($receiver.getInternalName());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(internalName)");
        FqName fqName2 = jvmName = jvmClassName.getFqNameForClassNameWithoutDollars();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"jvmName");
        Object object = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
        if (object != null) {
            ClassId p1;
            Object object2 = object;
            ModuleDescriptorImpl moduleDescriptorImpl = DefaultBuiltIns.Companion.getInstance().getBuiltInsModule();
            object = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptorImpl, p1 = object2);
            if (object != null) {
                Object it = object2 = object;
                return it;
            }
        }
        return (ClassDescriptor)ApplicationUtilsKt.runReadAction((Function0)new Function0<ClassDescriptor>(scope2, jvmName){
            final /* synthetic */ GlobalSearchScope $scope;
            final /* synthetic */ FqName $jvmName;

            @Nullable
            public final ClassDescriptor invoke() {
                ClassDescriptor classDescriptor;
                PsiClass[] classes2 = JavaPsiFacade.getInstance((Project)this.$scope.getProject()).findClasses(this.$jvmName.asString(), this.$scope);
                Intrinsics.checkExpressionValueIsNotNull((Object)classes2, (String)"classes");
                Object[] objectArray = classes2;
                if (objectArray.length == 0) {
                    classDescriptor = null;
                } else {
                    Object object = ArraysKt.first((Object[])classes2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"classes.first()");
                    classDescriptor = JavaResolutionUtils.getJavaClassDescriptor$default((PsiClass)object, null, 1, null);
                }
                return classDescriptor;
            }
            {
                this.$scope = globalSearchScope;
                this.$jvmName = fqName2;
                super(0);
            }
        });
    }

    static {
        RECEIVER_NAME = RECEIVER_NAME;
        THIS_NAME = THIS_NAME;
        LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator");
        GENERATED_FUNCTION_NAME = GENERATED_FUNCTION_NAME;
        template = template;
    }

    public static final /* synthetic */ boolean access$getDEBUG_MODE$p() {
        return DEBUG_MODE;
    }

    @NotNull
    public static final /* synthetic */ KtFile access$createFileForDebugger(@NotNull KtCodeFragment codeFragment, @NotNull KtNamedFunction extractedFunction) {
        return KotlinEvaluationBuilderKt.createFileForDebugger(codeFragment, extractedFunction);
    }
}

