/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.idea.quickfix.RemoveUnusedFunctionParameterFix;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SafeDeleteFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)V", "name", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "startInWriteAction", "", "idea"})
public final class SafeDeleteFix
implements LocalQuickFix {
    private final String name;

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getFamilyName() {
        return "Safe delete";
    }

    public boolean startInWriteAction() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"descriptor.psiElement");
        PsiElement $receiver$iv = psiElement2;
        KtDeclaration ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDeclaration.class, (boolean)true);
        if (ktDeclaration == null) return;
        KtDeclaration declaration2 = ktDeclaration;
        if (!FileModificationService.getInstance().prepareFileForWrite(declaration2.getContainingFile())) {
            return;
        }
        if (declaration2 instanceof KtParameter && ((KtParameter)declaration2).getParent() instanceof KtParameterList) {
            PsiElement psiElement3 = ((KtParameter)declaration2).getParent();
            if ((psiElement3 != null ? psiElement3.getParent() : null) instanceof KtFunction) {
                RemoveUnusedFunctionParameterFix removeUnusedFunctionParameterFix = new RemoveUnusedFunctionParameterFix((KtParameter)declaration2);
                Editor editor = IntentionBasedInspectionKt.findExistingEditor(declaration2);
                KtFile ktFile = ((KtParameter)declaration2).getContainingKtFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"declaration.containingKtFile");
                removeUnusedFunctionParameterFix.invoke(project, editor, (PsiFile)ktFile);
                return;
            }
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(project, declaration2){
            final /* synthetic */ Project $project;
            final /* synthetic */ KtDeclaration $declaration;

            public final void run() {
                SafeDeleteHandler.invoke((Project)this.$project, (PsiElement[])new KtDeclaration[]{this.$declaration}, (boolean)false);
            }
            {
                this.$project = project;
                this.$declaration = ktDeclaration;
            }
        }, ModalityState.NON_MODAL);
    }

    public SafeDeleteFix(@NotNull KtDeclaration declaration2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        if (declaration2 instanceof KtConstructor) {
            string = "Safe delete constructor";
        } else {
            String string2 = QuickFixBundle.message((String)"safe.delete.text", (Object[])new Object[]{declaration2.getName()});
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"QuickFixBundle.message(\"\u2026.text\", declaration.name)");
        }
        this.name = string;
    }
}

