/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0002H\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "(Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getModifier", "()Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAnnotationClassPrimaryConstructor", "", "noModifierYetApplicabilityRange", "declaration", "toVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Internal", "Private", "Protected", "Public", "idea"})
public class ChangeVisibilityModifierIntention
extends SelfTargetingRangeIntention<KtDeclaration> {
    @NotNull
    private final KtModifierKeywordToken modifier;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtDeclaration element3) {
        KtModifierList modifierList;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtModifierList ktModifierList = modifierList = element3.getModifierList();
        if (ktModifierList != null ? ktModifierList.hasModifier(this.modifier) : false) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor(element3);
        if (!(declarationDescriptor instanceof DeclarationDescriptorWithVisibility)) {
            declarationDescriptor = null;
        }
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = (DeclarationDescriptorWithVisibility)declarationDescriptor;
        if (declarationDescriptorWithVisibility == null) {
            return null;
        }
        DeclarationDescriptorWithVisibility descriptor2 = declarationDescriptorWithVisibility;
        Visibility targetVisibility = this.toVisibility(this.modifier);
        if (Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)targetVisibility)) {
            return null;
        }
        KtModifierList ktModifierList2 = modifierList;
        if (ktModifierList2 != null ? ktModifierList2.hasModifier(KtTokens.OVERRIDE_KEYWORD) : false) {
            boolean bl;
            block14: {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility2 = descriptor2;
                if (!(declarationDescriptorWithVisibility2 instanceof CallableDescriptor)) {
                    declarationDescriptorWithVisibility2 = null;
                }
                CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptorWithVisibility2;
                if (callableDescriptor == null) {
                    return null;
                }
                CallableDescriptor callableDescriptor2 = callableDescriptor;
                Collection<? extends CallableDescriptor> collection = callableDescriptor2.getOverriddenDescriptors();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"callableDescriptor.overriddenDescriptors");
                Iterable iterable = collection;
                Iterator iterator2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    CallableDescriptor callableDescriptor3 = (CallableDescriptor)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    void v7 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it");
                    Integer n = Visibilities.compare(v7.getVisibility(), targetVisibility);
                    collection2.add(n);
                }
                $receiver$iv = (List)destination$iv$iv;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        Integer it = (Integer)element$iv;
                        if (!(it == null || Intrinsics.compare((int)it, (int)0) > 0)) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
        }
        this.setText(this.getDefaultText());
        TextRange textRange = this.noModifierYetApplicabilityRange(element3);
        if (textRange == null) {
            return null;
        }
        TextRange defaultRange = textRange;
        if (element3 instanceof KtPrimaryConstructor && defaultRange.isEmpty() && KtPsiUtilKt.visibilityModifier(element3) == null) {
            this.setText("Make primary constructor " + this.modifier.getValue());
        }
        return modifierList != null ? new TextRange(PsiUtilsKt.getStartOffset((PsiElement)modifierList), defaultRange.getEndOffset()) : defaultRange;
    }

    @Override
    public void applyTo(@NotNull KtDeclaration element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiModificationUtilsKt.setVisibility(element3, this.modifier);
    }

    private final Visibility toVisibility(@NotNull KtModifierKeywordToken $receiver) {
        Visibility visibility;
        KtModifierKeywordToken ktModifierKeywordToken = $receiver;
        if (Intrinsics.areEqual((Object)((Object)ktModifierKeywordToken), (Object)((Object)KtTokens.PUBLIC_KEYWORD))) {
            Visibility visibility2 = Visibilities.PUBLIC;
            visibility = visibility2;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility2, (String)"Visibilities.PUBLIC");
        } else if (Intrinsics.areEqual((Object)((Object)ktModifierKeywordToken), (Object)((Object)KtTokens.PRIVATE_KEYWORD))) {
            Visibility visibility3 = Visibilities.PRIVATE;
            visibility = visibility3;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility3, (String)"Visibilities.PRIVATE");
        } else if (Intrinsics.areEqual((Object)((Object)ktModifierKeywordToken), (Object)((Object)KtTokens.PROTECTED_KEYWORD))) {
            Visibility visibility4 = Visibilities.PROTECTED;
            visibility = visibility4;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility4, (String)"Visibilities.PROTECTED");
        } else if (Intrinsics.areEqual((Object)((Object)ktModifierKeywordToken), (Object)((Object)KtTokens.INTERNAL_KEYWORD))) {
            Visibility visibility5 = Visibilities.INTERNAL;
            visibility = visibility5;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility5, (String)"Visibilities.INTERNAL");
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown visibility modifier:" + (Object)((Object)$receiver));
        }
        return visibility;
    }

    private final TextRange noModifierYetApplicabilityRange(KtDeclaration declaration2) {
        Object object;
        if (KtPsiUtil.isLocal(declaration2)) {
            return null;
        }
        KtDeclaration ktDeclaration = declaration2;
        if (ktDeclaration instanceof KtNamedFunction) {
            PsiElement psiElement2 = ((KtNamedFunction)declaration2).getFunKeyword();
            object = psiElement2 != null ? psiElement2.getTextRange() : null;
        } else if (ktDeclaration instanceof KtProperty) {
            PsiElement psiElement3 = ((KtProperty)declaration2).getValOrVarKeyword();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"declaration.valOrVarKeyword");
            object = psiElement3.getTextRange();
        } else if (ktDeclaration instanceof KtClass) {
            PsiElement psiElement4 = ((KtClass)declaration2).getClassOrInterfaceKeyword();
            object = psiElement4 != null ? psiElement4.getTextRange() : null;
        } else if (ktDeclaration instanceof KtObjectDeclaration) {
            PsiElement psiElement5 = ((KtObjectDeclaration)declaration2).getObjectKeyword();
            object = psiElement5 != null ? psiElement5.getTextRange() : null;
        } else if (ktDeclaration instanceof KtPrimaryConstructor) {
            KtParameterList ktParameterList = ((KtPrimaryConstructor)declaration2).getValueParameterList();
            if (ktParameterList != null) {
                KtParameterList ktParameterList2;
                KtParameterList it = ktParameterList2 = ktParameterList;
                object = TextRange.from((int)PsiUtilsKt.getStartOffset((PsiElement)it), (int)0);
            } else {
                object = null;
            }
        } else if (ktDeclaration instanceof KtSecondaryConstructor) {
            object = ((KtSecondaryConstructor)declaration2).getConstructorKeyword().getTextRange();
        } else if (ktDeclaration instanceof KtParameter) {
            PsiElement psiElement6 = ((KtParameter)declaration2).getValOrVarKeyword();
            object = psiElement6 != null ? psiElement6.getTextRange() : null;
        } else if (ktDeclaration instanceof KtTypeAlias) {
            PsiElement psiElement7 = ((KtTypeAlias)declaration2).getTypeAliasKeyword();
            object = psiElement7 != null ? psiElement7.getTextRange() : null;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isAnnotationClassPrimaryConstructor(@NotNull KtDeclaration element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!(element3 instanceof KtPrimaryConstructor)) return false;
        PsiElement psiElement2 = ((KtPrimaryConstructor)element3).getParent();
        if (!(psiElement2 instanceof KtClass)) {
            psiElement2 = null;
        }
        KtClass ktClass2 = (KtClass)psiElement2;
        if (ktClass2 == null) return false;
        boolean bl = ktClass2.hasModifier(KtTokens.ANNOTATION_KEYWORD);
        if (!bl) return false;
        return true;
    }

    @NotNull
    public final KtModifierKeywordToken getModifier() {
        return this.modifier;
    }

    protected ChangeVisibilityModifierIntention(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)modifier), (String)"modifier");
        super(KtDeclaration.class, "Make " + modifier.getValue(), null, 4, null);
        this.modifier = modifier;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention$Public;", "Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "idea"})
    public static final class Public
    extends ChangeVisibilityModifierIntention
    implements HighPriorityAction {
        public Public() {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PUBLIC_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PUBLIC_KEYWORD");
            super(ktModifierKeywordToken);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention$Private;", "Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "idea"})
    public static final class Private
    extends ChangeVisibilityModifierIntention
    implements HighPriorityAction {
        @Override
        @Nullable
        public TextRange applicabilityRange(@NotNull KtDeclaration element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            if (this.isAnnotationClassPrimaryConstructor(element3)) {
                return null;
            }
            return PsiModificationUtilsKt.canBePrivate(element3) ? super.applicabilityRange(element3) : null;
        }

        public Private() {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PRIVATE_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PRIVATE_KEYWORD");
            super(ktModifierKeywordToken);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention$Protected;", "Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "idea"})
    public static final class Protected
    extends ChangeVisibilityModifierIntention {
        @Override
        @Nullable
        public TextRange applicabilityRange(@NotNull KtDeclaration element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            return PsiModificationUtilsKt.canBeProtected(element3) ? super.applicabilityRange(element3) : null;
        }

        public Protected() {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PROTECTED_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PROTECTED_KEYWORD");
            super(ktModifierKeywordToken);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention$Internal;", "Lorg/jetbrains/kotlin/idea/intentions/ChangeVisibilityModifierIntention;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "idea"})
    public static final class Internal
    extends ChangeVisibilityModifierIntention {
        @Override
        @Nullable
        public TextRange applicabilityRange(@NotNull KtDeclaration element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            if (this.isAnnotationClassPrimaryConstructor(element3)) {
                return null;
            }
            return super.applicabilityRange(element3);
        }

        public Internal() {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.INTERNAL_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.INTERNAL_KEYWORD");
            super(ktModifierKeywordToken);
        }
    }
}

