/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.kdoc;

import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.kdoc.KDocRenderer;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001)B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00132\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002J&\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00042\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002J*\u0010\u0017\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u0016\u001a\u00020\u00042\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0018\u0010\u001b\u001a\u00020\f*\u00020\u001c2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002J\u0014\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\u00040\u0004*\u00020\u001fH\u0002J\u000e\u0010 \u001a\u0004\u0018\u00010\u001f*\u00020\u001cH\u0002J\f\u0010!\u001a\u00020\u0004*\u00020\u0004H\u0002J\f\u0010\"\u001a\u00020\u0004*\u00020#H\u0002J\u0010\u0010$\u001a\u00020\f*\u00060\u0010j\u0002`\u0011H\u0002J,\u0010%\u001a\u00020\f*\u00020#2\u001e\u0010&\u001a\u001a\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0(\u0012\u0004\u0012\u00020\f0'H\u0002\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer;", "", "()V", "markdownToHtml", "", "markdown", "allowSingleParagraph", "", "renderKDoc", "docComment", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocTag;", "renderSamplesList", "", "sampleTags", "", "to", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "renderSeeAlso", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocSection;", "renderTag", "tag", "title", "renderTagList", "tags", "trimCommonIndent", "text", "createHyperlink", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocLink;", "extractExampleText", "kotlin.jvm.PlatformType", "Lcom/intellij/psi/PsiElement;", "getTargetElement", "htmlEscape", "toHtml", "Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer$MarkdownNode;", "trimEnd", "visit", "action", "Lkotlin/Function2;", "Lkotlin/Function0;", "MarkdownNode", "idea"})
public final class KDocRenderer {
    public static final KDocRenderer INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderKDoc(@NotNull KDocTag docComment) {
        Intrinsics.checkParameterIsNotNull((Object)docComment, (String)"docComment");
        String content2 = docComment.getContent();
        StringBuilder result2 = new StringBuilder();
        result2.append(this.markdownToHtml(content2, true));
        if (docComment instanceof KDocSection) {
            void $receiver$iv$iv;
            void $receiver$iv$iv2;
            void $receiver$iv;
            Iterable $receiver$iv$iv3;
            Iterable $receiver$iv2;
            result2.append("\n");
            this.renderTag(((KDocSection)docComment).findTagByName("receiver"), "Receiver", result2);
            Iterable iterable = $receiver$iv2 = (Iterable)((KDocSection)docComment).findTagsByName("param");
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv3) {
                KDocTag it = (KDocTag)element$iv$iv;
                if (!(it.getSubjectName() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List paramTags = (List)destination$iv$iv;
            this.renderTagList(paramTags, "Parameters", result2);
            this.renderTag(((KDocSection)docComment).findTagByName("return"), "Returns", result2);
            $receiver$iv$iv3 = CollectionsKt.union((Iterable)((KDocSection)docComment).findTagsByName("exception"), (Iterable)((KDocSection)docComment).findTagsByName("throws"));
            destination$iv$iv = $receiver$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                KDocTag it = (KDocTag)element$iv$iv;
                if (!(it.getSubjectName() != null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List throwsTags = (List)destination$iv$iv2;
            this.renderTagList(throwsTags, "Throws", result2);
            this.renderTag(((KDocSection)docComment).findTagByName("author"), "Author", result2);
            this.renderTag(((KDocSection)docComment).findTagByName("since"), "Since", result2);
            this.renderSeeAlso((KDocSection)docComment, result2);
            Iterable $receiver$iv3 = ((KDocSection)docComment).findTagsByName("sample");
            destination$iv$iv2 = $receiver$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                KDocTag it = (KDocTag)element$iv$iv;
                if (!(it.getSubjectLink() != null)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List sampleTags = (List)destination$iv$iv3;
            this.renderSamplesList(sampleTags, result2);
        }
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    private final void createHyperlink(@NotNull KDocLink $receiver, StringBuilder to) {
        DocumentationManagerUtil.createHyperlink((StringBuilder)to, (String)$receiver.getLinkText(), (String)$receiver.getLinkText(), (boolean)false);
    }

    private final PsiElement getTargetElement(@NotNull KDocLink $receiver) {
        PsiElement $receiver$iv = (PsiElement)$receiver;
        Object[] objectArray = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, KDocName.class);
        if (objectArray == null) {
            objectArray = new KDocName[]{};
        }
        return ReferenceUtilKt.getMainReference((KDocName)ArraysKt.last((Object[])objectArray)).resolve();
    }

    private final String extractExampleText(@NotNull PsiElement $receiver) {
        String string;
        PsiElement psiElement2 = $receiver;
        if (psiElement2 instanceof KtDeclarationWithBody) {
            KtExpression bodyExpression = ((KtDeclarationWithBody)$receiver).getBodyExpression();
            KtExpression ktExpression = bodyExpression;
            if (ktExpression instanceof KtBlockExpression) {
                String string2 = ((KtBlockExpression)bodyExpression).getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"bodyExpression.text");
                string = StringsKt.removeSurrounding((String)string2, (CharSequence)"{", (CharSequence)"}");
            } else {
                KtExpression ktExpression2 = bodyExpression;
                if (ktExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"bodyExpression!!");
                string = ktExpression2.getText();
            }
        } else {
            string = $receiver.getText();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String trimCommonIndent(String text2) {
        String it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        trimCommonIndent.1 leadingIndent$ = trimCommonIndent.1.INSTANCE;
        List lines = StringsKt.split$default((CharSequence)text2, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        Iterable iterable = $receiver$iv = (Iterable)lines;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (String)element$iv$iv;
            CharSequence charSequence = it;
            String string = charSequence;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            Integer n = trimCommonIndent.1.INSTANCE.invoke((String)p1);
            collection.add(n);
        }
        Integer n = (Integer)CollectionsKt.min((Iterable)((List)destination$iv$iv));
        int minIndent = n != null ? n : 0;
        return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(minIndent){
            final /* synthetic */ int $minIndent;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return StringsKt.drop((String)it, (int)this.$minIndent);
            }
            {
                this.$minIndent = n;
                super(1);
            }
        }), (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSamplesList(List<? extends KDocTag> sampleTags, StringBuilder to) {
        void prefix$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        StringBuilder stringBuilder;
        StringBuilder $receiver;
        if (sampleTags.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder2 = $receiver = (stringBuilder = to);
        String tag$iv = "dl";
        void var7_7 = $receiver$iv;
        String string = '<' + tag$iv + '>';
        String postfix$iv$iv = "</" + tag$iv + '>';
        $receiver$iv$iv.append((String)prefix$iv$iv);
        $receiver.append("<dt><b>Samples:</b></dt>");
        Iterable $receiver$iv2 = sampleTags;
        for (Object element$iv : $receiver$iv2) {
            void prefix$iv$iv2;
            void $receiver$iv$iv2;
            void $receiver$iv3;
            KDocTag it = (KDocTag)element$iv;
            StringBuilder stringBuilder3 = $receiver;
            String tag$iv2 = "dd";
            void var16_16 = $receiver$iv3;
            String string2 = '<' + tag$iv2 + '>';
            String postfix$iv$iv2 = "</" + tag$iv2 + '>';
            $receiver$iv$iv2.append((String)prefix$iv$iv2);
            if (it.getSubjectLink() != null) {
                void prefix$iv$iv3;
                void $receiver$iv$iv3;
                void $receiver$iv4;
                void prefix$iv$iv4;
                void $receiver$iv$iv4;
                void $receiver$iv5;
                KDocLink kDocLink;
                KDocLink subjectLink = kDocLink;
                KDocRenderer.INSTANCE.createHyperlink(subjectLink, to);
                PsiElement target = KDocRenderer.INSTANCE.getTargetElement(subjectLink);
                StringBuilder stringBuilder4 = $receiver;
                String tag$iv3 = "pre";
                void var24_24 = $receiver$iv5;
                String string3 = '<' + tag$iv3 + '>';
                String postfix$iv$iv3 = "</" + tag$iv3 + '>';
                $receiver$iv$iv4.append((String)prefix$iv$iv4);
                StringBuilder stringBuilder5 = $receiver;
                String tag$iv4 = "code";
                void var29_29 = $receiver$iv4;
                String string4 = '<' + tag$iv4 + '>';
                String postfix$iv$iv4 = "</" + tag$iv4 + '>';
                $receiver$iv$iv3.append((String)prefix$iv$iv3);
                if (target == null) {
                    to.append("// Unresolved");
                } else {
                    String string5 = KDocRenderer.INSTANCE.extractExampleText(target);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"target.extractExampleText()");
                    to.append(KDocRenderer.INSTANCE.trimCommonIndent(string5));
                }
                $receiver$iv$iv3.append(postfix$iv$iv4);
                $receiver$iv$iv4.append(postfix$iv$iv3);
            }
            $receiver$iv$iv2.append(postfix$iv$iv2);
        }
        $receiver$iv$iv.append(postfix$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSeeAlso(KDocSection docComment, StringBuilder to) {
        List<KDocTag> seeTags = docComment.findTagsByName("see");
        if (seeTags.isEmpty()) {
            return;
        }
        to.append("<DD><DL>");
        to.append("<DT><b>").append("See Also:").append("</b>");
        to.append("<DD>");
        Iterable $receiver$iv = seeTags;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void tag;
            int n = index$iv++;
            KDocTag kDocTag = (KDocTag)item$iv;
            int index2 = n;
            String subjectName = tag.getSubjectName();
            if (subjectName != null) {
                DocumentationManagerUtil.createHyperlink((StringBuilder)to, (String)subjectName, (String)subjectName, (boolean)false);
            } else {
                to.append(tag.getContent());
            }
            if (index2 >= seeTags.size() - 1) continue;
            to.append(", ");
        }
        to.append("</DD></DL></DD>");
    }

    private final void renderTagList(List<? extends KDocTag> tags, String title, StringBuilder to) {
        if (tags.isEmpty()) {
            return;
        }
        to.append("<dl><dt><b>" + title + ":</b></dt>");
        Iterable $receiver$iv = tags;
        for (Object element$iv : $receiver$iv) {
            String string;
            KDocTag it = (KDocTag)element$iv;
            String string2 = string = it.getContent();
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            to.append("<dd><code>" + it.getSubjectName() + "</code> - " + KDocRenderer.markdownToHtml$default(INSTANCE, ((Object)StringsKt.trimStart((CharSequence)string2)).toString(), false, 2, null) + "</dd>");
        }
        to.append("</dl>\n");
    }

    private final void renderTag(KDocTag tag, String title, StringBuilder to) {
        if (tag != null) {
            to.append("<dl><dt><b>" + title + ":</b></dt>");
            to.append("<dd>" + KDocRenderer.markdownToHtml$default(this, tag.getContent(), false, 2, null) + "</dd>");
            to.append("</dl>\n");
        }
    }

    @NotNull
    public final String markdownToHtml(@NotNull String markdown, boolean allowSingleParagraph) {
        Object v0;
        MarkdownNode markdownNode;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)markdown, (String)"markdown");
            ASTNode markdownTree = new MarkdownParser((MarkdownFlavourDescriptor)new CommonMarkFlavourDescriptor()).buildMarkdownTreeFromString(markdown);
            markdownNode = new MarkdownNode(markdownTree, null, markdown);
            Iterable $receiver$iv = markdownNode.getChildren();
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                MarkdownNode it = (MarkdownNode)element$iv;
                if (!(Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL) ^ true)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        MarkdownNode maybeSingleParagraph = v0;
        return maybeSingleParagraph != null && !allowSingleParagraph ? CollectionsKt.joinToString$default((Iterable)maybeSingleParagraph.getChildren(), (CharSequence)"", null, null, (int)0, null, (Function1)markdownToHtml.1.INSTANCE, (int)30, null) : this.toHtml(markdownNode);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String markdownToHtml$default(KDocRenderer kDocRenderer, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kDocRenderer.markdownToHtml(string, bl);
    }

    private final void visit(@NotNull MarkdownNode $receiver, Function2<? super MarkdownNode, ? super Function0<Unit>, Unit> action2) {
        action2.invoke((Object)$receiver, (Object)new Function0<Unit>($receiver, action2){
            final /* synthetic */ MarkdownNode receiver$0;
            final /* synthetic */ Function2 $action;

            public final void invoke() {
                for (MarkdownNode child : this.receiver$0.getChildren()) {
                    KDocRenderer.access$visit(KDocRenderer.INSTANCE, child, this.$action);
                }
            }
            {
                this.receiver$0 = markdownNode;
                this.$action = function2;
                super(0);
            }
        });
    }

    private final String toHtml(@NotNull MarkdownNode $receiver) {
        String string;
        if (Intrinsics.areEqual((Object)$receiver.getNode().getType(), (Object)MarkdownTokenTypes.WHITE_SPACE)) {
            return $receiver.getText();
        }
        StringBuilder sb = new StringBuilder();
        this.visit($receiver, (Function2<? super MarkdownNode, ? super Function0<Unit>, Unit>)((Function2)new Function2<MarkdownNode, Function0<? extends Unit>, Unit>(sb){
            final /* synthetic */ StringBuilder $sb;

            public final void invoke(@NotNull MarkdownNode node, @NotNull Function0<Unit> processChildren) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Intrinsics.checkParameterIsNotNull(processChildren, (String)"processChildren");
                Function2<String, Boolean, Unit> wrapChildren$ = new Function2<String, Boolean, Unit>(this, processChildren){
                    final /* synthetic */ toHtml.1 this$0;
                    final /* synthetic */ Function0 $processChildren;

                    public final void invoke(@NotNull String tag, boolean newline) {
                        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
                        this.this$0.$sb.append('<' + tag + '>');
                        this.$processChildren.invoke();
                        this.this$0.$sb.append("</" + tag + '>');
                        if (newline) {
                            StringsKt.appendln((StringBuilder)this.this$0.$sb);
                        }
                    }

                    public static /* bridge */ /* synthetic */ void invoke$default(toHtml.1 var0, String string, boolean bl, int n, Object object) {
                        if ((n & 2) != 0) {
                            bl = false;
                        }
                        var0.invoke(string, bl);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$processChildren = function0;
                        super(2);
                    }
                };
                IElementType nodeType = node.getType();
                String nodeText = node.getText();
                IElementType iElementType = nodeType;
                if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.UNORDERED_LIST)) {
                    wrapChildren$.invoke("ul", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ORDERED_LIST)) {
                    wrapChildren$.invoke("ol", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LIST_ITEM)) {
                    toHtml.1.invoke$default(wrapChildren$, "li", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.EMPH)) {
                    toHtml.1.invoke$default(wrapChildren$, "em", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.STRONG)) {
                    toHtml.1.invoke$default(wrapChildren$, "strong", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_1)) {
                    toHtml.1.invoke$default(wrapChildren$, "h1", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_2)) {
                    toHtml.1.invoke$default(wrapChildren$, "h2", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_3)) {
                    toHtml.1.invoke$default(wrapChildren$, "h3", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_4)) {
                    toHtml.1.invoke$default(wrapChildren$, "h4", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_5)) {
                    toHtml.1.invoke$default(wrapChildren$, "h5", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_6)) {
                    toHtml.1.invoke$default(wrapChildren$, "h6", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.BLOCK_QUOTE)) {
                    toHtml.1.invoke$default(wrapChildren$, "blockquote", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH)) {
                    KDocRenderer.access$trimEnd(KDocRenderer.INSTANCE, this.$sb);
                    wrapChildren$.invoke("p", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_SPAN)) {
                    String startDelimiter;
                    MarkdownNode markdownNode = node.child(MarkdownTokenTypes.BACKTICK);
                    String string = startDelimiter = markdownNode != null ? markdownNode.getText() : null;
                    if (startDelimiter != null) {
                        String string2 = node.getText();
                        int n = startDelimiter.length();
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.substring(n);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                        String text2 = StringsKt.removeSuffix((String)string4, (CharSequence)startDelimiter);
                        this.$sb.append("<code>").append(KDocRenderer.access$htmlEscape(KDocRenderer.INSTANCE, text2)).append("</code>");
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_BLOCK) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE)) {
                    KDocRenderer.access$trimEnd(KDocRenderer.INSTANCE, this.$sb);
                    this.$sb.append("<pre><code>");
                    processChildren.invoke();
                    this.$sb.append("</code></pre>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.SHORT_REFERENCE_LINK) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.FULL_REFERENCE_LINK)) {
                    List linkLabelContent;
                    List list2;
                    MarkdownNode linkLabelNode = node.child(MarkdownElementTypes.LINK_LABEL);
                    Object object = linkLabelNode;
                    if (object != null && (object = ((MarkdownNode)object).getChildren()) != null) {
                        List $receiver$iv;
                        Iterable iterable = (Iterable)object;
                        boolean yielding$iv = false;
                        ArrayList<T> list$iv = new ArrayList<T>();
                        for (T item$iv : $receiver$iv) {
                            if (yielding$iv) {
                                list$iv.add(item$iv);
                                continue;
                            }
                            MarkdownNode it = (MarkdownNode)item$iv;
                            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET)) continue;
                            list$iv.add(item$iv);
                            yielding$iv = true;
                        }
                        $receiver$iv = list$iv;
                        if (!$receiver$iv.isEmpty()) {
                            ListIterator<E> iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                            while (iterator$iv.hasPrevious()) {
                                MarkdownNode it = (MarkdownNode)iterator$iv.previous();
                                if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET)) continue;
                                list2 = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                                break;
                            }
                        } else {
                            list2 = CollectionsKt.emptyList();
                        }
                    } else {
                        list2 = linkLabelContent = null;
                    }
                    if (linkLabelContent != null) {
                        String label2 = CollectionsKt.joinToString$default((Iterable)linkLabelContent, (CharSequence)"", null, null, (int)0, null, (Function1)toHtml.label.1.INSTANCE, (int)30, null);
                        Object object2 = node.child(MarkdownElementTypes.LINK_TEXT);
                        if (object2 == null || (object2 = KDocRenderer.access$toHtml(KDocRenderer.INSTANCE, (MarkdownNode)object2)) == null) {
                            object2 = label2;
                        }
                        Object linkText = object2;
                        DocumentationManagerUtil.createHyperlink((StringBuilder)this.$sb, (String)label2, (String)linkText, (boolean)true);
                    } else {
                        this.$sb.append(node.getText());
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.INLINE_LINK)) {
                    String destination;
                    MarkdownNode markdownNode = node.child(MarkdownElementTypes.LINK_TEXT);
                    String label3 = markdownNode != null ? KDocRenderer.access$toHtml(KDocRenderer.INSTANCE, markdownNode) : null;
                    MarkdownNode markdownNode2 = node.child(MarkdownElementTypes.LINK_DESTINATION);
                    String string = destination = markdownNode2 != null ? markdownNode2.getText() : null;
                    if (label3 != null && destination != null) {
                        this.$sb.append("<a href=\"" + destination + "\">" + label3 + "</a>");
                    } else {
                        this.$sb.append(node.getText());
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.TEXT) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.WHITE_SPACE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.COLON) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.SINGLE_QUOTE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.DOUBLE_QUOTE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LPAREN) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.RPAREN) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LBRACKET) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.RBRACKET) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EXCLAMATION_MARK)) {
                    this.$sb.append(nodeText);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_LINE)) {
                    this.$sb.append(KDocRenderer.access$htmlEscape(KDocRenderer.INSTANCE, StringsKt.removePrefix((String)nodeText, (CharSequence)KDocTag.Companion.getIndentationWhiteSpaces())));
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT)) {
                    this.$sb.append(KDocRenderer.access$htmlEscape(KDocRenderer.INSTANCE, nodeText));
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EOL)) {
                    IElementType parentType;
                    MarkdownNode markdownNode = node.getParent();
                    Object object = parentType = markdownNode != null ? markdownNode.getType() : null;
                    if (Intrinsics.areEqual((Object)parentType, (Object)MarkdownElementTypes.CODE_BLOCK) || Intrinsics.areEqual((Object)parentType, (Object)MarkdownElementTypes.CODE_FENCE)) {
                        this.$sb.append("\n");
                    } else {
                        this.$sb.append(" ");
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.GT)) {
                    this.$sb.append("&gt;");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LT)) {
                    this.$sb.append("&lt;");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LINK_TEXT)) {
                    List childrenWithoutBrackets = CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)node.getChildren(), (int)1), (int)1);
                    for (MarkdownNode child : childrenWithoutBrackets) {
                        this.$sb.append(KDocRenderer.access$toHtml(KDocRenderer.INSTANCE, child));
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EMPH)) {
                    IElementType parentNodeType;
                    MarkdownNode markdownNode = node.getParent();
                    Object object = parentNodeType = markdownNode != null ? markdownNode.getType() : null;
                    if (Intrinsics.areEqual((Object)parentNodeType, (Object)MarkdownElementTypes.EMPH) ^ true && Intrinsics.areEqual((Object)parentNodeType, (Object)MarkdownElementTypes.STRONG) ^ true) {
                        this.$sb.append(node.getText());
                    }
                } else {
                    processChildren.invoke();
                }
            }
            {
                this.$sb = stringBuilder;
                super(2);
            }
        }));
        String string2 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sb.toString()");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trimEnd((CharSequence)string3)).toString();
    }

    private final void trimEnd(@NotNull StringBuilder $receiver) {
        while ($receiver.length() > 0 && $receiver.charAt($receiver.length() - 1) == ' ') {
            $receiver.deleteCharAt($receiver.length() - 1);
        }
    }

    private final String htmlEscape(@NotNull String $receiver) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$receiver, (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null);
    }

    private KDocRenderer() {
    }

    static {
        KDocRenderer kDocRenderer;
        INSTANCE = kDocRenderer = new KDocRenderer();
    }

    @NotNull
    public static final /* synthetic */ String access$toHtml(KDocRenderer $this, @NotNull MarkdownNode $receiver) {
        return $this.toHtml($receiver);
    }

    public static final /* synthetic */ void access$visit(KDocRenderer $this, @NotNull MarkdownNode $receiver, @NotNull Function2 action2) {
        $this.visit($receiver, (Function2<? super MarkdownNode, ? super Function0<Unit>, Unit>)action2);
    }

    public static final /* synthetic */ void access$trimEnd(KDocRenderer $this, @NotNull StringBuilder $receiver) {
        $this.trimEnd($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$htmlEscape(KDocRenderer $this, @NotNull String $receiver) {
        return $this.htmlEscape($receiver);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001a\u001a\u00020\u001bR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer$MarkdownNode;", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "parent", "markdown", "", "(Lorg/intellij/markdown/ast/ASTNode;Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer$MarkdownNode;Ljava/lang/String;)V", "children", "", "getChildren", "()Ljava/util/List;", "endOffset", "", "getEndOffset", "()I", "getMarkdown", "()Ljava/lang/String;", "getNode", "()Lorg/intellij/markdown/ast/ASTNode;", "getParent", "()Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer$MarkdownNode;", "startOffset", "getStartOffset", "text", "getText", "type", "Lorg/intellij/markdown/IElementType;", "getType", "()Lorg/intellij/markdown/IElementType;", "child", "idea"})
    public static final class MarkdownNode {
        @NotNull
        private final List<MarkdownNode> children;
        @NotNull
        private final ASTNode node;
        @Nullable
        private final MarkdownNode parent;
        @NotNull
        private final String markdown;

        @NotNull
        public final List<MarkdownNode> getChildren() {
            return this.children;
        }

        public final int getEndOffset() {
            return this.node.getEndOffset();
        }

        public final int getStartOffset() {
            return this.node.getStartOffset();
        }

        @NotNull
        public final IElementType getType() {
            return this.node.getType();
        }

        @NotNull
        public final String getText() {
            String string = this.markdown;
            int n = this.getStartOffset();
            int n2 = this.getEndOffset();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }

        @Nullable
        public final MarkdownNode child(@NotNull IElementType type2) {
            Object v0;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                Iterable $receiver$iv = this.children;
                for (Object element$iv : $receiver$iv) {
                    MarkdownNode it = (MarkdownNode)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)type2)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @NotNull
        public final ASTNode getNode() {
            return this.node;
        }

        @Nullable
        public final MarkdownNode getParent() {
            return this.parent;
        }

        @NotNull
        public final String getMarkdown() {
            return this.markdown;
        }

        /*
         * WARNING - void declaration
         */
        public MarkdownNode(@NotNull ASTNode node, @Nullable MarkdownNode parent2, @NotNull String markdown) {
            Collection<MarkdownNode> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)markdown, (String)"markdown");
            this.node = node;
            this.parent = parent2;
            this.markdown = markdown;
            Iterable iterable = this.node.getChildren();
            MarkdownNode markdownNode = this;
            void var5_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ASTNode aSTNode = (ASTNode)item$iv$iv;
                collection = destination$iv$iv;
                MarkdownNode markdownNode2 = new MarkdownNode((ASTNode)it, this, this.markdown);
                collection.add(markdownNode2);
            }
            collection = (List)destination$iv$iv;
            markdownNode.children = collection;
        }
    }
}

