/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInliner.CallableUsageReplacementStrategy;
import org.jetbrains.kotlin.idea.codeInliner.CodeToInline;
import org.jetbrains.kotlin.idea.refactoring.inline.InlineUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineFunctionDialog;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u00020\u0004*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0004*\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineFunctionHandler;", "Lcom/intellij/lang/refactoring/InlineActionHandler;", "()V", "canInlineElement", "", "element", "Lcom/intellij/psi/PsiElement;", "inlineElement", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isEnabledForLanguage", "language", "Lcom/intellij/lang/Language;", "includesCallOf", "Lorg/jetbrains/kotlin/psi/KtExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isRecursive", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "idea"})
public final class KotlinInlineFunctionHandler
extends InlineActionHandler {
    public boolean isEnabledForLanguage(@NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        return Intrinsics.areEqual((Object)language, (Object)((Object)KotlinLanguage.INSTANCE));
    }

    public boolean canInlineElement(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return element3 instanceof KtNamedFunction && ((KtNamedFunction)element3).hasBody();
    }

    public void inlineElement(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element3) {
        KtSimpleNameReference ktSimpleNameReference;
        PsiReference psiReference;
        Editor it;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtNamedFunction cfr_ignored_0 = (KtNamedFunction)element3;
        Editor editor2 = editor;
        if (editor2 != null) {
            Editor editor3;
            it = editor3 = editor2;
            CaretModel caretModel = it.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"it.caretModel");
            psiReference = TargetElementUtil.findReference((Editor)it, (int)caretModel.getOffset());
        } else {
            psiReference = null;
        }
        PsiReference reference2 = psiReference;
        it = reference2;
        if (it instanceof KtSimpleNameReference) {
            ktSimpleNameReference = (KtSimpleNameReference)reference2;
        } else if (it instanceof PsiMultiReference) {
            Object object;
            block13: {
                PsiReference[] psiReferenceArray = ((PsiMultiReference)reference2).getReferences();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"reference.references");
                Object[] $receiver$iv = psiReferenceArray;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    if (!(element$iv instanceof KtSimpleNameReference)) continue;
                    object = element$iv;
                    break block13;
                }
                object = null;
            }
            ktSimpleNameReference = (KtSimpleNameReference)object;
        } else {
            ktSimpleNameReference = null;
        }
        KtSimpleNameReference nameReference = ktSimpleNameReference;
        boolean recursive = this.isRecursive((KtNamedFunction)element3);
        if (recursive && nameReference == null) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)"Inline recursive function is supported only on references");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)"Inline Function", null);
            return;
        }
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)element3, null, 1, null);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor");
        }
        SimpleFunctionDescriptor descriptor2 = (SimpleFunctionDescriptor)declarationDescriptor;
        KtDeclaration ktDeclaration = (KtDeclaration)element3;
        KotlinType kotlinType = descriptor2.getReturnType();
        boolean bl = ((KtNamedFunction)element3).hasDeclaredReturnType();
        KtExpression ktExpression = ((KtNamedFunction)element3).getBodyExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.bodyExpression!!");
        CodeToInline codeToInline = InlineUtilsKt.buildCodeToInline(ktDeclaration, kotlinType, bl, ktExpression, ((KtNamedFunction)element3).hasBlockBody(), editor);
        if (codeToInline == null) {
            return;
        }
        CodeToInline codeToInline2 = codeToInline;
        CallableUsageReplacementStrategy replacementStrategy = new CallableUsageReplacementStrategy(codeToInline2);
        KotlinInlineFunctionDialog dialog2 = new KotlinInlineFunctionDialog(project, (KtNamedFunction)element3, nameReference, replacementStrategy, recursive);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) {
            dialog2.show();
        } else {
            dialog2.doAction();
        }
    }

    private final boolean isRecursive(@NotNull KtNamedFunction $receiver) {
        boolean bl;
        BindingContext context = ResolutionUtils.analyzeFully($receiver);
        KtExpression ktExpression = $receiver.getBodyExpression();
        if (ktExpression != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)context.get(BindingContext.FUNCTION, $receiver);
            if (simpleFunctionDescriptor == null) {
                return false;
            }
            bl = this.includesCallOf(ktExpression, simpleFunctionDescriptor, context);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean includesCallOf(@NotNull KtExpression $receiver, FunctionDescriptor descriptor2, BindingContext context) {
        void result$iv$iv$iv;
        void $receiver$iv;
        void $receiver$iv$iv;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, context);
        CallableDescriptor refDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
        if (Intrinsics.areEqual((Object)descriptor2, (Object)refDescriptor)) return true;
        PsiElement psiElement2 = (PsiElement)$receiver;
        Function1 predicate$iv = (Function1)new Function1<KtExpression, Boolean>($receiver, descriptor2, context){
            final /* synthetic */ KtExpression receiver$0;
            final /* synthetic */ FunctionDescriptor $descriptor;
            final /* synthetic */ BindingContext $context;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull KtExpression it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (it == this.receiver$0) return false;
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(it, this.$context);
                if (!Intrinsics.areEqual((Object)this.$descriptor, (Object)(resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null))) return false;
                return true;
            }
            {
                this.receiver$0 = ktExpression;
                this.$descriptor = functionDescriptor2;
                this.$context = bindingContext2;
                super(1);
            }
        };
        void $receiver$iv$iv$iv = $receiver$iv$iv = $receiver$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $receiver$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (element3 instanceof KtExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                    this.$result.element = element3;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element3;
                super.visitElement(element3);
            }
        });
        if ((PsiElement)result$iv$iv$iv.element == null) return false;
        return true;
    }
}

