/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.spring.diagram;

import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.AbstractSimpleLocalModel;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.diagram.SpringLocalModelDependenciesDiagramProvider;
import com.intellij.spring.contexts.model.diagram.SpringLocalModelDiagramNodeContentManager;
import com.intellij.spring.contexts.model.diagram.SpringLocalModelsDataModel;
import com.intellij.spring.contexts.model.diagram.beans.FilesetLocalModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.ModuleLocalModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.SpringLocalModelDependencyEdge;
import com.intellij.spring.contexts.model.diagram.beans.SpringLocalModelDiagramNode;
import com.intellij.spring.contexts.model.graph.LazyModelDependenciesGraph;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/spring/diagram/KotlinSpringLocalModelDependenciesDiagramProvider;", "Lcom/intellij/spring/contexts/model/diagram/SpringLocalModelDependenciesDiagramProvider;", "()V", "createDataModel", "Lcom/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel;", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/spring/contexts/model/diagram/beans/LocalModelGraphElementWrapper;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "presentationModel", "Lcom/intellij/diagram/DiagramPresentationModel;", "getID", "", "KotlinSpringLocalModelsDataModel", "ultimate"})
public final class KotlinSpringLocalModelDependenciesDiagramProvider
extends SpringLocalModelDependenciesDiagramProvider {
    @NotNull
    public String getID() {
        return "KotlinSpringLocalModels";
    }

    @Nullable
    public SpringLocalModelsDataModel createDataModel(@NotNull Project project, @Nullable LocalModelGraphElementWrapper<?> element3, @Nullable VirtualFile file2, @Nullable DiagramPresentationModel presentationModel) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (element3 == null) {
            return null;
        }
        return new KotlinSpringLocalModelsDataModel(project, element3, true);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ4\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010\u001e\u001a\u00020\r2\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002Jb\u0010\u001f\u001a\\\u0012X\u0012V\u0012$\u0012\"\u0012\f\u0012\n #*\u0004\u0018\u00010\"0\" #*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a8\u0006\u00010\u0005\u00a8\u0006\u0001 #**\u0012$\u0012\"\u0012\f\u0012\n #*\u0004\u0018\u00010\"0\" #*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a8\u0006\u00010\u0005\u00a8\u0006\u0001\u0018\u00010!0!0 H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0016J\u0016\u0010%\u001a\u00020\u00072\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0\u0005H\u0002J\b\u0010'\u001a\u00020\u0007H\u0002J\b\u0010(\u001a\u00020\u0015H\u0014J\u001a\u0010)\u001a\u00020\u00152\b\u0010*\u001a\u0004\u0018\u00010\r2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f8BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/idea/spring/diagram/KotlinSpringLocalModelDependenciesDiagramProvider$KotlinSpringLocalModelsDataModel;", "Lcom/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/spring/contexts/model/diagram/beans/LocalModelGraphElementWrapper;", "showModuleFilesetNodes", "", "(Lorg/jetbrains/kotlin/idea/spring/diagram/KotlinSpringLocalModelDependenciesDiagramProvider;Lcom/intellij/openapi/project/Project;Lcom/intellij/spring/contexts/model/diagram/beans/LocalModelGraphElementWrapper;Z)V", "extraEdges", "Ljava/util/LinkedHashSet;", "Lcom/intellij/spring/contexts/model/diagram/beans/SpringLocalModelDependencyEdge;", "extraNodes", "Lcom/intellij/spring/contexts/model/diagram/beans/SpringLocalModelDiagramNode;", "nodesSequence", "Lkotlin/sequences/Sequence;", "nodesSequence$annotations", "()V", "getNodesSequence", "()Lkotlin/sequences/Sequence;", "createEdgeToLocalModelAndVisitIt", "", "fromNode", "graph", "Lcom/intellij/spring/contexts/model/graph/LazyModelDependenciesGraph;", "toNodeLocalModelWrapper", "Lcom/intellij/spring/contexts/model/diagram/beans/LocalModelWrapper;", "Lcom/intellij/spring/contexts/model/LocalModel;", "dependency", "Lcom/intellij/spring/contexts/model/graph/LocalModelDependency;", "getDiagramNode", "getEdges", "", "Lcom/intellij/diagram/DiagramEdge;", "", "kotlin.jvm.PlatformType", "getNodes", "isLibraryConfig", "element", "showLibraryConfigs", "updateDataModel", "visitFileSet", "node", "fileSet", "Lcom/intellij/spring/facet/SpringFileSet;", "visitModule", "module", "Lcom/intellij/openapi/module/Module;", "visitRelated", "ultimate"})
    public final class KotlinSpringLocalModelsDataModel
    extends SpringLocalModelsDataModel {
        private final LinkedHashSet<SpringLocalModelDiagramNode> extraNodes;
        private final LinkedHashSet<SpringLocalModelDependencyEdge> extraEdges;
        private final LocalModelGraphElementWrapper<?> model;
        private final boolean showModuleFilesetNodes;

        private static /* synthetic */ void nodesSequence$annotations() {
        }

        private final Sequence<SpringLocalModelDiagramNode> getNodesSequence() {
            Collection collection = super.getNodes();
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<com.intellij.spring.contexts.model.diagram.beans.SpringLocalModelDiagramNode>");
            }
            return SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)collection), (Sequence)CollectionsKt.asSequence((Iterable)this.extraNodes));
        }

        private final SpringLocalModelDiagramNode getDiagramNode(LocalModelGraphElementWrapper<?> model) {
            SpringLocalModelDiagramNode springLocalModelDiagramNode;
            Object v0;
            block2: {
                Sequence<SpringLocalModelDiagramNode> $receiver$iv = this.getNodesSequence();
                for (Object element$iv : $receiver$iv) {
                    SpringLocalModelDiagramNode it = (SpringLocalModelDiagramNode)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getIdentifyingElement(), model)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            if ((springLocalModelDiagramNode = (SpringLocalModelDiagramNode)v0) == null) {
                springLocalModelDiagramNode = new SpringLocalModelDiagramNode(model, this.getProvider());
            }
            return springLocalModelDiagramNode;
        }

        private final boolean showLibraryConfigs() {
            return new DiagramState(this.getBuilder()).isCategoryEnabled(SpringLocalModelDiagramNodeContentManager.SHOW_LIBRARY_CONFIGS);
        }

        private final boolean isLibraryConfig(LocalModelGraphElementWrapper<Object> element3) {
            if (!(element3 instanceof LocalModelWrapper)) {
                return false;
            }
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
            ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
            LocalModel localModel = ((LocalModelWrapper)element3).getElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)localModel, (String)"element.element");
            PsiElement psiElement2 = localModel.getConfig();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.element.config");
            PsiFile psiFile = psiElement2.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"element.element.config.containingFile");
            return projectFileIndex.isInLibraryClasses(psiFile.getVirtualFile());
        }

        private final void visitRelated(SpringLocalModelDiagramNode fromNode, LazyModelDependenciesGraph graph2) {
            LocalModelWrapper localModelWrapper;
            LocalModelGraphElementWrapper localModelGraphElementWrapper = fromNode.getIdentifyingElement();
            if (!(localModelGraphElementWrapper instanceof LocalModelWrapper)) {
                localModelGraphElementWrapper = null;
            }
            if ((localModelWrapper = (LocalModelWrapper)localModelGraphElementWrapper) == null || (localModelWrapper = localModelWrapper.getElement()) == null) {
                return;
            }
            LocalModelWrapper localModel = localModelWrapper;
            for (Pair pair2 : graph2.getOrCreateOutDependencies((Object)localModel)) {
                LocalModel model = (LocalModel)ExtensionsKt.component1((Pair)pair2);
                LocalModelDependency dependency = (LocalModelDependency)ExtensionsKt.component2((Pair)pair2);
                LocalModelWrapper localModelWrapper2 = LocalModelWrapper.create((LocalModel)model);
                Intrinsics.checkExpressionValueIsNotNull((Object)localModelWrapper2, (String)"LocalModelWrapper.create(model)");
                LocalModelDependency localModelDependency = dependency;
                Intrinsics.checkExpressionValueIsNotNull((Object)localModelDependency, (String)"dependency");
                this.createEdgeToLocalModelAndVisitIt(fromNode, graph2, localModelWrapper2, localModelDependency);
            }
        }

        private final void createEdgeToLocalModelAndVisitIt(SpringLocalModelDiagramNode fromNode, LazyModelDependenciesGraph graph2, LocalModelWrapper<LocalModel<?>> toNodeLocalModelWrapper, LocalModelDependency dependency) {
            boolean toNodeExists;
            SpringLocalModelDiagramNode toNode;
            block7: {
                block8: {
                    toNode = this.getDiagramNode((LocalModelGraphElementWrapper)toNodeLocalModelWrapper);
                    if (toNode == fromNode) {
                        return;
                    }
                    toNodeExists = this.extraNodes.contains(toNode);
                    if (toNodeExists) break block7;
                    Collection collection = this.extraNodes;
                    collection.add(toNode);
                    if (this.showLibraryConfigs()) break block8;
                    LocalModelGraphElementWrapper localModelGraphElementWrapper = toNode.getIdentifyingElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)localModelGraphElementWrapper, (String)"toNode.identifyingElement");
                    if (this.isLibraryConfig((LocalModelGraphElementWrapper<Object>)localModelGraphElementWrapper)) break block7;
                }
                this.visitRelated(toNode, graph2);
            }
            if (fromNode != null) {
                SpringLocalModelDependencyEdge edge = new SpringLocalModelDependencyEdge((DiagramNode)fromNode, (DiagramNode)toNode, dependency);
                if (toNodeExists) {
                    edge.setError(true);
                } else {
                    fromNode.addChild(toNode);
                }
                Collection collection = this.extraEdges;
                collection.add(edge);
            }
        }

        private final void visitFileSet(SpringLocalModelDiagramNode node, SpringFileSet fileSet) {
            SpringManager springManager = SpringManager.getInstance((Project)this.getProject());
            SpringFacet springFacet = fileSet.getFacet();
            Intrinsics.checkExpressionValueIsNotNull((Object)springFacet, (String)"fileSet.facet");
            Module module = springFacet.getModule();
            Set profiles = fileSet.getActiveProfiles();
            LazyModelDependenciesGraph graph2 = AbstractSimpleLocalModel.getOrCreateLocalModelDependenciesGraph((Module)module, (Set)profiles);
            Iterator iterator2 = fileSet.getFiles().iterator();
            while (iterator2.hasNext()) {
                KtFile ktFile;
                VirtualFile virtualFile2;
                VirtualFilePointer filePointer;
                VirtualFilePointer virtualFilePointer = filePointer = (VirtualFilePointer)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFilePointer, (String)"filePointer");
                if (virtualFilePointer.getFile() == null) {
                    continue;
                }
                VirtualFile virtualFile3 = virtualFile2;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
                Project project = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                PsiFile psiFile = KotlinRefactoringUtilKt.toPsiFile(virtualFile3, project);
                if (!(psiFile instanceof KtFile)) {
                    psiFile = null;
                }
                if ((KtFile)psiFile == null) {
                    continue;
                }
                PsiClass[] psiClassArray = ktFile.getClasses();
                for (int i = 0; i < psiClassArray.length; ++i) {
                    LocalAnnotationModel model;
                    PsiClass psiClass2 = psiClassArray[i];
                    if (springManager.getLocalSpringModel(psiClass2, module) == null) {
                        continue;
                    }
                    LazyModelDependenciesGraph lazyModelDependenciesGraph = graph2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)lazyModelDependenciesGraph, (String)"graph");
                    LocalModelWrapper localModelWrapper = LocalModelWrapper.create((LocalModel)((LocalModel)model));
                    Intrinsics.checkExpressionValueIsNotNull((Object)localModelWrapper, (String)"LocalModelWrapper.create(model)");
                    LocalModelDependency localModelDependency = LocalModelDependency.create();
                    Intrinsics.checkExpressionValueIsNotNull((Object)localModelDependency, (String)"LocalModelDependency.create()");
                    this.createEdgeToLocalModelAndVisitIt(node, lazyModelDependenciesGraph, localModelWrapper, localModelDependency);
                }
            }
        }

        private final void visitFileSet(SpringFileSet fileSet) {
            SpringLocalModelDiagramNode springLocalModelDiagramNode;
            if (this.showModuleFilesetNodes) {
                LocalModelGraphElementWrapper localModelGraphElementWrapper = FilesetLocalModelWrapper.create((SpringFileSet)fileSet);
                if (localModelGraphElementWrapper == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)localModelGraphElementWrapper, (String)"FilesetLocalModelWrapper.create(fileSet)!!");
                springLocalModelDiagramNode = this.getDiagramNode(localModelGraphElementWrapper);
            } else {
                springLocalModelDiagramNode = null;
            }
            this.visitFileSet(springLocalModelDiagramNode, fileSet);
        }

        private final void visitModule(Module module) {
            if (module.isDisposed()) {
                return;
            }
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            if (springFacet == null) {
                return;
            }
            SpringFacet springFacet2 = springFacet;
            Iterator iterator2 = SpringFileSetService.getInstance().getAllSets(springFacet2).iterator();
            while (iterator2.hasNext()) {
                SpringFileSet fileSet;
                SpringFileSet springFileSet = fileSet = (SpringFileSet)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)springFileSet, (String)"fileSet");
                this.visitFileSet(springFileSet);
            }
        }

        protected void updateDataModel() {
            super.updateDataModel();
            LocalModelGraphElementWrapper<?> localModelGraphElementWrapper = this.model;
            if (localModelGraphElementWrapper instanceof ModuleLocalModelWrapper) {
                Module module = (Module)((ModuleLocalModelWrapper)this.model).getElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"model.element");
                this.visitModule(module);
            } else if (localModelGraphElementWrapper instanceof FilesetLocalModelWrapper) {
                SpringFileSet springFileSet = (SpringFileSet)((FilesetLocalModelWrapper)this.model).getElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)springFileSet, (String)"model.element");
                this.visitFileSet(springFileSet);
            }
        }

        @NotNull
        public LinkedHashSet<SpringLocalModelDiagramNode> getNodes() {
            return (LinkedHashSet)SequencesKt.toCollection(this.getNodesSequence(), (Collection)new LinkedHashSet());
        }

        @NotNull
        public List<DiagramEdge<LocalModelGraphElementWrapper<Object>>> getEdges() {
            Collection collection = super.getEdges();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"super.getEdges()");
            return CollectionsKt.plus((Collection)collection, (Iterable)this.extraEdges);
        }

        public KotlinSpringLocalModelsDataModel(@NotNull Project project, LocalModelGraphElementWrapper<?> model, boolean showModuleFilesetNodes) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(model, (String)"model");
            super(project, (DiagramProvider)KotlinSpringLocalModelDependenciesDiagramProvider.this, model, showModuleFilesetNodes);
            this.model = model;
            this.showModuleFilesetNodes = showModuleFilesetNodes;
            this.extraNodes = new LinkedHashSet();
            this.extraEdges = new LinkedHashSet();
        }
    }
}

